/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;

public class MorfologikSpanishSpellerRule
extends MorfologikSpellerRule {
    private static final Pattern PREFIX_WITH_WHITESPACE = Pattern.compile("^(tele|anti|auto|ex|extra|macro|mega|meta|micro|multi|mono|mini|post|retro|semi|super|hiper|trans|re|g) (..+)$", 66);
    private static final Pattern PARTICULA_FINAL = Pattern.compile("^(..+) (que|cual)$", 66);

    public MorfologikSpanishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.setIgnoreTaggedWords();
    }

    public String getFileName() {
        return "/es/es-ES.dict";
    }

    public final String getId() {
        return "MORFOLOGIK_RULE_ES";
    }

    public boolean useInOffice() {
        return true;
    }

    protected List<SuggestedReplacement> orderSuggestions(List<SuggestedReplacement> suggestions, String word) {
        ArrayList<SuggestedReplacement> newSuggestions = new ArrayList<SuggestedReplacement>();
        for (int i = 0; i < suggestions.size(); ++i) {
            if (PREFIX_WITH_WHITESPACE.matcher(suggestions.get(i).getReplacement()).matches()) continue;
            Matcher matcher = PARTICULA_FINAL.matcher(suggestions.get(i).getReplacement());
            if (matcher.matches()) {
                newSuggestions.add(0, suggestions.get(i));
                continue;
            }
            newSuggestions.add(suggestions.get(i));
        }
        return newSuggestions;
    }
}

