/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.es.MorfologikSpanishSpellerRule;
import org.languagetool.rules.es.QuestionMarkRule;
import org.languagetool.rules.es.SimpleReplaceRule;
import org.languagetool.rules.es.SimpleReplaceVerbsRule;
import org.languagetool.rules.es.SpanishConfusionProbabilityRule;
import org.languagetool.rules.es.SpanishUnpairedBracketsRule;
import org.languagetool.rules.es.SpanishWikipediaRule;
import org.languagetool.rules.es.SpanishWordRepeatRule;
import org.languagetool.rules.es.SpanishWrongWordInContextRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.es.SpanishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.es.SpanishHybridDisambiguator;
import org.languagetool.tagging.es.SpanishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.es.SpanishWordTokenizer;

public class Spanish
extends Language
implements AutoCloseable {
    private static final Language DEFAULT_VARIANT = new Spanish();
    private LanguageModel languageModel;

    public String getName() {
        return "Spanish";
    }

    public String getShortCode() {
        return "es";
    }

    public String[] getCountries() {
        return new String[]{"ES", "", "MX", "GT", "CR", "PA", "DO", "VE", "PE", "AR", "EC", "CL", "UY", "PY", "BO", "SV", "HN", "NI", "PR", "US", "CU"};
    }

    public Language getDefaultLanguageVariant() {
        return DEFAULT_VARIANT;
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return SpanishTagger.INSTANCE;
    }

    public Disambiguator createDefaultDisambiguator() {
        return new SpanishHybridDisambiguator();
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new SpanishWordTokenizer();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new SpanishSynthesizer(this);
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Juan Martorell", "http://languagetool-es.blogspot.com/"), new Contributor("Jaume Ortol\u00e0")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"En su opini\u00f3n<marker> ,</marker> no era verdad."), Example.fixed((String)"En su opini\u00f3n<marker>,</marker> no era verdad.")), new DoublePunctuationRule(messages), new SpanishUnpairedBracketsRule(messages), new QuestionMarkRule(messages), new MorfologikSpanishSpellerRule(messages, this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Venta al p\u00fablico. <marker>ha</marker> subido mucho."), Example.fixed((String)"Venta al p\u00fablico. <marker>Ha</marker> subido mucho.")), new SpanishWordRepeatRule(messages, this), new MultipleWhitespaceRule(messages, (Language)this), new SpanishWikipediaRule(messages), new SpanishWrongWordInContextRule(messages), new LongSentenceRule(messages, userConfig, 50), new LongParagraphRule(messages, (Language)this, userConfig), new SimpleReplaceRule(messages), new SimpleReplaceVerbsRule(messages, this)});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new SpanishConfusionProbabilityRule(messages, languageModel, this)});
    }

    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "CONFUSIONS2": {
                return 50;
            }
            case "LOS_MAPUCHE": {
                return 50;
            }
            case "TE_TILDE": {
                return 50;
            }
            case "PLURAL_SEPARADO": {
                return 50;
            }
            case "INCORRECT_EXPRESSIONS": {
                return 40;
            }
            case "MISSPELLING": {
                return 40;
            }
            case "CONFUSIONS": {
                return 40;
            }
            case "NO_SEPARADO": {
                return 40;
            }
            case "PARTICIPIO_MS": {
                return 40;
            }
            case "DIACRITICS": {
                return 30;
            }
            case "POR_CIERTO": {
                return 30;
            }
            case "LO_LOS": {
                return 30;
            }
            case "ES_SIMPLE_REPLACE": {
                return 30;
            }
            case "ETCETERA": {
                return 30;
            }
            case "P_EJ": {
                return 30;
            }
            case "AGREEMENT_ADJ_NOUN_AREA": {
                return 30;
            }
            case "SE_CREO": {
                return 25;
            }
            case "PRONOMBRE_SIN_VERBO": {
                return 25;
            }
            case "AGREEMENT_DET_ABREV": {
                return 25;
            }
            case "MUCHO_NF": {
                return 25;
            }
            case "AGREEMENT_DET_NOUN_EXCEPTIONS": {
                return 25;
            }
            case "TYPOGRAPHY": {
                return 20;
            }
            case "AGREEMENT_DET_NOUN": {
                return 15;
            }
            case "AGREEMENT_DET_ADJ": {
                return 10;
            }
            case "HALLA_HAYA": {
                return 10;
            }
            case "VALLA_VAYA": {
                return 10;
            }
            case "TE_TILDE2": {
                return 10;
            }
            case "SINGLE_CHARACTER": {
                return 5;
            }
            case "SEPARADO": {
                return 1;
            }
            case "E_EL": {
                return -10;
            }
            case "EL_TILDE": {
                return -10;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -15;
            }
            case "PREP_VERB": {
                return -20;
            }
            case "SUBJUNTIVO_FUTURO": {
                return -30;
            }
            case "SUBJUNTIVO_PASADO": {
                return -30;
            }
            case "SUBJUNTIVO_PASADO2": {
                return -30;
            }
            case "AGREEMENT_ADJ_NOUN": {
                return -30;
            }
            case "AGREEMENT_PARTICIPLE_NOUN": {
                return -30;
            }
            case "AGREEMENT_POSTPONED_ADJ": {
                return -30;
            }
            case "COMMA_SINO": {
                return -40;
            }
            case "VOSEO": {
                return -40;
            }
            case "MORFOLOGIK_RULE_ES": {
                return -100;
            }
            case "PHRASE_REPETITION": {
                return -150;
            }
            case "SPANISH_WORD_REPEAT_RULE": {
                return -150;
            }
            case "UPPERCASE_SENTENCE_START": {
                return -200;
            }
        }
        return super.getPriorityForId(id);
    }
}

