/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceAnglicismRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceAnglicismRule.loadFromPath((String)"/es/replace_anglicism.txt");
    private static final Locale ES_LOCALE = new Locale("ES");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceAnglicismRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "ES_SIMPLE_REPLACE_ANGLICISM";
    }

    public String getDescription() {
        return "Anglicismos incesarios";
    }

    public String getShort() {
        return "Anglicismo innecesario";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Anglicismo innecesario.";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return ES_LOCALE;
    }
}

