/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.es;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class SpanishTagger
extends BaseTagger {
    private static final Pattern ADJ_PART_FS = Pattern.compile("VMP00SF|A[QO].[FC][SN].");
    private static final Pattern VERB = Pattern.compile("V.+");
    private static final Pattern PREFIXES_FOR_VERBS = Pattern.compile("(auto)([^r]...+)", 66);
    private static final Pattern PREFIXES_FOR_VERBS2 = Pattern.compile("(autor)(r...+)", 66);

    public SpanishTagger() {
        super("/es/es-ES.dict", new Locale("es"));
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.locale);
            boolean isLowercase = word.equals(lowerWord);
            boolean isMixedCase = StringTools.isMixedCase((String)word);
            boolean isAllUpper = StringTools.isAllUppercase((String)word);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
            this.addTokens(taggerTokens, l);
            if (!isLowercase && !isMixedCase) {
                List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
                this.addTokens(lowerTaggerTokens, l);
            }
            if (isAllUpper) {
                String firstUpper = StringTools.uppercaseFirstChar((String)lowerWord);
                List firstupperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(firstUpper));
                this.addTokens(firstupperTaggerTokens, l);
            }
            if (l.isEmpty() && !isMixedCase) {
                this.addTokens(this.additionalTags(word, (IStemmer)dictLookup), l);
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    @Nullable
    protected List<AnalyzedToken> additionalTags(String word, IStemmer stemmer) {
        String posTag;
        List taggerTokens;
        String possibleVerb;
        Matcher matcher;
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        String lowerWord = word.toLowerCase(this.locale);
        if (lowerWord.endsWith("mente")) {
            String possibleAdj = lowerWord.replaceAll("^(.+)mente$", "$1");
            List taggerTokens2 = this.asAnalyzedTokenList(possibleAdj, dictLookup.lookup((CharSequence)possibleAdj));
            for (AnalyzedToken taggerToken : taggerTokens2) {
                Matcher m;
                String posTag2 = taggerToken.getPOSTag();
                if (posTag2 == null || !(m = ADJ_PART_FS.matcher(posTag2)).matches()) continue;
                additionalTaggedTokens.add(new AnalyzedToken(word, "RG", lowerWord));
                return additionalTaggedTokens;
            }
        }
        if ((matcher = PREFIXES_FOR_VERBS.matcher(word)).matches()) {
            possibleVerb = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenList(possibleVerb, dictLookup.lookup((CharSequence)possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                Matcher m;
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = VERB.matcher(posTag)).matches()) continue;
                String lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            return additionalTaggedTokens;
        }
        matcher = PREFIXES_FOR_VERBS2.matcher(word);
        if (matcher.matches()) {
            possibleVerb = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenList(possibleVerb, dictLookup.lookup((CharSequence)possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                Matcher m;
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = VERB.matcher(posTag)).matches()) continue;
                String lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            return additionalTaggedTokens;
        }
        return null;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

