/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.tagging.es.SpanishTagger;
import org.languagetool.tools.StringTools;

public class FindSuggestionsFilter
extends RuleFilter {
    private final int MAX_SUGGESTIONS = 10;
    private static final String DICT_FILENAME = "/es/es-ES.dict";
    private static MorfologikSpeller speller;
    private static final SpanishTagger tagger;

    public FindSuggestionsFilter() throws IOException {
        if (speller == null && JLanguageTool.getDataBroker().resourceExists(DICT_FILENAME)) {
            speller = new MorfologikSpeller(DICT_FILENAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        ArrayList<String> replacements = new ArrayList<String>();
        String wordFrom = this.getRequired("WordFrom", arguments);
        String desiredPostag = this.getRequired("DesiredPostag", arguments);
        if (wordFrom != null && desiredPostag != null) {
            int posWord = Integer.parseInt(wordFrom);
            if (posWord < 1 || posWord > patternTokens.length) {
                throw new IllegalArgumentException("FindSuggestionsFilter: Index out of bounds in " + match.getRule().getFullId() + ", wordFrom: " + posWord);
            }
            AnalyzedTokenReadings atrWord = patternTokens[posWord - 1];
            String wordToCheck = atrWord.getToken();
            if (atrWord.isTagged()) {
                wordToCheck = this.makeWrong(atrWord.getToken());
            }
            ArrayList suggestions = new ArrayList();
            MorfologikSpeller morfologikSpeller = speller;
            synchronized (morfologikSpeller) {
                suggestions = speller.getSpeller().findReplacements(wordToCheck);
            }
            if (suggestions.size() > 0) {
                boolean isCapitalized = StringTools.isCapitalizedWord((String)wordToCheck);
                List<AnalyzedTokenReadings> analyzedSuggestions = tagger.tag(suggestions);
                for (AnalyzedTokenReadings analyzedSuggestion : analyzedSuggestions) {
                    if (!analyzedSuggestion.matchesPosTagRegex(desiredPostag)) continue;
                    if (!replacements.contains(analyzedSuggestion.getToken()) && !replacements.contains(analyzedSuggestion.getToken().toLowerCase())) {
                        if (isCapitalized) {
                            replacements.add(StringTools.uppercaseFirstChar((String)analyzedSuggestion.getToken()));
                        } else {
                            replacements.add(analyzedSuggestion.getToken());
                        }
                    }
                    if (replacements.size() < 10) continue;
                    break;
                }
            }
        }
        String message = match.getMessage();
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
        ruleMatch.setType(match.getType());
        ArrayList<String> definitiveReplacements = new ArrayList<String>();
        boolean replacementsUsed = false;
        block4: for (String s : match.getSuggestedReplacements()) {
            if (s.contains("{suggestion}")) {
                replacementsUsed = true;
                for (String s2 : replacements) {
                    if (definitiveReplacements.size() >= 10) continue block4;
                    definitiveReplacements.add(s.replace("{suggestion}", s2));
                }
                continue;
            }
            definitiveReplacements.add(s);
        }
        if (!replacementsUsed) {
            definitiveReplacements.addAll(replacements);
        }
        if (!definitiveReplacements.isEmpty()) {
            ruleMatch.setSuggestedReplacements(definitiveReplacements);
        }
        return ruleMatch;
    }

    private String makeWrong(String s) {
        if (s.contains("a")) {
            return s.replace("a", "\u00e4");
        }
        if (s.contains("e")) {
            return s.replace("e", "\u00eb");
        }
        if (s.contains("i")) {
            return s.replace("i", "\u00ef");
        }
        if (s.contains("o")) {
            return s.replace("o", "\u00f6");
        }
        if (s.contains("u")) {
            return s.replace("u", "\u00f9");
        }
        if (s.contains("\u00e1")) {
            return s.replace("\u00e1", "\u00e4");
        }
        if (s.contains("\u00e9")) {
            return s.replace("\u00e9", "\u00eb");
        }
        if (s.contains("\u00ed")) {
            return s.replace("\u00ed", "\u00ef");
        }
        if (s.contains("\u00f3")) {
            return s.replace("\u00f3", "\u00f6");
        }
        if (s.contains("\u00fa")) {
            return s.replace("\u00fa", "\u00f9");
        }
        return s + "-";
    }

    static {
        tagger = new SpanishTagger();
    }
}

