/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.es;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class SpanishTagger
extends BaseTagger {
    private static final Pattern ADJ_PART_FS = Pattern.compile("VMP00SF|A[QO].[FC][SN].");

    public SpanishTagger() {
        super("/es/es-ES.dict", new Locale("es"));
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.locale);
            boolean isLowercase = word.equals(lowerWord);
            boolean isMixedCase = StringTools.isMixedCase((String)word);
            boolean isAllUpper = StringTools.isAllUppercase((String)word);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
            this.addTokens(taggerTokens, l);
            if (!isLowercase && !isMixedCase) {
                List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
                this.addTokens(lowerTaggerTokens, l);
            }
            if (isAllUpper) {
                String firstUpper = StringTools.uppercaseFirstChar((String)lowerWord);
                List firstupperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(firstUpper));
                this.addTokens(firstupperTaggerTokens, l);
            }
            if (l.isEmpty() && !isMixedCase) {
                this.addTokens(this.additionalTags(word, (IStemmer)dictLookup), l);
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    @Nullable
    protected List<AnalyzedToken> additionalTags(String word, IStemmer stemmer) {
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        String lowerWord = word.toLowerCase(this.locale);
        if (lowerWord.endsWith("mente")) {
            String possibleAdj = lowerWord.replaceAll("^(.+)mente$", "$1");
            List taggerTokens = this.asAnalyzedTokenList(possibleAdj, dictLookup.lookup((CharSequence)possibleAdj));
            for (AnalyzedToken taggerToken : taggerTokens) {
                Matcher m;
                String posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = ADJ_PART_FS.matcher(posTag)).matches()) continue;
                additionalTaggedTokens.add(new AnalyzedToken(word, "RG", lowerWord));
                return additionalTaggedTokens;
            }
        }
        return null;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

