/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.es.ConfusionPairsDataLoader;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tools.StringTools;

public class ConfusionCheckFilter
extends RuleFilter {
    private static final Map<String, AnalyzedTokenReadings> relevantWords = new ConfusionPairsDataLoader().loadWords("/es/confusion_pairs.txt");
    private static final Pattern MS = Pattern.compile("NC[MC][SN]000|A..[MC][SN].|V.P..SM");
    private static final Pattern FS = Pattern.compile("NC[FC][SN]000|A..[FC][SN].|V.P..SF");
    private static final Pattern MP = Pattern.compile("NC[MC][PN]000|A..[MC][PN].|V.P..PM");
    private static final Pattern FP = Pattern.compile("NC[FC][PN]000|A..[FC][PN].|V.P..PF");

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) {
        Pattern desiredGenderNumberPattern = null;
        String replacement = null;
        String postag = this.getRequired("postag", arguments);
        String form = this.getRequired("form", arguments).toLowerCase();
        String gendernumber_from = this.getOptional("gendernumber_from", arguments);
        if (gendernumber_from != null) {
            int i = Integer.parseInt(gendernumber_from);
            if (i < 1 || i > patternTokens.length) {
                throw new IllegalArgumentException("ConfusionCheckFilter: Index out of bounds in " + match.getRule().getFullId() + ", value: " + i);
            }
            AnalyzedTokenReadings atr = patternTokens[i - 1];
            if (atr.matchesPosTagRegex(".+MS.*")) {
                desiredGenderNumberPattern = MS;
            }
            if (atr.matchesPosTagRegex(".+MP.*")) {
                desiredGenderNumberPattern = MP;
            }
            if (atr.matchesPosTagRegex(".+FS.*")) {
                desiredGenderNumberPattern = FS;
            }
            if (atr.matchesPosTagRegex(".+FP.*")) {
                desiredGenderNumberPattern = FP;
            }
        }
        if (relevantWords.containsKey(form) && relevantWords.get(form).matchesPosTagRegex(postag)) {
            Matcher m;
            if (desiredGenderNumberPattern != null && !(m = desiredGenderNumberPattern.matcher(((AnalyzedToken)relevantWords.get(form).getReadings().get(0)).getPOSTag())).matches()) {
                return null;
            }
            replacement = relevantWords.get(form).getToken();
        }
        if (replacement != null) {
            String message = match.getMessage();
            if (!StringTools.hasDiacritics(replacement) || StringTools.hasDiacritics((String)form)) {
                message = message.replace("se escribe con tilde", "se escribe de otra manera");
            }
            RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
            ruleMatch.setType(match.getType());
            String suggestion = ((String)match.getSuggestedReplacements().get(0)).replace("{suggestion}", replacement);
            suggestion = suggestion.replace("{Suggestion}", StringTools.uppercaseFirstChar((String)replacement));
            ruleMatch.setSuggestedReplacement(suggestion);
            return ruleMatch;
        }
        return null;
    }
}

