/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Spanish;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class SpanishWikipediaRule
extends AbstractSimpleReplaceRule2 {
    public static final String WIKIPEDIA_COMMON_ERRORS = "ES_WIKIPEDIA_COMMON_ERRORS";
    private static final String FILE_NAME = "/es/wikipedia.txt";
    private static final Locale ES_LOCALE = new Locale("es");

    public final String getFileName() {
        return FILE_NAME;
    }

    public SpanishWikipediaRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Spanish());
        super.setCategory(Categories.WIKIPEDIA.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.addExamplePair(Example.wrong((String)"<marker>a basto</marker>"), Example.fixed((String)"<marker>abasto</marker>"));
    }

    public final String getId() {
        return WIKIPEDIA_COMMON_ERRORS;
    }

    public String getDescription() {
        return "Errores frecuentes en los art\u00edculos de la Wikipedia";
    }

    public String getShort() {
        return "Error gramatical u ortogr\u00e1fico";
    }

    public String getSuggestion() {
        return "'$match' es una expresi\u00f3n err\u00f3nea. Pruebe a utilizar $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " o ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://es.wikipedia.org/wiki/Wikipedia:Lista_de_errores_ortogr%C3%A1ficos_comunes/M%C3%A1quinas");
    }

    public Locale getLocale() {
        return ES_LOCALE;
    }
}

