/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.es.AccentuationDataLoader;
import org.languagetool.tools.StringTools;

public class SpanishDiacriticsCheckRule
extends Rule {
    private static final Pattern PREPOSICIO_DE = Pattern.compile("de|del");
    private static final Pattern ARTICLE_EL_MS = Pattern.compile("el|El|un|Un");
    private static final Pattern ARTICLE_EL_FS = Pattern.compile("la|La|una|Una");
    private static final Pattern ARTICLE_EL_MP = Pattern.compile("los|Los|unos|Unos");
    private static final Pattern ARTICLE_EL_FP = Pattern.compile("las|Las|unas|Unas");
    private static final Pattern DETERMINANT = Pattern.compile("D[^R].*");
    private static final Pattern DETERMINANT_MS = Pattern.compile("D[^R].[MC][SN].*");
    private static final Pattern DETERMINANT_FS = Pattern.compile("D[^R].[FC][SN].*");
    private static final Pattern DETERMINANT_MP = Pattern.compile("D[^R].[MC][PN].*");
    private static final Pattern DETERMINANT_FP = Pattern.compile("D[^R].[FC][PN].*");
    private static final Pattern NOM_MS = Pattern.compile("NC[MC][SN].*");
    private static final Pattern NOM_FS = Pattern.compile("NC[FC][SN].*");
    private static final Pattern NOM_MP = Pattern.compile("NC[MC][PN].*");
    private static final Pattern NOM_FP = Pattern.compile("NC[FC][PN].*");
    private static final Pattern ADJECTIU_MS = Pattern.compile("A..[MC][SN].*|V.P..SM.?|PX.MS.*");
    private static final Pattern ADJECTIU_FS = Pattern.compile("A..[FC][SN].*|V.P..SF.?|PX.FS.*");
    private static final Pattern ADJECTIU_MP = Pattern.compile("A..[MC][PN].*|V.P..PM.?|PX.MP.*");
    private static final Pattern ADJECTIU_FP = Pattern.compile("A..[FC][PN].*|V.P..PF.?|PX.FP.*");
    private static final Pattern INFINITIU = Pattern.compile("V.N.*");
    private static final Pattern VERB_CONJUGAT = Pattern.compile("V.[^NGP].*|_GV_");
    private static final Pattern PARTICIPI_MS = Pattern.compile("V.P.*SM.?");
    private static final Pattern GRUP_VERBAL = Pattern.compile("_GV_");
    private static final Pattern VERB_3S = Pattern.compile("V...3S..?");
    private static final Pattern VERB_13S = Pattern.compile("V...[13]S..?");
    private static final Pattern NOT_IN_PREV_TOKEN = Pattern.compile("VA.*|PP.*|P0.*|VSP.*");
    private static final Pattern BEFORE_ADJECTIVE_MS = Pattern.compile("SPS00|D[^R].[MC][SN].*|V.[^NGP].*|PX.*");
    private static final Pattern BEFORE_ADJECTIVE_FS = Pattern.compile("SPS00|D[^R].[FC][SN].*|V.[^NGP].*|PX.*");
    private static final Pattern BEFORE_ADJECTIVE_MP = Pattern.compile("SPS00|D[^R].[MC][PN].*|V.[^NGP].*|PX.*");
    private static final Pattern BEFORE_ADJECTIVE_FP = Pattern.compile("SPS00|D[^R].[FC][PN].*|V.[^NGP].*|PX.*");
    private static final Pattern GN = Pattern.compile(".*_GN_.*|<?/?N[CP]..000.*");
    private static final Pattern EXCEPCIONS_DARRERE_DE = Pattern.compile("forma|manera|hecho|derecho|modo|conformidad", 66);
    private static final Pattern LOCUCIONS = Pattern.compile(".*LOC.*");
    private static final Pattern PRONOM_FEBLE = Pattern.compile("P0.{6}|PP3CN000|PP3NN000|PP3CP000|PP3CSD00");
    private static final Map<String, AnalyzedTokenReadings> relevantWords = new AccentuationDataLoader().loadWords("/es/verb_noaccent_noun_accent.txt");
    private static final Map<String, AnalyzedTokenReadings> relevantWords2 = new AccentuationDataLoader().loadWords("/es/verb_noaccent_adj_accent.txt");

    public SpanishDiacriticsCheckRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    public String getId() {
        return "ACCENTUATION_CHECK_ES";
    }

    public String getDescription() {
        return "Comprueba si la palabra debe llevar acento gr\u00e1fico.";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String token = i == 1 ? tokens[i].getToken().toLowerCase() : tokens[i].getToken();
            String prevToken = tokens[i - 1].getToken();
            String prevPrevToken = "";
            if (i > 2) {
                prevPrevToken = tokens[i - 2].getToken();
            }
            String nextToken = "";
            if (i < tokens.length - 1) {
                nextToken = tokens[i + 1].getToken();
            }
            String nextNextToken = "";
            if (i < tokens.length - 2) {
                nextNextToken = tokens[i + 2].getToken();
            }
            String nextNextNextToken = "";
            if (i < tokens.length - 3) {
                nextNextNextToken = tokens[i + 3].getToken();
            }
            boolean isRelevantWord = false;
            boolean isRelevantWord2 = false;
            if (StringTools.isEmpty((String)token)) continue;
            if (relevantWords.containsKey(token)) {
                isRelevantWord = true;
            }
            if (relevantWords2.containsKey(token)) {
                isRelevantWord2 = true;
            }
            if (!isRelevantWord && !isRelevantWord2 || this.matchPostagRegexp(tokens[i - 1], PRONOM_FEBLE) && !prevToken.startsWith("'") && !prevToken.startsWith("-")) continue;
            String replacement = null;
            Matcher mPreposicioDE = PREPOSICIO_DE.matcher(nextToken);
            boolean exceptionsDEMANERA = false;
            if (mPreposicioDE.matches()) {
                if (EXCEPCIONS_DARRERE_DE.matcher(nextNextToken).matches()) {
                    exceptionsDEMANERA = true;
                } else if (i < tokens.length - 3 && EXCEPCIONS_DARRERE_DE.matcher(nextNextNextToken).matches() && this.matchPostagRegexp(tokens[i + 2], DETERMINANT)) {
                    exceptionsDEMANERA = true;
                }
            }
            Matcher mArticleELMS = ARTICLE_EL_MS.matcher(prevToken);
            Matcher mArticleELFS = ARTICLE_EL_FS.matcher(prevToken);
            Matcher mArticleELMP = ARTICLE_EL_MP.matcher(prevToken);
            Matcher mArticleELFP = ARTICLE_EL_FP.matcher(prevToken);
            if (isRelevantWord && !this.matchPostagRegexp(tokens[i], GN) && !this.matchPostagRegexp(tokens[i], LOCUCIONS)) {
                if (!(!tokens[i - 1].hasPosTag("SPS00") && !tokens[i - 1].hasPosTag("SP+DA") || tokens[i - 1].hasPosTag("RG") || this.matchPostagRegexp(tokens[i - 1], DETERMINANT) || this.matchPostagRegexp(tokens[i], INFINITIU))) {
                    replacement = relevantWords.get(token).getToken();
                } else if (i > 2 && (tokens[i - 2].hasPosTag("SPS00") || tokens[i - 2].hasPosTag("SP+DA")) && !tokens[i - 2].hasPosTag("RG") && !this.matchPostagRegexp(tokens[i - 2], DETERMINANT) && (this.matchPostagRegexp(tokens[i - 1], DETERMINANT) || mArticleELMS.matches() || mArticleELFS.matches() || mArticleELMP.matches() || mArticleELFP.matches()) && !this.matchPostagRegexp(tokens[i], INFINITIU)) {
                    replacement = relevantWords.get(token).getToken();
                }
            }
            if (isRelevantWord2 && !this.matchPostagRegexp(tokens[i], GN) && !this.matchPostagRegexp(tokens[i], LOCUCIONS)) {
                if (!(!tokens[i - 1].hasPosTag("SPS00") && !tokens[i - 1].hasPosTag("SP+DA") || tokens[i - 1].hasPosTag("RG") || this.matchPostagRegexp(tokens[i - 1], DETERMINANT) || this.matchPostagRegexp(tokens[i], INFINITIU))) {
                    replacement = relevantWords2.get(token).getToken();
                } else if (i > 2 && (tokens[i - 2].hasPosTag("SPS00") || tokens[i - 2].hasPosTag("SP+DA")) && !tokens[i - 2].hasPosTag("RG") && !this.matchPostagRegexp(tokens[i - 2], DETERMINANT) && (this.matchPostagRegexp(tokens[i - 1], DETERMINANT) || mArticleELMS.matches() || mArticleELFS.matches() || mArticleELMP.matches() || mArticleELFP.matches()) && !this.matchPostagRegexp(tokens[i], INFINITIU)) {
                    replacement = relevantWords2.get(token).getToken();
                }
            }
            if (replacement == null) continue;
            String msg = "Si es un nombre o un adjetivo, debe llevar tilde.";
            RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, tokens[i].getStartPos(), tokens[i].getEndPos(), "Si es un nombre o un adjetivo, debe llevar tilde.", "Falta una tilde");
            ruleMatch.setSuggestedReplacement(replacement);
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        boolean matches = false;
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || !(m = pattern.matcher(posTag)).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

