/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.eo;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.rules.AbstractDateCheckFilter;

public class DateCheckFilter
extends AbstractDateCheckFilter {
    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.UK);
    }

    protected int getDayOfMonth(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.endsWith("n")) {
            day = day.substring(0, day.length() - 1);
        }
        int n = 0;
        if (day.startsWith("dek")) {
            n = 10;
            day = day.substring(3);
        } else if (day.startsWith("dudek")) {
            n = 20;
            day = day.substring(5);
        } else if (day.startsWith("tridek")) {
            n = 30;
            day = day.substring(6);
        }
        if (n > 0 && day.startsWith("-")) {
            day = day.substring(1);
        }
        if (day.equals("unua")) {
            ++n;
        }
        if (day.equals("dua")) {
            n += 2;
        }
        if (day.equals("tria")) {
            n += 3;
        }
        if (day.equals("kvara")) {
            n += 4;
        }
        if (day.equals("kvina")) {
            n += 5;
        }
        if (day.equals("sesa")) {
            n += 6;
        }
        if (day.equals("sepa")) {
            n += 7;
        }
        if (day.equals("oka")) {
            n += 8;
        }
        if (day.equals("na\u016da")) {
            n += 9;
        }
        if (day.equals("nauxa")) {
            n += 9;
        }
        if (day.equals("naua")) {
            n += 9;
        }
        return n;
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.startsWith("dim")) {
            return 1;
        }
        if (day.startsWith("lun")) {
            return 2;
        }
        if (day.startsWith("mar")) {
            return 3;
        }
        if (day.startsWith("mer")) {
            return 4;
        }
        if (day.startsWith("\u0135a\u016d")) {
            return 5;
        }
        if (day.startsWith("jau")) {
            return 5;
        }
        if (day.startsWith("jhau")) {
            return 5;
        }
        if (day.startsWith("jxau")) {
            return 5;
        }
        if (day.startsWith("ven")) {
            return 6;
        }
        if (day.startsWith("sab")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        String englishDay = date.getDisplayName(7, 2, Locale.UK);
        if (englishDay.equals("Sunday")) {
            return "diman\u0109o";
        }
        if (englishDay.equals("Monday")) {
            return "lundo";
        }
        if (englishDay.equals("Tuesday")) {
            return "mardo";
        }
        if (englishDay.equals("Wednesday")) {
            return "merkredo";
        }
        if (englishDay.equals("Thursday")) {
            return "ja\u016ddo";
        }
        if (englishDay.equals("Friday")) {
            return "vendredo";
        }
        if (englishDay.equals("Saturday")) {
            return "sabato";
        }
        return "";
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.startsWith("jan")) {
            return 1;
        }
        if (mon.startsWith("feb")) {
            return 2;
        }
        if (mon.startsWith("mar")) {
            return 3;
        }
        if (mon.startsWith("apr")) {
            return 4;
        }
        if (mon.startsWith("maj")) {
            return 5;
        }
        if (mon.startsWith("jun")) {
            return 6;
        }
        if (mon.startsWith("jul")) {
            return 7;
        }
        if (mon.startsWith("a\u016dg")) {
            return 8;
        }
        if (mon.startsWith("sep")) {
            return 9;
        }
        if (mon.startsWith("okt")) {
            return 10;
        }
        if (mon.startsWith("nov")) {
            return 11;
        }
        if (mon.startsWith("dec")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

