/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.Tools;

public class CompoundRule
extends AbstractCompoundRule {
    private static volatile CompoundRuleData compoundData;
    private static final Language AMERICAN_ENGLISH;
    private static final List<DisambiguationPatternRule> ANTI_PATTERNS;
    private final Language english;

    public CompoundRule(ResourceBundle messages, Language english, UserConfig userConfig) throws IOException {
        super(messages, english, userConfig, "This word is normally spelled with a hyphen.", "This word is normally spelled as one.", "This expression is normally spelled as one or with a hyphen.", "Compound");
        this.english = english;
        super.useSubRuleSpecificIds();
        this.addExamplePair(Example.wrong((String)"I now have a <marker>part time</marker> job."), Example.fixed((String)"I now have a <marker>part-time</marker> job."));
        this.setUrl(Tools.getUrl((String)"https://languagetool.org/insights/post/hyphen/"));
    }

    public String getId() {
        return "EN_COMPOUNDS";
    }

    public String getDescription() {
        return "Hyphenated words: $match";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompoundRuleData getCompoundRuleData() {
        CompoundRuleData data = compoundData;
        if (data != null) return data;
        Class<CompoundRule> clazz = CompoundRule.class;
        synchronized (CompoundRule.class) {
            data = compoundData;
            if (data != null) return data;
            compoundData = data = new CompoundRuleData("/en/compounds.txt");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data;
        }
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return ANTI_PATTERNS;
    }

    public boolean isMisspelled(String word) throws IOException {
        return Objects.requireNonNull(this.english.getDefaultSpellingRule()).isMisspelled(word);
    }

    static {
        AMERICAN_ENGLISH = Languages.getLanguageForShortCode((String)"en-US");
        ANTI_PATTERNS = CompoundRule.makeAntiPatterns(Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"['\u2019`\u00b4\u2018]"), PatternRuleBuilderHelper.token((String)"re")), Arrays.asList(new PatternTokenBuilder().posRegex("SENT_START|CC|PCT").build(), PatternRuleBuilderHelper.tokenRegex((String)"we|you|they|I|s?he|it"), PatternRuleBuilderHelper.token((String)"well"), new PatternTokenBuilder().posRegex("VB.*").build()), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"and|&"), PatternRuleBuilderHelper.token((String)"co")), Arrays.asList(PatternRuleBuilderHelper.token((String)"power"), PatternRuleBuilderHelper.token((String)"off"), PatternRuleBuilderHelper.token((String)"key")), Arrays.asList(PatternRuleBuilderHelper.token((String)"see"), PatternRuleBuilderHelper.token((String)"saw"), PatternRuleBuilderHelper.token((String)"seen")), Arrays.asList(PatternRuleBuilderHelper.token((String)"forward"), PatternRuleBuilderHelper.token((String)"looking"), new PatternTokenBuilder().posRegex("IN|TO").build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"store"), PatternRuleBuilderHelper.token((String)"front"), PatternRuleBuilderHelper.tokenRegex((String)"doors?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"from"), PatternRuleBuilderHelper.token((String)"surface"), PatternRuleBuilderHelper.token((String)"to"), PatternRuleBuilderHelper.token((String)"surface")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"senior|junior"), PatternRuleBuilderHelper.token((String)"year"), PatternRuleBuilderHelper.token((String)"end")), Arrays.asList(PatternRuleBuilderHelper.token((String)"under"), PatternRuleBuilderHelper.token((String)"investment"), PatternRuleBuilderHelper.token((String)"banking")), Arrays.asList(PatternRuleBuilderHelper.token((String)"spring"), PatternRuleBuilderHelper.tokenRegex((String)"cleans?|cleaned|cleaning"), PatternRuleBuilderHelper.tokenRegex((String)"up|the|my|our|his|her")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"series?"), PatternRuleBuilderHelper.tokenRegex((String)"a")), Arrays.asList(PatternRuleBuilderHelper.token((String)"hard"), PatternRuleBuilderHelper.token((String)"time"), new PatternTokenBuilder().pos("VBG").build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"first"), PatternRuleBuilderHelper.tokenRegex((String)"ever"), PatternRuleBuilderHelper.tokenRegex((String)"green")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)".+"), PatternRuleBuilderHelper.token((String)"."), PatternRuleBuilderHelper.tokenRegex((String)"(com|io|de|nl|co|net|org|es)"))), (Language)AMERICAN_ENGLISH);
    }
}

