/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStyleTooOftenUsedWordRule;
import org.languagetool.rules.Rule;

public class StyleTooOftenUsedAdjectiveRule
extends AbstractStyleTooOftenUsedWordRule {
    private static final int DEFAULT_MIN_PERCENT = 5;
    String sentenceMessage = null;

    public StyleTooOftenUsedAdjectiveRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 5);
        LinguServices linguServices;
        if (userConfig != null && (linguServices = userConfig.getLinguServices()) != null) {
            linguServices.setThesaurusRelevantRule((Rule)this);
        }
    }

    protected String getLimitMessage(int limit) {
        return "The adjective is used more than " + limit + "% times of all adjectives. It may be better to replace it with a synonym.";
    }

    public String getId() {
        return "TOO_OFTEN_USED_ADJECTIVE_EN";
    }

    public String getDescription() {
        return "Statistical Style Analysis: Overused Adjective";
    }

    public String getConfigureText() {
        return "Show when a adjective is used more often than ...% of all adjectives:";
    }

    protected boolean isToCountedWord(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("JJ");
    }

    protected boolean isException(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("RB") || token.hasPosTagStartingWith("IN") || token.hasPosTagStartingWith("CD") || token.hasPosTagStartingWith("DT") || token.hasPosTagStartingWith("NN");
    }

    private String getLemmaForPosTagStartsWith(String startPos, AnalyzedTokenReadings token) {
        List readings = token.getReadings();
        for (AnalyzedToken reading : readings) {
            String posTag = reading.getPOSTag();
            if (posTag == null || !posTag.startsWith(startPos)) continue;
            return reading.getLemma();
        }
        return null;
    }

    protected String toAddedLemma(AnalyzedTokenReadings token) {
        return this.getLemmaForPosTagStartsWith("JJ", token);
    }
}

