/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.ngrams.ConfusionProbabilityRule;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;

public class EnglishConfusionProbabilityRule
extends ConfusionProbabilityRule {
    private static final List<String> EXCEPTIONS = Arrays.asList("on a bye", "your (", "your slack profile", "host to five", "had I known", "is not exactly known", "live duet", "isn't known", "your move makes", "your move is", "he unchecked the", "thank you for the patience", "your patience regarding", "your fix", "your commit", "on point", "chapter one", "usb port", "know the competition and", "know the competition or", "know your competition and", "know your competition or", "G Suite", "paste event", "need to know", "of you not", "of her element", "very grateful of you", "your use case", "he's", "he\u2019s", "they're", "they\u2019re", "your look is", "have you known", "have I known", "had I known", "hang out", "had you known", "his fluffy butt", "it's now better", "it\u2019s now better", "it is now better", "let us know below", "let us know in", "your kind of", "sneak peek", "the 4 of you", "your ride", "he most likely", "good cause", "big butt", "news story", "news stories", "news debate", "news debates", "news leader", "news leaders", "news person", "news spokesperson", "news spokespersons", "news teller", "news tellers", "news outlet", "news outlets", "news portal", "news portals", "news company", "news companies", "news consumption", "news consumptions", "news topics", "news media", "news event", "news events", "news station", "news stations", "verify you own", "ensure you own", "happy us!", "your pick up", "no but you", "no but we", "no but he", "no but I", "no but they", "no but she", "no but it", "he tracks", "which complains about", "do your work", "one many times", "let us know", "let me know", "this way the", "save you money", "so your plan", "the news man", "on there,", "in there,", "created us equally", ", their,", ", your,", ", its,", "us, humans,", "bring you happiness", "in a while", "confirm you own", "oh, god", "honey nut", "not now", "he proofs", "he needs", "1 thing", "I now don't", "once your return is", "can we text", "believe in god", "on premise", "from poor to rich", "my GPU", "was your everything", "they mustnt", "reply my email", "things god said", "let you text", "doubt in god", "in the news", "(news)", "fresh prince of", "good day bye", "it's us", "could be us being", "on twitter", "enjoy us being", "If your use of", "then,", "then?", "no it doesn", "no it does not", "no it isn", "no it is not", "no it wasn", "no it was not", "no it hasn", "no it has not", "no it can't", "no it cannot", "no it can not", "no it won't", "no it will not", "no it wouldn", "no it would not", "no it couldn", "no it could not", "no it shouldn", "no it should not", "no that's not", "provided my country", "no i don't", "no i do not", "no i can't", "no i cannot", "no i can not", "no i won't", "no i will not", "no i wasn", "no i was not", "no i haven", "no i have not", "no i wouldn", "no i would not", "no i couldn", "no i could not", "no i shouldn", "no i should not", "no you don't", "no you do not", "no you can't", "no you cannot", "no you can not", "no you won't", "no you will not", "no you weren", "no you were not", "no you haven", "no you have not", "no you wouldn", "no you would not", "no you couldn", "no you could not", "no you shouldn", "no you should not", "no they don", "no they do not", "no they weren", "no they were not", "no there was no", "no there was not", "no there wasn", "no there is no", "no there is not", "no there's no", "no there's not", "no there isn", "no there are no", "no there are not", "no there're no", "no there're not", "no there aren", "no there were no", "no there were not", "no there weren", "no this is not", "no that is not", "no we were not", "no we are not", "no we're not", "no they're not", "no they had not", "no they hadn", "no all good", "no everything alright", "no everything good", "no everything fine", "no we don't", "no dont", "which hat to buy", "her hat", "his hat", "my hat", "party hat", "95 theses", "ninety-five theses", "Ninety-five theses", "April Theses", "for your recharge", "all you kids", "thanks for the patience", "what to text", "is he famous for", "was he famous for", "really quiet at", "he programs", "scene 1", "scene 2", "scene 3", "scene 4", "scene 5", "scene 6", "scene 7", "scene 8", "scene 9", "scene 10", "scene 11", "scene 12", "scene 13", "scene 14", "scene 15", "make a hire", "on the news", "brown plane", "news politics", "organic reach", "out bid", "message us in", "I picture us", "your and our", "house and pool", "your set up is", "your set up was", "because your pay is", "but your pay is", "the while block", "updated my edge", "he haven", "is he naked", "these news sound", "those news sound", "(t)he", "[t]he", "the role at", "same false alarm", "then that would", "was he part of", "is he right now", "news page", "news pages", "news headline", "news headlines", "news title", "news titles", "news article", "news articles", "news site", "news sites", "news website", "news websites", "news channel", "news channels", "news source", "news sources", "news organization", "news organizations", "news organisation", "news organisations", "news platform", "news platforms", "news data", "the news cover", "the news covers", "news documentary", "all the news check", "all the news checked", "all the news report", "all the news reported", "all the news mention", "all the news mentioned", "all the news are", "news documentaries", "scene in a movie", "mr.bean", "mr. bean", "your push notification", "check our page about", "have a think", "had a think", "live support", "your troll", "waist type", "(wait)", "now ahead of schedule", "tag us in", "your rebuild", "got to know new", "to live post", "sea pineapple", "the commit", "appreciate you contacting me", "appreciate you contacting us", "appreciate you informing me", "appreciate you informing us", "appreciate you confirming it", "appreciate you confirming this", "appreciate you confirming that", "appreciate you choosing us", "appreciate you choosing me", "wand wood", "my order", "of you being her", "ad free", "ad rates", "your call is", "you want do", "on his butt", "message us today", "sent you the invite", "appreciate you fowarding", "appreciate you cooking", "appreciate you sending", "appreciate you talking", "appreciate you taking", "that now means", "fiscal school", "covid-19 cases", "corona cases", "your need can", "know the customer", "know what type", "your pulled pork", "dear management", "way in advance", "that way", "way back when", "way back then", "way much more", "the other way", "way to much", "your to do", "when your zoom", "once your zoom", "if your zoom", "keep you day and night", "your hunt for", "if your bolt fits", "the go to", "text my number", "why was he", "what was he", "was he sick", "why is he", "what is he", "is he happy", "he kind of", "logged out", "signed out", "same seems to", "am I cold", "is he cold", "was he cold", "is she cold", "was she cold", "is it cold", "was it cold", "are you cold", "were you cold", "are they cold", "were they cold", "are we cold", "were we cold", "us three", "way to go", "way won't", "way over", "way in the past", "way in the future", "aisle way", "airport way", "and now him", "and now us,", "to control us", "are way not", "the invite", "is there way to", "a way doing", "way different", "way too often", "I for one think", "device insurance", "the worst way", "the best way", "the first way", "'s way", "all four", "in year four", "in week four", "in month four", "s day four", "is day four", "bean soup", "bean soups", "bean bag", "bean bags", "belief in god", "believe in a god", "believes in a god", "believing in a god", "believed in a god", "Jesus and god", "Jesus or god", "love of god", "god will be", "god is doing", "there may be a god", "bond with god", "the powers that be", "passed out", "passed vs failed", "passed vs. failed", "people from there", "as you well know", "as they well know", "as we well know", "close to god", "close with god", "see god when", "in a god", "he was a god", "she was a god", "she gave god", "he gave god", "believed in god", "faith with god", "days where", "where, when and why", "where, when, and why", "where, when and how", "where, when, and how", "where, when and who", "where, when, and who");
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"the|these|those"), PatternRuleBuilderHelper.token((String)"wee"), PatternRuleBuilderHelper.posRegex((String)"NNS")), Arrays.asList(PatternRuleBuilderHelper.token((String)"from"), PatternRuleBuilderHelper.token((String)"there"), PatternRuleBuilderHelper.tokenRegex((String)"turn|walk|go|drive")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VB.*"), PatternRuleBuilderHelper.token((String)"there"), PatternRuleBuilderHelper.token((String)"first")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"IN|CC"), PatternRuleBuilderHelper.token((String)"there"), PatternRuleBuilderHelper.posRegex((String)"VB"), PatternRuleBuilderHelper.posRegex((String)"PRP_O.*|DT")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"tells?|told|telling|answers?|answering|answered|reply|replies|replied|replying"), PatternRuleBuilderHelper.tokenRegex((String)"them|him|her"), PatternRuleBuilderHelper.token((String)"no")), Arrays.asList(PatternRuleBuilderHelper.token((String)"this"), PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.posRegex((String)"DT|PRP\\$"), PatternRuleBuilderHelper.posRegex((String)"NN.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"since"), PatternRuleBuilderHelper.tokenRegex((String)"\\d{1,2}|\\d{4}")), Arrays.asList(PatternRuleBuilderHelper.token((String)"in"), PatternRuleBuilderHelper.token((String)"a"), PatternRuleBuilderHelper.tokenRegex((String)"more|less"), PatternRuleBuilderHelper.posRegex((String)"JJ"), PatternRuleBuilderHelper.token((String)"way")), Arrays.asList(PatternRuleBuilderHelper.token((String)"what"), PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.posRegex((String)"DT|PRP\\$"), PatternRuleBuilderHelper.posRegex((String)"NN.*"), PatternRuleBuilderHelper.tokenRegex((String)"is|was|were|has|have|had")), Arrays.asList(PatternRuleBuilderHelper.token((String)"this"), PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.posRegex((String)"NNP|PRP"), PatternRuleBuilderHelper.posRegex((String)"VB.*|MD")), Arrays.asList(PatternRuleBuilderHelper.token((String)"this"), PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.token((String)"only"), PatternRuleBuilderHelper.posRegex((String)"DT|PRP.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"this"), PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.tokenRegex((String)"none|neither"), PatternRuleBuilderHelper.token((String)"of")), Arrays.asList(PatternRuleBuilderHelper.token((String)"this"), PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.posRegex((String)"NNP"), PatternRuleBuilderHelper.posRegex((String)"NNP"), PatternRuleBuilderHelper.posRegex((String)"VB.*|MD")), Arrays.asList(PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.token((String)"too")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"NNP|UNKNOWN"), PatternRuleBuilderHelper.tokenRegex((String)"to"), PatternRuleBuilderHelper.posRegex((String)"NNP|UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"NNP|UNKNOWN"), PatternRuleBuilderHelper.tokenRegex((String)"taught|threw"), PatternRuleBuilderHelper.posRegex((String)"NNP|UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.token((String)"taught"), PatternRuleBuilderHelper.token((String)"to"), PatternRuleBuilderHelper.tokenRegex((String)"say|do|make|be|become|treat")), Arrays.asList(PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.posRegex((String)"JJR|RBR")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VB.*"), PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.token((String)"different")), Arrays.asList(PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.token((String)"much"), PatternRuleBuilderHelper.posRegex((String)"JJR")), Arrays.asList(PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.token((String)"out"), PatternRuleBuilderHelper.tokenRegex((String)"of|in|on")), Arrays.asList(PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.token((String)"to"), PatternRuleBuilderHelper.posRegex((String)"JJ")), Arrays.asList(PatternRuleBuilderHelper.token((String)"way"), PatternRuleBuilderHelper.tokenRegex((String)"before|after|outside|inside|back")), Arrays.asList(PatternRuleBuilderHelper.token((String)"in"), PatternRuleBuilderHelper.tokenRegex((String)"an?"), PatternRuleBuilderHelper.posRegex((String)"JJ"), PatternRuleBuilderHelper.token((String)"way")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VB.*"), PatternRuleBuilderHelper.tokenRegex((String)"[\"\u201d\u201c]"), PatternRuleBuilderHelper.token((String)"us")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"message(s|d)?|text(s|ed)?|DM"), PatternRuleBuilderHelper.token((String)"us"), PatternRuleBuilderHelper.posRegex((String)"PCT|IN|TO|CC|DT")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VB.*"), PatternRuleBuilderHelper.token((String)"us"), PatternRuleBuilderHelper.tokenRegex((String)"based|depending"), PatternRuleBuilderHelper.token((String)"on")), Arrays.asList(PatternRuleBuilderHelper.token((String)"how"), PatternRuleBuilderHelper.posRegex((String)"NNP"), PatternRuleBuilderHelper.tokenRegex((String)"and|&"), PatternRuleBuilderHelper.posRegex((String)"NNP"), PatternRuleBuilderHelper.token((String)"do")), Arrays.asList(PatternRuleBuilderHelper.token((String)"break"), new PatternTokenBuilder().tokenRegex("times?").setSkip(10).build(), PatternRuleBuilderHelper.token((String)"breaks")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"how|what"), new PatternTokenBuilder().tokenRegex("much|many").min(0).setSkip(3).build(), PatternRuleBuilderHelper.token((String)"does")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"MD"), PatternRuleBuilderHelper.posRegex((String)"VB"), PatternRuleBuilderHelper.posRegex((String)"IN|RP"), PatternRuleBuilderHelper.token((String)"and"), PatternRuleBuilderHelper.token((String)"dose")), Arrays.asList(PatternRuleBuilderHelper.token((String)"your"), PatternRuleBuilderHelper.posRegex((String)"DT")));

    public EnglishConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public EnglishConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        super(messages, languageModel, language, grams, EXCEPTIONS, ANTI_PATTERNS);
        this.addExamplePair(Example.wrong((String)"Don't forget to put on the <marker>breaks</marker>."), Example.fixed((String)"Don't forget to put on the <marker>brakes</marker>."));
    }

    protected boolean isException(String sentence, int startPos, int endPos) {
        String covered;
        return startPos > 3 && (covered = sentence.substring(startPos - 3, endPos)).matches("['\u2019`\u00b4\u2018]t .*");
    }
}

