/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.en;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.English;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.MultiWordChunker;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;

public class EnglishHybridDisambiguator
extends AbstractDisambiguator {
    private final Disambiguator chunker = new MultiWordChunker("/en/multiwords.txt", true, true);
    private final Disambiguator disambiguator = new XmlRuleDisambiguator((Language)new English(), true);

    public AnalyzedSentence disambiguate(AnalyzedSentence input) throws IOException {
        return this.disambiguate(input, null);
    }

    public AnalyzedSentence disambiguate(AnalyzedSentence input, @Nullable JLanguageTool.CheckCancelledCallback checkCanceled) throws IOException {
        AnalyzedSentence analyzedSentence = this.chunker.disambiguate(input, checkCanceled);
        AnalyzedTokenReadings[] aTokens = analyzedSentence.getTokens();
        String POSTag = "";
        String lemma = "";
        String nextPOSTag = "";
        AnalyzedToken analyzedToken = null;
        for (int i = 0; i < aTokens.length; ++i) {
            AnalyzedToken newAnalyzedToken;
            if (aTokens[i].isWhitespace()) continue;
            if (checkCanceled != null && checkCanceled.checkCancelled()) break;
            if (!nextPOSTag.isEmpty()) {
                newAnalyzedToken = new AnalyzedToken(aTokens[i].getToken(), nextPOSTag, lemma);
                if (aTokens[i].hasPosTagAndLemma("</" + POSTag + ">", lemma)) {
                    nextPOSTag = "";
                    lemma = "";
                }
                aTokens[i] = new AnalyzedTokenReadings(aTokens[i], Arrays.asList(newAnalyzedToken), "EN_HybridDisambiguator");
                aTokens[i].ignoreSpelling();
                continue;
            }
            analyzedToken = this.getMultiWordAnalyzedToken(aTokens, i);
            if (analyzedToken == null) continue;
            POSTag = analyzedToken.getPOSTag().substring(1, analyzedToken.getPOSTag().length() - 1);
            lemma = analyzedToken.getLemma();
            newAnalyzedToken = new AnalyzedToken(analyzedToken.getToken(), POSTag, lemma);
            aTokens[i] = new AnalyzedTokenReadings(aTokens[i], Arrays.asList(newAnalyzedToken), "EN_HybridDisambiguator");
            aTokens[i].ignoreSpelling();
            nextPOSTag = POSTag;
        }
        return this.disambiguator.disambiguate(new AnalyzedSentence(aTokens), checkCanceled);
    }

    private AnalyzedToken getMultiWordAnalyzedToken(AnalyzedTokenReadings[] aTokens, Integer i) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        for (AnalyzedToken reading : aTokens[i]) {
            String POSTag = reading.getPOSTag();
            if (POSTag == null || !POSTag.startsWith("<") || !POSTag.endsWith(">") || POSTag.startsWith("</")) continue;
            l.add(reading);
        }
        if (l.size() > 0) {
            AnalyzedToken selectedAT = null;
            int maxDistance = 0;
            block1: for (AnalyzedToken at : l) {
                String tag = "</" + at.getPOSTag().substring(1);
                String lemma = at.getLemma();
                int distance = 1;
                while (i + distance < aTokens.length) {
                    if (aTokens[i + distance].hasPosTagAndLemma(tag, lemma)) {
                        if (distance <= maxDistance) continue block1;
                        distance = maxDistance;
                        selectedAT = at;
                        continue block1;
                    }
                    ++distance;
                }
            }
            return selectedAT;
        }
        return null;
    }
}

