/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.en.MorfologikAmericanSpellerRule;
import org.languagetool.rules.ngrams.Probability;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class UpperCaseNgramRule
extends Rule {
    public static final int THRESHOLD = 50;
    private static MorfologikAmericanSpellerRule spellerRule;
    private static LinguServices linguServices;
    private static final Set<String> exceptions;
    private static final AhoCorasickDoubleArrayTrie<String> exceptionTrie;
    private static final List<List<PatternToken>> ANTI_PATTERNS;
    private final Language lang;
    private final LanguageModel lm;
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;

    public UpperCaseNgramRule(ResourceBundle messages, LanguageModel lm, Language lang, UserConfig userConfig) {
        super(messages);
        super.setCategory(Categories.CASING.getCategory(messages));
        this.lm = lm;
        this.lang = lang;
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"This <marker>Prototype</marker> was developed by Miller et al."), Example.fixed((String)"This <marker>prototype</marker> was developed by Miller et al."));
        this.antiPatterns = UpperCaseNgramRule.cacheAntiPatterns((Language)lang, ANTI_PATTERNS);
        if (userConfig != null && linguServices == null) {
            linguServices = userConfig.getLinguServices();
            this.initTrie();
        }
        if (spellerRule == null) {
            this.initTrie();
            try {
                spellerRule = new MorfologikAmericanSpellerRule(messages, lang);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTrie() {
        CachingWordListLoader cachingWordListLoader = new CachingWordListLoader();
        ArrayList words = new ArrayList();
        words.addAll(cachingWordListLoader.loadWords("en/specific_case.txt"));
        words.addAll(cachingWordListLoader.loadWords("spelling_global.txt"));
        HashMap<String, String> map = new HashMap<String, String>();
        for (String word : words) {
            map.put(word, word);
        }
        Iterator iterator = exceptionTrie;
        synchronized (iterator) {
            exceptionTrie.build(map);
        }
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public final String getId() {
        return "EN_UPPER_CASE_NGRAM";
    }

    public String getDescription() {
        return "Checks wrong uppercase spelling of words that are not proper nouns";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        boolean atSentStart = true;
        boolean isSentence = this.isSentence(tokens);
        if (!isSentence) {
            return this.toRuleMatchArray(matches);
        }
        for (int i = 0; i < tokens.length; ++i) {
            AnalyzedTokenReadings token = tokens[i];
            String tokenStr = token.getToken();
            if (!(tokenStr.length() <= 0 || token.isImmunized() || !Character.isUpperCase(tokenStr.charAt(0)) || StringTools.isAllUppercase((String)tokenStr) || atSentStart || !token.hasPosTagStartingWith("VB") || token.hasPosTagStartingWith("NNP") || !token.isTagged() || this.prevIsUpperCase(tokens, i) && (!this.prevIsUpperCase(tokens, i) || i != 2) || this.nextIsUpperCase(tokens, i) || this.prevIsOneOf(tokens, i, Arrays.asList(":", "n\u00e9e", "of", "\"", "'")) || this.nextIsOneOfThenUppercase(tokens, i, Arrays.asList("of")) || tokenStr.matches("I") || exceptions.contains(tokenStr) || this.trieMatches(sentence.getText(), token) || this.maybeTitle(tokens, i) || this.isMisspelled(StringTools.lowercaseFirstChar((String)tokenStr)) || i + 1 >= tokens.length)) {
                List<String> ucList = Arrays.asList(tokens[i - 1].getToken(), tokenStr, tokens[i + 1].getToken());
                List<String> lcList = Arrays.asList(tokens[i - 1].getToken(), StringTools.lowercaseFirstChar((String)tokenStr), tokens[i + 1].getToken());
                Probability ucProb = this.lm.getPseudoProbability(ucList);
                Probability lcProb = this.lm.getPseudoProbability(lcList);
                double ratio = lcProb.getProb() / ucProb.getProb();
                if (ratio > 50.0) {
                    String msg = "Only proper nouns start with an uppercase character (there are exceptions for headlines).";
                    RuleMatch match = new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), msg);
                    match.setSuggestedReplacement(StringTools.lowercaseFirstChar((String)tokenStr));
                    matches.add(match);
                }
            }
            if (token.isSentenceStart() || tokenStr.isEmpty() || token.isNonWord()) continue;
            atSentStart = false;
        }
        return this.toRuleMatchArray(matches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMisspelled(String word) throws IOException {
        MorfologikAmericanSpellerRule morfologikAmericanSpellerRule = spellerRule;
        synchronized (morfologikAmericanSpellerRule) {
            return linguServices == null ? spellerRule.isMisspelled(word) : !linguServices.isCorrectSpell(word, this.lang);
        }
    }

    boolean maybeTitle(AnalyzedTokenReadings[] tokens, int i) {
        return this.firstLongWordToLeftIsUppercase(tokens, i) || this.firstLongWordToRightIsUppercase(tokens, i);
    }

    boolean firstLongWordToLeftIsUppercase(AnalyzedTokenReadings[] tokens, int pos) {
        for (int i = pos - 1; i > 1; --i) {
            if (this.isShortWord(tokens[i])) continue;
            return StringTools.startsWithUppercase((String)tokens[i].getToken());
        }
        return false;
    }

    boolean firstLongWordToRightIsUppercase(AnalyzedTokenReadings[] tokens, int pos) {
        for (int i = pos + 1; i < tokens.length; ++i) {
            if (this.isShortWord(tokens[i])) continue;
            return StringTools.startsWithUppercase((String)tokens[i].getToken());
        }
        return false;
    }

    private boolean isShortWord(AnalyzedTokenReadings token) {
        return token.getToken().trim().isEmpty() || token.getToken().matches("and|or|the|of|on|with|to|it|in|for|as|at|his|her|its|into|&|/");
    }

    private boolean trieMatches(String text, AnalyzedTokenReadings token) {
        List hits = exceptionTrie.parseText((CharSequence)text);
        for (AhoCorasickDoubleArrayTrie.Hit hit : hits) {
            if (hit.begin > token.getStartPos() || hit.end < token.getEndPos()) continue;
            return true;
        }
        return false;
    }

    private boolean prevIsOneOf(AnalyzedTokenReadings[] tokens, int i, List<String> strings) {
        return i > 0 && strings.contains(tokens[i - 1].getToken());
    }

    private boolean nextIsOneOfThenUppercase(AnalyzedTokenReadings[] tokens, int i, List<String> strings) {
        return i + 2 < tokens.length && strings.contains(tokens[i + 1].getToken()) && StringTools.startsWithUppercase((String)tokens[i + 2].getToken());
    }

    private boolean prevIsUpperCase(AnalyzedTokenReadings[] tokens, int i) {
        return i > 0 && StringTools.startsWithUppercase((String)tokens[i - 1].getToken());
    }

    private boolean nextIsUpperCase(AnalyzedTokenReadings[] tokens, int i) {
        return i + 1 < tokens.length && StringTools.startsWithUppercase((String)tokens[i + 1].getToken());
    }

    private boolean isSentence(AnalyzedTokenReadings[] tokens) {
        boolean isSentence = false;
        for (int i = tokens.length - 1; i > 0; --i) {
            if (tokens[i].getToken().matches("[.!?:]")) {
                isSentence = true;
                break;
            }
            if (!tokens[i].isParagraphEnd() && !tokens[i].isNonWord()) break;
        }
        return isSentence;
    }

    static {
        linguServices = null;
        exceptions = new HashSet<String>(Arrays.asList("Bin", "Spot", "Go", "French", "Roman", "Hawking", "Square", "Japan", "Premier", "Allied"));
        exceptionTrie = new AhoCorasickDoubleArrayTrie();
        ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.token((String)"Hugs"), PatternRuleBuilderHelper.token((String)"and"), PatternRuleBuilderHelper.token((String)"Kisses")), Arrays.asList(PatternRuleBuilderHelper.token((String)"go"), PatternRuleBuilderHelper.token((String)"to"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.tokenRegex((String)"[Aa]nd|[Oo]r|&"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"[Aa]nd|[Oo]r|&|,"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)")"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"[Aa]nd|[Oo]r|&|,"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z].+"), new PatternTokenBuilder().token("-").min(0).build(), PatternRuleBuilderHelper.token((String)">"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"[\u2192\u21fe\u21c9\u21d2]"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"[\\!\\?]")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)".*\\w.*"), PatternRuleBuilderHelper.tokenRegex((String)"-|\u2013"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)".*\\w.*"), PatternRuleBuilderHelper.tokenRegex((String)"[0-9]+"), PatternRuleBuilderHelper.tokenRegex((String)"-|\u2013"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+"), PatternRuleBuilderHelper.tokenRegex((String)"-|\u2013|,"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"\\d+"), PatternRuleBuilderHelper.token((String)"."), PatternRuleBuilderHelper.tokenRegex((String)"-|\u2013"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"\u00ab"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"H[1-6]"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)"[a-z]{1,2}"), PatternRuleBuilderHelper.token((String)")"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.token((String)"\u2022"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"-|\u2013"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Step|Grade|Phase|Reason"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"the|our|their"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"team|department")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+"), PatternRuleBuilderHelper.tokenRegex((String)"\\.|/"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)".*\\w.*"), PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.tokenRegex((String)"[0-9]+"), PatternRuleBuilderHelper.tokenRegex((String)"-|\u2013"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.token((String)"BBC"), PatternRuleBuilderHelper.token((String)"Culture")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Time"), PatternRuleBuilderHelper.tokenRegex((String)"magazines?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Dublin"), PatternRuleBuilderHelper.token((String)"Murders")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Amazon"), PatternRuleBuilderHelper.token((String)"Live")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Volvo"), PatternRuleBuilderHelper.token((String)"Buses")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Heavy"), PatternRuleBuilderHelper.token((String)"Rain")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)"/"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)"."), PatternRuleBuilderHelper.tokenRegex((String)"com?|de|us|gov|net|info|org|es|mx|ca|uk|at|ch|it|pl|ru|nl|ie|be|fr|ai|dev|io|pt|mil|club|jp|es|se|dk|no")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)"("), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)")")), Arrays.asList(PatternRuleBuilderHelper.token((String)"["), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)"]")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Pay"), PatternRuleBuilderHelper.token((String)"per"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Hi|Hello|Heya?"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z]"), PatternRuleBuilderHelper.tokenRegex((String)"is|stands"), PatternRuleBuilderHelper.token((String)"for"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)":")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)"&"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)":")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"[a-z].+"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)":")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+%?"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[0-9]+"), PatternRuleBuilderHelper.tokenRegex((String)"[)\\]]"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[a-z]"), PatternRuleBuilderHelper.tokenRegex((String)"[)\\]]"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[\\(\\]]"), PatternRuleBuilderHelper.tokenRegex((String)"[a-z0-9]"), PatternRuleBuilderHelper.tokenRegex((String)"[)\\]]")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.tokenRegex((String)"[0-9]+"), PatternRuleBuilderHelper.tokenRegex((String)"."), PatternRuleBuilderHelper.tokenRegex((String)"[0-9]+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].*"), PatternRuleBuilderHelper.tokenRegex((String)"['\u2019`\u00b4\u2018]"), PatternRuleBuilderHelper.tokenRegex((String)"t|d|ve|s|re|m|ll"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"The"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)"is"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Professor"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Time"), PatternRuleBuilderHelper.token((String)"magazine")), Arrays.asList(PatternRuleBuilderHelper.token((String)"name"), PatternRuleBuilderHelper.token((String)"is"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"calls?|called|calling|name[ds]?|naming"), PatternRuleBuilderHelper.token((String)"it|him|her|them|me|us|that|this"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"some(thing|body|one)"), PatternRuleBuilderHelper.tokenRegex((String)"called|named"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"is|was|been|were|are"), PatternRuleBuilderHelper.csRegex((String)"calls?|called|calling|name[ds]?|naming"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Who|What"), PatternRuleBuilderHelper.tokenRegex((String)"is|are|was|were"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.token((String)"?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"name"), PatternRuleBuilderHelper.tokenRegex((String)"is|was"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].*"), PatternRuleBuilderHelper.token((String)"Group")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Enter|Escape|Shift|Control|Meta|Backspace"), PatternRuleBuilderHelper.token((String)"key")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"NNP"), PatternRuleBuilderHelper.tokenRegex((String)"or|and|&"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Teams|Maps|Canvas|Remind|Tile|Switch|Gems?|Glamour|Divvy|Solo|Splash|Phrase||Spotlight|Outreach|Grab")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].*"), PatternRuleBuilderHelper.tokenRegex((String)"or|and|&"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].*"), PatternRuleBuilderHelper.pos((String)"SENT_END")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"click(ed|s)?|type(d|s)|hit"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"click(ed|s)?"), PatternRuleBuilderHelper.tokenRegex((String)"on|at"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Chronicle"), PatternRuleBuilderHelper.token((String)"of"), PatternRuleBuilderHelper.tokenRegex((String)"the|an?"), PatternRuleBuilderHelper.tokenRegex((String)"[A-Z].*")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z].*"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z].*"), PatternRuleBuilderHelper.token((String)"#"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Finance|Marketing|Engineering|Controlling|Support|Accounting")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z].*"), PatternRuleBuilderHelper.token((String)"."), PatternRuleBuilderHelper.tokenRegex((String)"js")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Wed")), Arrays.asList(new PatternTokenBuilder().posRegex("NN.*").csTokenRegex("[A-Z].+").build(), PatternRuleBuilderHelper.token((String)"'s"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"How"), PatternRuleBuilderHelper.csRegex((String)"to"), new PatternTokenBuilder().pos("VB").csTokenRegex("[A-Z].+").build(), PatternRuleBuilderHelper.csRegex((String)"an?|my|y?our|her|his|the|from|by|about"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Do|Does|Did|Can|[CW]ould"), PatternRuleBuilderHelper.csRegex((String)"n't"), new PatternTokenBuilder().pos("VB").csTokenRegex("[A-Z].+").build(), PatternRuleBuilderHelper.pos((String)"IN"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Let"), PatternRuleBuilderHelper.csRegex((String)"'s"), new PatternTokenBuilder().pos("VB").csTokenRegex("[A-Z].+").build(), PatternRuleBuilderHelper.pos((String)"IN"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Enter|Return|Escape|Shift")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z].+"), PatternRuleBuilderHelper.csRegex((String)"Ca|Wo|Do|Should|[CW]ould|Must|Did|Does|Need"), PatternRuleBuilderHelper.csRegex((String)"n't"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Ca|Wo|Do|Should|[CW]ould|Must|Did|Does|Need"), PatternRuleBuilderHelper.csRegex((String)"n't"), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.token((String)"="), PatternRuleBuilderHelper.csRegex((String)"[A-Z].+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Peters")));
    }
}

