/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.English;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class EnglishPlainEnglishRule
extends AbstractSimpleReplaceRule2 {
    public static final String EN_PLAIN_ENGLISH_REPLACE = "EN_PLAIN_ENGLISH_REPLACE";
    private static final String FILE_NAME = "/en/wordiness.txt";
    private static final Locale EN_LOCALE = new Locale("en");

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public EnglishPlainEnglishRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new English());
        this.setDefaultOff();
        super.setCategory(Categories.PLAIN_ENGLISH.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>fatal outcome</marker>"), Example.fixed((String)"<marker>death</marker>"));
    }

    public final String getId() {
        return EN_PLAIN_ENGLISH_REPLACE;
    }

    public String getDescription() {
        return "1. Wordiness (General)";
    }

    public String getShort() {
        return "Wordiness";
    }

    public String getMessage() {
        return "'$match' is a wordy or complex expression. In some cases, it might be preferable to use $suggestions.";
    }

    public String getSuggestionsSeparator() {
        return " or ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://en.wikipedia.org/wiki/List_of_plain_English_words_and_phrases");
    }

    public Locale getLocale() {
        return EN_LOCALE;
    }
}

