/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.SymbolLocator;
import org.languagetool.rules.UnsyncStack;

public class EnglishUnpairedBracketsRule
extends GenericUnpairedBracketsRule {
    private static final List<String> EN_START_SYMBOLS = Arrays.asList("[", "(", "{", "\"");
    private static final List<String> EN_END_SYMBOLS = Arrays.asList("]", ")", "}", "\"");
    private static final Pattern INCH_PATTERN = Pattern.compile(".*\\d\".*", 32);
    private static final Pattern YEAR_NUMBER = Pattern.compile("\\d\\ds?");
    private static final Pattern ALPHA = Pattern.compile("\\p{L}+");

    public EnglishUnpairedBracketsRule(ResourceBundle messages, Language language) {
        super(messages, EN_START_SYMBOLS, EN_END_SYMBOLS);
        this.addExamplePair(Example.wrong((String)"\"I'm over here,<marker></marker> she said."), Example.fixed((String)"\"I'm over here,<marker>\"</marker> she said."));
    }

    public String getId() {
        return "EN_UNPAIRED_BRACKETS";
    }

    protected boolean preventMatch(AnalyzedSentence sentence) {
        String text = sentence.getText();
        Matcher inchMatcher = INCH_PATTERN.matcher(text);
        return inchMatcher.matches();
    }

    protected boolean isNoException(String tokenStr, AnalyzedTokenReadings[] tokens, int i, int j, boolean precSpace, boolean follSpace, UnsyncStack<SymbolLocator> symbolStack) {
        boolean superException;
        if (i <= 1) {
            return true;
        }
        if (i > 2 && "'".equals(tokens[i].getToken()) && "-".equals(tokens[i - 1].getToken()) && !tokens[i - 1].isWhitespaceBefore() && ALPHA.matcher(tokens[i - 2].getToken()).matches()) {
            return false;
        }
        boolean bl = superException = !super.isNoException(tokenStr, tokens, i, j, precSpace, follSpace, symbolStack);
        if (superException) {
            return false;
        }
        if (!precSpace && follSpace || tokens[i].isSentenceEnd()) {
            AnalyzedTokenReadings prevToken = tokens[i - 1];
            if ("\"".equals(tokenStr) && !symbolStack.empty() && "\"".equals(((SymbolLocator)symbolStack.peek()).getSymbol())) {
                return true;
            }
            if (this.isQuote(tokenStr) && tokens[i].hasPosTag("POS")) {
                return false;
            }
            if (this.isQuote(tokenStr) && prevToken.hasPosTag("VBG") && prevToken.getToken().endsWith("in")) {
                return false;
            }
            if (this.isQuote(tokenStr) && prevToken.getToken().equals("Dunkin")) {
                return false;
            }
        }
        if (precSpace && !follSpace && "'".equals(tokenStr) && i + 1 < tokens.length) {
            if ("em".equals(tokens[i + 1].getToken())) {
                return false;
            }
            if (YEAR_NUMBER.matcher(tokens[i + 1].getToken()).matches()) {
                return false;
            }
        }
        return true;
    }

    private boolean isQuote(String tokenStr) {
        return "'".equals(tokenStr) || "\u2019".equals(tokenStr);
    }
}

