/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class NewZealandReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String NEW_ZEALAND_SIMPLE_REPLACE_RULE = "EN_NZ_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = NewZealandReplaceRule.loadFromPath((String)"/en/en-NZ/replace.txt");
    private static final Locale EN_NZ_LOCALE = new Locale("en-NZ");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public NewZealandReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"A <marker>sidewalk</marker> is a path along the side of a road."), Example.fixed((String)"A <marker>footpath</marker> is a path along the side of a road."));
    }

    public final String getId() {
        return NEW_ZEALAND_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "English words easily confused in New Zealand English";
    }

    public String getShort() {
        return "Not a New Zealand English word";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "'" + tokenStr + "' is a non-standard expression. Consider using expressions more common to New Zealand English.";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return EN_NZ_LOCALE;
    }
}

