/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class CompoundRule
extends AbstractCompoundRule {
    private static volatile CompoundRuleData compoundData;
    private static final Language AMERICAN_ENGLISH;
    private static final List<DisambiguationPatternRule> ANTI_PATTERNS;

    public CompoundRule(ResourceBundle messages) throws IOException {
        super(messages, "This word is normally spelled with a hyphen.", "This word is normally spelled as one.", "This expression is normally spelled as one or with a hyphen.", "Compound");
        this.addExamplePair(Example.wrong((String)"I now have a <marker>part time</marker> job."), Example.fixed((String)"I now have a <marker>part-time</marker> job."));
    }

    public String getId() {
        return "EN_COMPOUNDS";
    }

    public String getDescription() {
        return "Hyphenated words, e.g., 'case-sensitive' instead of 'case sensitive'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CompoundRuleData getCompoundRuleData() {
        CompoundRuleData data = compoundData;
        if (data != null) return data;
        Class<CompoundRule> clazz = CompoundRule.class;
        synchronized (CompoundRule.class) {
            data = compoundData;
            if (data != null) return data;
            compoundData = data = new CompoundRuleData("/en/compounds.txt");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data;
        }
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return ANTI_PATTERNS;
    }

    static {
        AMERICAN_ENGLISH = Languages.getLanguageForShortCode((String)"en-US");
        ANTI_PATTERNS = CompoundRule.makeAntiPatterns(Arrays.asList(Arrays.asList(new PatternTokenBuilder().tokenRegex("['\u2019`\u00b4\u2018]").build(), new PatternTokenBuilder().token("re").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("and|&").build(), new PatternTokenBuilder().token("co").build()), Arrays.asList(new PatternTokenBuilder().token("power").build(), new PatternTokenBuilder().token("off").build(), new PatternTokenBuilder().token("key").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("senior|junior").build(), new PatternTokenBuilder().token("year").build(), new PatternTokenBuilder().token("end").build()), Arrays.asList(new PatternTokenBuilder().token("under").build(), new PatternTokenBuilder().token("investment").build(), new PatternTokenBuilder().token("banking").build()), Arrays.asList(new PatternTokenBuilder().token("spring").build(), new PatternTokenBuilder().tokenRegex("cleans?|cleaned|cleaning").build(), new PatternTokenBuilder().tokenRegex("up|the|my|our|his|her").build())), (Language)AMERICAN_ENGLISH);
    }
}

