/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.languagetool.Languages;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.en.EnglishSynthesizer;

public class AmericanReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String BRITISH_SIMPLE_REPLACE_RULE = "EN_US_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = AmericanReplaceRule.loadFromPath((String)"/en/en-US/replace.txt");
    private static final Supplier<Synthesizer> synth = Suppliers.memoize(() -> new EnglishSynthesizer(Languages.getLanguageForShortCode((String)"en")));
    private static final Locale EN_US_LOCALE = new Locale("en-US");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public AmericanReplaceRule(ResourceBundle messages) {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"Are baked <marker>crisps</marker> healthy?"), Example.fixed((String)"Are baked <marker>chips</marker> healthy?"));
    }

    public final String getId() {
        return BRITISH_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "British words easily confused in American English";
    }

    public String getShort() {
        return "British word";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "'" + tokenStr + "' is a common British expression. Consider using expressions more common to American English.";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return EN_US_LOCALE;
    }

    public Synthesizer getSynthesizer() {
        return synth.get();
    }
}

