/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.ngrams.ConfusionProbabilityRule;

public class EnglishConfusionProbabilityRule
extends ConfusionProbabilityRule {
    private static final List<String> EXCEPTIONS = Arrays.asList("host to five", "had I known", "is not exactly known", "live duet", "isn't known", "your move makes", "your move is", "he unchecked the", "thank you for the patience", "your patience regarding", "your fix", "your commit", "on point", "chapter one", "usb port", "know the competition and", "know the competition or", "know your competition and", "know your competition or", "G Suite", "paste event", "need to know", "of you not", "of her element", "very grateful of you", "your use case", "he's", "he\u2019s", "they're", "they\u2019re", "your look is", "have you known", "have I known", "had I known", "had you known", "his fluffy butt", "it's now better", "it\u2019s now better", "it is now better", "let us know below", "let us know in", "your kind of", "sneak peek", "the 4 of you", "confirm you own the", "your ride", "he most likely", "good cause", "big butt", "news debate", "verify you own", "ensure you own", "happy us!", "your pick up", "no but you", "no but we", "no but he", "no but I", "no but they", "no but she", "no but it", "he tracks");

    public EnglishConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public EnglishConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        super(messages, languageModel, language, grams, EXCEPTIONS);
        this.addExamplePair(Example.wrong((String)"I did not <marker>now</marker> where it came from."), Example.fixed((String)"I did not <marker>know</marker> where it came from."));
    }

    protected boolean isException(String sentence, int startPos, int endPos) {
        String covered;
        return startPos > 3 && (covered = sentence.substring(startPos - 3, endPos)).matches("['\u2019`\u00b4\u2018]t .*");
    }
}

