/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public class AdverbFilter
extends RuleFilter {
    private Map<String, String> adverb2Adj = new HashMap<String, String>(){
        {
            this.put("well", "good");
            this.put("fast", "fast");
            this.put("hard", "hard");
            this.put("late", "late");
            this.put("early", "early");
            this.put("daily", "daily");
            this.put("straight", "straight");
            this.put("simply", "simple");
            this.put("cheaply", "cheap");
            this.put("quickly", "quick");
            this.put("slowly", "slow");
            this.put("easily", "easy");
            this.put("angrily", "angry");
            this.put("happily", "happy");
            this.put("luckily", "lucky");
            this.put("probably", "probable");
            this.put("terribly", "terrible");
            this.put("gently", "gentle");
            this.put("basically", "basic");
            this.put("tragically", "tragic");
            this.put("economically", "economic");
            this.put("greatly", "great");
            this.put("highly", "high");
            this.put("generally", "general");
            this.put("differently", "different");
            this.put("rightly", "right");
            this.put("largely", "large");
            this.put("really", "real");
            this.put("philosophically", "philosophical");
            this.put("directly", "direct");
            this.put("clearly", "clear");
            this.put("merely", "mere");
            this.put("exactly", "exact");
            this.put("recently", "recent");
            this.put("rapidly", "rapid");
            this.put("suddenly", "sudden");
            this.put("extremely", "extreme");
            this.put("properly", "proper");
        }
    };

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) {
        String adverb = arguments.get("adverb");
        String noun = arguments.get("noun");
        String adjective = this.adverb2Adj.get(adverb);
        if (adjective != null && !adjective.equals(adverb)) {
            match.setSuggestedReplacement(adjective + " " + noun);
        }
        return match;
    }
}

