/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.English;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.en.VariantInfo;
import org.languagetool.rules.en.translation.BeoLingusTranslator;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.rules.translation.Translator;
import org.languagetool.synthesis.en.EnglishSynthesizer;
import org.languagetool.tools.StringTools;

public abstract class AbstractEnglishSpellerRule
extends MorfologikSpellerRule {
    private static final EnglishSynthesizer synthesizer = new EnglishSynthesizer(new English());
    private final BeoLingusTranslator translator;

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null, Collections.emptyList());
    }

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        this(messages, language, null, userConfig, altLanguages, null, null);
    }

    protected static Map<String, String> loadWordlist(String path, int column) {
        if (column != 0 && column != 1) {
            throw new IllegalArgumentException("Only column 0 and 1 are supported: " + column);
        }
        HashMap<String, String> words = new HashMap<String, String>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] parts = line.split(";");
            if (parts.length != 2) {
                throw new RuntimeException("Unexpected format in " + path + ": " + line + " - expected two parts delimited by ';'");
            }
            words.put(parts[column].toLowerCase(), parts[column == 1 ? 0 : 1]);
        }
        return words;
    }

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, GlobalConfig globalConfig, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel, Language motherTongue) throws IOException {
        super(messages, language, globalConfig, userConfig, altLanguages, languageModel, motherTongue);
        this.ignoreWordsWithLength = 1;
        this.setCheckCompound(true);
        this.addExamplePair(Example.wrong((String)"This <marker>sentenc</marker> contains a spelling mistake."), Example.fixed((String)"This <marker>sentence</marker> contains a spelling mistake."));
        String languageSpecificIgnoreFile = this.getSpellingFileName().replace(".txt", "_" + language.getShortCodeWithCountryAndVariant() + ".txt");
        for (String ignoreWord : this.wordListLoader.loadWords(languageSpecificIgnoreFile)) {
            this.addIgnoreWords(ignoreWord);
        }
        this.translator = BeoLingusTranslator.getInstance(globalConfig);
    }

    protected List<String> filterSuggestions(List<String> suggestions, AnalyzedSentence sentence, int i) {
        List result = super.filterSuggestions(suggestions, sentence, i);
        ArrayList<String> clean = new ArrayList<String>();
        for (String suggestion : result) {
            if (suggestion.matches(".* (s|t|d|ll|ve)")) continue;
            clean.add(suggestion);
        }
        return clean;
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int idx, AnalyzedTokenReadings[] tokens) throws IOException {
        List ruleMatches = super.getRuleMatches(word, startPos, sentence, ruleMatchesSoFar, idx, tokens);
        if (ruleMatches.size() > 0) {
            IrregularForms forms = this.getIrregularFormsOrNull(word);
            if (forms != null) {
                String message = "Possible spelling mistake. Did you mean <suggestion>" + forms.forms.get(0) + "</suggestion>, the " + forms.formName + " form of the " + forms.posName + " '" + forms.baseform + "'?";
                this.addFormsToFirstMatch(message, sentence, ruleMatches, forms.forms);
            } else {
                VariantInfo variantInfo = this.isValidInOtherVariant(word);
                if (variantInfo != null) {
                    String message = "Possible spelling mistake. '" + word + "' is " + variantInfo.getVariantName() + ".";
                    String suggestion = StringTools.startsWithUppercase((String)word) ? StringTools.uppercaseFirstChar((String)variantInfo.otherVariant()) : variantInfo.otherVariant();
                    this.replaceFormsOfFirstMatch(message, sentence, ruleMatches, suggestion);
                }
            }
        }
        for (RuleMatch ruleMatch : ruleMatches) {
            List cleaned = ruleMatch.getSuggestedReplacementObjects().stream().filter(k -> !k.getReplacement().startsWith("re ") && !k.getReplacement().endsWith(" ed")).collect(Collectors.toList());
            ruleMatch.setSuggestedReplacementObjects(cleaned);
        }
        return ruleMatches;
    }

    @Nullable
    protected VariantInfo isValidInOtherVariant(String word) {
        return null;
    }

    private void addFormsToFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, List<String> forms) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch((Rule)this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        ArrayList<String> allSuggestions = new ArrayList<String>(forms);
        for (String repl : oldMatch.getSuggestedReplacements()) {
            if (allSuggestions.contains(repl)) continue;
            allSuggestions.add(repl);
        }
        newMatch.setSuggestedReplacements(allSuggestions);
        ruleMatches.set(0, newMatch);
    }

    private void replaceFormsOfFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, String suggestion) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch((Rule)this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        SuggestedReplacement sugg = new SuggestedReplacement(suggestion);
        sugg.setShortDescription(this.language.getName());
        newMatch.setSuggestedReplacementObjects(Collections.singletonList(sugg));
        ruleMatches.set(0, newMatch);
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word) {
        IrregularForms irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("ed"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("d"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "s", Arrays.asList("s"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "es", Arrays.asList("es"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "er", Arrays.asList("er"), "JJR", "adjective", "comparative");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "est", Arrays.asList("est"), "JJS", "adjective", "superlative");
        return irregularFormsOrNull;
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word, String wordSuffix, List<String> suffixes, String posTag, String posName, String formName) {
        try {
            for (String suffix : suffixes) {
                if (!word.endsWith(wordSuffix)) continue;
                String baseForm = word.substring(0, word.length() - suffix.length());
                String[] forms = synthesizer.synthesize(new AnalyzedToken(word, null, baseForm), posTag);
                ArrayList<String> result = new ArrayList<String>();
                for (String form : forms) {
                    if (this.speller1.isMisspelled(form)) continue;
                    result.add(form);
                }
                result.remove(word);
                result.remove("badder");
                result.remove("baddest");
                result.remove("spake");
                if (result.size() <= 0) continue;
                return new IrregularForms(baseForm, posName, formName, result);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        String suggestion;
        if ("Alot".equals(word)) {
            return Arrays.asList("A lot");
        }
        if ("alot".equals(word)) {
            return Arrays.asList("a lot");
        }
        if ("css".equals(word)) {
            return Arrays.asList("CSS");
        }
        if ("ad-hoc".equals(word) || "adhoc".equals(word)) {
            return Arrays.asList("ad hoc");
        }
        if ("Ad-hoc".equals(word) || "Adhoc".equals(word)) {
            return Arrays.asList("Ad hoc");
        }
        if ("ad-on".equals(word) || "add-o".equals(word)) {
            return Arrays.asList("add-on");
        }
        if ("acc".equals(word)) {
            return Arrays.asList("account", "accusative");
        }
        if ("Acc".equals(word)) {
            return Arrays.asList("Account", "Accusative");
        }
        if ("jus".equals(word)) {
            return Arrays.asList("just", "juice");
        }
        if ("Jus".equals(word)) {
            return Arrays.asList("Just", "Juice");
        }
        if ("sayed".equals(word)) {
            return Arrays.asList("said");
        }
        if ("sess".equals(word)) {
            return Arrays.asList("says", "session", "cess");
        }
        if ("Addon".equals(word)) {
            return Arrays.asList("Add-on");
        }
        if ("Addons".equals(word)) {
            return Arrays.asList("Add-ons");
        }
        if ("ios".equals(word)) {
            return Arrays.asList("iOS");
        }
        if ("yrs".equals(word)) {
            return Arrays.asList("years");
        }
        if ("standup".equals(word)) {
            return Arrays.asList("stand-up");
        }
        if ("standups".equals(word)) {
            return Arrays.asList("stand-ups");
        }
        if ("Standup".equals(word)) {
            return Arrays.asList("Stand-up");
        }
        if ("Standups".equals(word)) {
            return Arrays.asList("Stand-ups");
        }
        if ("Playdough".equals(word)) {
            return Arrays.asList("Play-Doh");
        }
        if ("playdough".equals(word)) {
            return Arrays.asList("Play-Doh");
        }
        if ("biggy".equals(word)) {
            return Arrays.asList("biggie");
        }
        if ("lieing".equals(word)) {
            return Arrays.asList("lying");
        }
        if ("preffered".equals(word)) {
            return Arrays.asList("preferred");
        }
        if ("preffering".equals(word)) {
            return Arrays.asList("preferring");
        }
        if ("reffered".equals(word)) {
            return Arrays.asList("referred");
        }
        if ("reffering".equals(word)) {
            return Arrays.asList("referring");
        }
        if ("passthrough".equals(word)) {
            return Arrays.asList("pass-through");
        }
        if ("&&".equals(word)) {
            return Arrays.asList("&");
        }
        if ("cmon".equals(word)) {
            return Arrays.asList("c'mon");
        }
        if ("Cmon".equals(word)) {
            return Arrays.asList("C'mon");
        }
        if ("da".equals(word)) {
            return Arrays.asList("the");
        }
        if ("Da".equals(word)) {
            return Arrays.asList("The");
        }
        if ("Vue".equals(word)) {
            return Arrays.asList("Vue.JS");
        }
        if ("errornous".equals(word)) {
            return Arrays.asList("erroneous");
        }
        if ("brang".equals(word) || "brung".equals(word)) {
            return Arrays.asList("brought");
        }
        if ("thru".equals(word)) {
            return Arrays.asList("through");
        }
        if ("pitty".equals(word)) {
            return Arrays.asList("pity");
        }
        if ("speach".equals(word)) {
            return Arrays.asList("speech");
        }
        if ("icecreem".equals(word)) {
            return Arrays.asList("ice cream");
        }
        if ("math".equals(word)) {
            return Arrays.asList("maths");
        }
        if ("fora".equals(word)) {
            return Arrays.asList("for a");
        }
        if ("lotsa".equals(word)) {
            return Arrays.asList("lots of");
        }
        if ("tryna".equals(word)) {
            return Arrays.asList("trying to");
        }
        if ("coulda".equals(word)) {
            return Arrays.asList("could have");
        }
        if ("shoulda".equals(word)) {
            return Arrays.asList("should have");
        }
        if ("woulda".equals(word)) {
            return Arrays.asList("would have");
        }
        if ("tellem".equals(word)) {
            return Arrays.asList("tell them");
        }
        if ("Tellem".equals(word)) {
            return Arrays.asList("Tell them");
        }
        if ("afro-american".equalsIgnoreCase(word)) {
            return Arrays.asList("Afro-American");
        }
        if ("Oconnor".equalsIgnoreCase(word)) {
            return Arrays.asList("O'Connor");
        }
        if ("Oconor".equalsIgnoreCase(word)) {
            return Arrays.asList("O'Conor");
        }
        if ("Obrien".equalsIgnoreCase(word)) {
            return Arrays.asList("O'Brien");
        }
        if ("Odonnell".equalsIgnoreCase(word)) {
            return Arrays.asList("O'Donnell");
        }
        if ("Oneill".equalsIgnoreCase(word)) {
            return Arrays.asList("O'Neill");
        }
        if ("Oneil".equalsIgnoreCase(word)) {
            return Arrays.asList("O'Neil");
        }
        if ("Oconnell".equalsIgnoreCase(word)) {
            return Arrays.asList("O'Connell");
        }
        if ("Webex".equals(word)) {
            return Arrays.asList("WebEx");
        }
        if ("didint".equals(word)) {
            return Arrays.asList("didn't");
        }
        if ("Didint".equals(word)) {
            return Arrays.asList("Didn't");
        }
        if ("wasint".equals(word)) {
            return Arrays.asList("wasn't");
        }
        if ("hasint".equals(word)) {
            return Arrays.asList("hasn't");
        }
        if ("doesint".equals(word)) {
            return Arrays.asList("doesn't");
        }
        if ("ist".equals(word)) {
            return Arrays.asList("is");
        }
        if ("Boing".equals(word)) {
            return Arrays.asList("Boeing");
        }
        if ("te".equals(word)) {
            return Arrays.asList("the");
        }
        if ("todays".equals(word)) {
            return Arrays.asList("today's");
        }
        if ("Todays".equals(word)) {
            return Arrays.asList("Today's");
        }
        if ("todo".equals(word)) {
            return Arrays.asList("to-do", "to do");
        }
        if ("todos".equals(word)) {
            return Arrays.asList("to-dos", "to do");
        }
        if ("Todo".equalsIgnoreCase(word)) {
            return Arrays.asList("To-do", "To do");
        }
        if ("Todos".equalsIgnoreCase(word)) {
            return Arrays.asList("To-dos");
        }
        if ("heres".equals(word)) {
            return Arrays.asList("here's");
        }
        if ("Heres".equals(word)) {
            return Arrays.asList("Here's");
        }
        if ("aways".equals(word)) {
            return Arrays.asList("always");
        }
        if ("McDonalds".equals(word)) {
            return Arrays.asList("McDonald's");
        }
        if ("ux".equals(word)) {
            return Arrays.asList("UX");
        }
        if ("ive".equals(word)) {
            return Arrays.asList("I've");
        }
        if ("infos".equals(word)) {
            return Arrays.asList("informations");
        }
        if ("Infos".equals(word)) {
            return Arrays.asList("Informations");
        }
        if ("prios".equals(word)) {
            return Arrays.asList("priorities");
        }
        if ("Prio".equals(word)) {
            return Arrays.asList("Priority");
        }
        if ("prio".equals(word)) {
            return Arrays.asList("Priority");
        }
        if ("Ecommerce".equals(word)) {
            return Arrays.asList("E-Commerce");
        }
        if ("ecommerce".equalsIgnoreCase(word)) {
            return Arrays.asList("e-commerce");
        }
        if ("elearning".equalsIgnoreCase(word)) {
            return Arrays.asList("e-learning");
        }
        if ("ebook".equals(word)) {
            return Arrays.asList("e-book");
        }
        if ("ebooks".equals(word)) {
            return Arrays.asList("e-books");
        }
        if ("eBook".equals(word)) {
            return Arrays.asList("e-book");
        }
        if ("eBooks".equals(word)) {
            return Arrays.asList("e-books");
        }
        if ("Ebook".equals(word)) {
            return Arrays.asList("E-Book");
        }
        if ("Ebooks".equals(word)) {
            return Arrays.asList("E-Books");
        }
        if ("Esport".equals(word)) {
            return Arrays.asList("E-Sport");
        }
        if ("Esports".equals(word)) {
            return Arrays.asList("E-Sports");
        }
        if ("esport".equalsIgnoreCase(word)) {
            return Arrays.asList("e-sport");
        }
        if ("esports".equalsIgnoreCase(word)) {
            return Arrays.asList("e-sports");
        }
        if ("R&B".equals(word)) {
            return Arrays.asList("R & B", "R 'n' B");
        }
        if ("ie".equals(word)) {
            return Arrays.asList("i.e.");
        }
        if ("eg".equals(word)) {
            return Arrays.asList("e.g.");
        }
        if ("ppl".equals(word)) {
            return Arrays.asList("people");
        }
        if ("kiddin".equals(word)) {
            return Arrays.asList("kidding");
        }
        if ("doin".equals(word)) {
            return Arrays.asList("doing");
        }
        if ("nothin".equals(word)) {
            return Arrays.asList("nothing");
        }
        if ("Thx".equals(word)) {
            return Arrays.asList("Thanks");
        }
        if ("thx".equals(word)) {
            return Arrays.asList("thanks");
        }
        if ("ty".equals(word)) {
            return Arrays.asList("thank you", "thanks");
        }
        if ("Sry".equals(word)) {
            return Arrays.asList("Sorry");
        }
        if ("sry".equals(word)) {
            return Arrays.asList("sorry");
        }
        if ("im".equals(word)) {
            return Arrays.asList("I'm");
        }
        if ("spoilt".equals(word)) {
            return Arrays.asList("spoiled");
        }
        if ("Lil".equals(word)) {
            return Arrays.asList("Little");
        }
        if ("lil".equals(word)) {
            return Arrays.asList("little");
        }
        if ("gmail".equals(word) || "g-mail".equalsIgnoreCase(word)) {
            return Arrays.asList("Gmail");
        }
        if ("Sucka".equals(word)) {
            return Arrays.asList("Sucker");
        }
        if ("sucka".equals(word)) {
            return Arrays.asList("sucker");
        }
        if ("whaddya".equals(word)) {
            return Arrays.asList("what are you", "what do you");
        }
        if ("Whaddya".equals(word)) {
            return Arrays.asList("What are you", "What do you");
        }
        if ("sinc".equals(word)) {
            return Arrays.asList("sync");
        }
        if ("sweety".equals(word)) {
            return Arrays.asList("sweetie");
        }
        if ("sweetys".equals(word)) {
            return Arrays.asList("sweeties");
        }
        if ("Hongkong".equals(word)) {
            return Arrays.asList("Hong Kong");
        }
        if ("Playstation".equalsIgnoreCase(word)) {
            return Arrays.asList("PlayStation");
        }
        if ("center".equals(word)) {
            return Arrays.asList("centre");
        }
        if ("ur".equals(word)) {
            return Arrays.asList("your", "you are");
        }
        if ("Ur".equals(word)) {
            return Arrays.asList("Your", "You are");
        }
        if ("ure".equals(word)) {
            return Arrays.asList("your", "you are");
        }
        if ("Ure".equals(word)) {
            return Arrays.asList("Your", "You are");
        }
        if ("mins".equals(word)) {
            return Arrays.asList("minutes", "min");
        }
        if ("addon".equals(word)) {
            return Arrays.asList("add-on");
        }
        if ("addons".equals(word)) {
            return Arrays.asList("add-ons");
        }
        if ("afterparty".equals(word)) {
            return Arrays.asList("after-party");
        }
        if ("Afterparty".equals(word)) {
            return Arrays.asList("After-party");
        }
        if ("wellbeing".equals(word)) {
            return Arrays.asList("well-being");
        }
        if ("cuz".equals(word) || "coz".equals(word)) {
            return Arrays.asList("because");
        }
        if ("pls".equals(word)) {
            return Arrays.asList("please");
        }
        if ("Pls".equals(word)) {
            return Arrays.asList("Please");
        }
        if ("plz".equals(word)) {
            return Arrays.asList("please");
        }
        if ("Plz".equals(word)) {
            return Arrays.asList("Please");
        }
        if ("addendums".equals(word)) {
            return Arrays.asList("addenda");
        }
        if ("algas".equals(word)) {
            return Arrays.asList("algae");
        }
        if ("alumnas".equals(word)) {
            return Arrays.asList("alumnae");
        }
        if ("alumnuses".equals(word)) {
            return Arrays.asList("alumni");
        }
        if ("analysises".equals(word)) {
            return Arrays.asList("analyses");
        }
        if ("appendixs".equals(word)) {
            return Arrays.asList("appendices");
        }
        if ("axises".equals(word)) {
            return Arrays.asList("axes");
        }
        if ("bacilluses".equals(word)) {
            return Arrays.asList("bacilli");
        }
        if ("bacteriums".equals(word)) {
            return Arrays.asList("bacteria");
        }
        if ("basises".equals(word)) {
            return Arrays.asList("bases");
        }
        if ("beaus".equals(word)) {
            return Arrays.asList("beaux");
        }
        if ("bisons".equals(word)) {
            return Arrays.asList("bison");
        }
        if ("buffalos".equals(word)) {
            return Arrays.asList("buffaloes");
        }
        if ("calfs".equals(word)) {
            return Arrays.asList("calves");
        }
        if ("childs".equals(word)) {
            return Arrays.asList("children");
        }
        if ("crisises".equals(word)) {
            return Arrays.asList("crises");
        }
        if ("criterions".equals(word)) {
            return Arrays.asList("criteria");
        }
        if ("curriculums".equals(word)) {
            return Arrays.asList("curricula");
        }
        if ("datums".equals(word)) {
            return Arrays.asList("data");
        }
        if ("deers".equals(word)) {
            return Arrays.asList("deer");
        }
        if ("diagnosises".equals(word)) {
            return Arrays.asList("diagnoses");
        }
        if ("echos".equals(word)) {
            return Arrays.asList("echoes");
        }
        if ("elfs".equals(word)) {
            return Arrays.asList("elves");
        }
        if ("ellipsises".equals(word)) {
            return Arrays.asList("ellipses");
        }
        if ("embargos".equals(word)) {
            return Arrays.asList("embargoes");
        }
        if ("erratums".equals(word)) {
            return Arrays.asList("errata");
        }
        if ("firemans".equals(word)) {
            return Arrays.asList("firemen");
        }
        if ("fishs".equals(word)) {
            return Arrays.asList("fishes", "fish");
        }
        if ("genuses".equals(word)) {
            return Arrays.asList("genera");
        }
        if ("gooses".equals(word)) {
            return Arrays.asList("geese");
        }
        if ("halfs".equals(word)) {
            return Arrays.asList("halves");
        }
        if ("heros".equals(word)) {
            return Arrays.asList("heroes");
        }
        if ("indexs".equals(word)) {
            return Arrays.asList("indices", "indexes");
        }
        if ("lifes".equals(word)) {
            return Arrays.asList("lives");
        }
        if ("mans".equals(word)) {
            return Arrays.asList("men");
        }
        if ("matrixs".equals(word)) {
            return Arrays.asList("matrices");
        }
        if ("meanses".equals(word)) {
            return Arrays.asList("means");
        }
        if ("mediums".equals(word)) {
            return Arrays.asList("media");
        }
        if ("memorandums".equals(word)) {
            return Arrays.asList("memoranda");
        }
        if ("mooses".equals(word)) {
            return Arrays.asList("moose");
        }
        if ("mosquitos".equals(word)) {
            return Arrays.asList("mosquitoes");
        }
        if ("neurosises".equals(word)) {
            return Arrays.asList("neuroses");
        }
        if ("nucleuses".equals(word)) {
            return Arrays.asList("nuclei");
        }
        if ("oasises".equals(word)) {
            return Arrays.asList("oases");
        }
        if ("ovums".equals(word)) {
            return Arrays.asList("ova");
        }
        if ("oxs".equals(word)) {
            return Arrays.asList("oxen");
        }
        if ("oxes".equals(word)) {
            return Arrays.asList("oxen");
        }
        if ("paralysises".equals(word)) {
            return Arrays.asList("paralyses");
        }
        if ("potatos".equals(word)) {
            return Arrays.asList("potatoes");
        }
        if ("radiuses".equals(word)) {
            return Arrays.asList("radii");
        }
        if ("selfs".equals(word)) {
            return Arrays.asList("selves");
        }
        if ("serieses".equals(word)) {
            return Arrays.asList("series");
        }
        if ("sheeps".equals(word)) {
            return Arrays.asList("sheep");
        }
        if ("shelfs".equals(word)) {
            return Arrays.asList("shelves");
        }
        if ("scissorses".equals(word)) {
            return Arrays.asList("scissors");
        }
        if ("specieses".equals(word)) {
            return Arrays.asList("species");
        }
        if ("stimuluses".equals(word)) {
            return Arrays.asList("stimuli");
        }
        if ("stratums".equals(word)) {
            return Arrays.asList("strata");
        }
        if ("tableaus".equals(word)) {
            return Arrays.asList("tableaux");
        }
        if ("thats".equals(word)) {
            return Arrays.asList("those");
        }
        if ("thesises".equals(word)) {
            return Arrays.asList("theses");
        }
        if ("thiefs".equals(word)) {
            return Arrays.asList("thieves");
        }
        if ("thises".equals(word)) {
            return Arrays.asList("these");
        }
        if ("tomatos".equals(word)) {
            return Arrays.asList("tomatoes");
        }
        if ("tooths".equals(word)) {
            return Arrays.asList("teeth");
        }
        if ("torpedos".equals(word)) {
            return Arrays.asList("torpedoes");
        }
        if ("vertebras".equals(word)) {
            return Arrays.asList("vertebrae");
        }
        if ("vetos".equals(word)) {
            return Arrays.asList("vetoes");
        }
        if ("vitas".equals(word)) {
            return Arrays.asList("vitae");
        }
        if ("watchs".equals(word)) {
            return Arrays.asList("watches");
        }
        if ("wifes".equals(word)) {
            return Arrays.asList("wives");
        }
        if ("womans".equals(word)) {
            return Arrays.asList("women");
        }
        if ("tippy-top".equals(word) || "tippytop".equals(word)) {
            return Arrays.asList("tip-top", "top most");
        }
        if ("imma".equals(word)) {
            return Arrays.asList("I'm going to", "I'm a");
        }
        if ("Imma".equals(word)) {
            return Arrays.asList("I'm going to", "I'm a");
        }
        if ("dontcha".equals(word)) {
            return Arrays.asList("don't you");
        }
        if ("tobe".equals(word)) {
            return Arrays.asList("to be");
        }
        if ("Gi".equals(word) || "Ji".equals(word)) {
            return Arrays.asList("Hi");
        }
        if ("Dontcha".equals(word)) {
            return Arrays.asList("don't you");
        }
        if ("greatfruit".equals(word)) {
            return Arrays.asList("grapefruit", "great fruit");
        }
        if (word.endsWith("ys") && !this.speller1.isMisspelled(suggestion = word.replaceFirst("ys$", "ies"))) {
            return Arrays.asList(suggestion);
        }
        return super.getAdditionalTopSuggestions(suggestions, word);
    }

    protected Translator getTranslator(GlobalConfig globalConfig) {
        return this.translator;
    }

    private static class IrregularForms {
        final String baseform;
        final String posName;
        final String formName;
        final List<String> forms;

        private IrregularForms(String baseform, String posName, String formName, List<String> forms) {
            this.baseform = baseform;
            this.posName = posName;
            this.formName = formName;
            this.forms = forms;
        }
    }
}

