/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Experimental;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.en.AbstractEnglishSpellerRule;
import org.languagetool.rules.en.VariantInfo;

public final class MorfologikAmericanSpellerRule
extends AbstractEnglishSpellerRule {
    public static final String RULE_ID = "MORFOLOGIK_RULE_EN_US";
    private static final String RESOURCE_FILENAME = "/en/hunspell/en_US.dict";
    private static final String LANGUAGE_SPECIFIC_PLAIN_TEXT_DICT = "en/hunspell/spelling_en-US.txt";
    private static final Map<String, String> BRITISH_ENGLISH = MorfologikAmericanSpellerRule.loadWordlist("en/en-US-GB.txt", 1);

    public MorfologikAmericanSpellerRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language, null, Collections.emptyList());
    }

    @Override
    protected VariantInfo isValidInOtherVariant(String word) {
        String otherVariant = BRITISH_ENGLISH.get(word);
        if (otherVariant != null) {
            return new VariantInfo("British English", otherVariant);
        }
        return null;
    }

    public MorfologikAmericanSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
    }

    @Experimental
    public MorfologikAmericanSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel) throws IOException {
        super(messages, language, userConfig, altLanguages, languageModel);
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return RULE_ID;
    }

    public String getLanguageVariantSpellingFileName() {
        return LANGUAGE_SPECIFIC_PLAIN_TEXT_DICT;
    }

    @Override
    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        if ("automize".equals(word)) {
            return Arrays.asList("automate");
        }
        if ("automized".equals(word)) {
            return Arrays.asList("automated");
        }
        if ("automizing".equals(word)) {
            return Arrays.asList("automating");
        }
        if ("automizes".equals(word)) {
            return Arrays.asList("automates");
        }
        return super.getAdditionalTopSuggestions(suggestions, word);
    }
}

