/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.Example;
import org.languagetool.rules.ngrams.ConfusionProbabilityRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.FalseFriendRuleLoader;
import org.languagetool.rules.patterns.PatternToken;

public class EnglishForGermansFalseFriendRule
extends ConfusionProbabilityRule {
    private static List<AbstractPatternRule> rules;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnglishForGermansFalseFriendRule(ResourceBundle messages, LanguageModel languageModel, Language motherTongue, Language language) {
        super(messages, languageModel, language, 3);
        EnglishForGermansFalseFriendRule englishForGermansFalseFriendRule = this;
        synchronized (englishForGermansFalseFriendRule) {
            if (rules == null) {
                FalseFriendRuleLoader loader = new FalseFriendRuleLoader("\"{0}\" ({1}) means {2} ({3}).", "Did you maybe mean {0}?");
                String ffFilename = JLanguageTool.getDataBroker().getRulesDir() + "/" + "false-friends.xml";
                try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(ffFilename);){
                    rules = loader.getRules(is, language, motherTongue);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.addExamplePair(Example.wrong((String)"My <marker>handy</marker> is broken."), Example.fixed((String)"My <marker>phone</marker> is broken."));
    }

    public String getId() {
        return "EN_FOR_DE_SPEAKERS_FALSE_FRIENDS";
    }

    @NotNull
    protected List<String> getFilenames() {
        return Collections.singletonList("confusion_sets_l2_de.txt");
    }

    protected String getMessage(ConfusionString textString, ConfusionString suggestion) {
        for (AbstractPatternRule rule : rules) {
            List patternTokens = rule.getPatternTokens();
            for (PatternToken patternToken : patternTokens) {
                if (!textString.getString().equals(patternToken.getString())) continue;
                return rule.getMessage();
            }
        }
        return super.getMessage(textString, suggestion);
    }
}

