/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.English;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.en.VariantInfo;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.synthesis.en.EnglishSynthesizer;

public abstract class AbstractEnglishSpellerRule
extends MorfologikSpellerRule {
    private static final EnglishSynthesizer synthesizer = new EnglishSynthesizer(new English());

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null, Collections.emptyList());
    }

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        this(messages, language, userConfig, altLanguages, null);
    }

    protected static Map<String, String> loadWordlist(String path, int column) {
        if (column != 0 && column != 1) {
            throw new IllegalArgumentException("Only column 0 and 1 are supported: " + column);
        }
        HashMap<String, String> words = new HashMap<String, String>();
        try (InputStreamReader isr = new InputStreamReader(JLanguageTool.getDataBroker().getFromResourceDirAsStream(path), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new IOException("Unexpected format in " + path + ": " + line + " - expected two parts delimited by ';'");
                }
                words.put(parts[column], parts[column == 1 ? 0 : 1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return words;
    }

    @Experimental
    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel) throws IOException {
        super(messages, language, userConfig, altLanguages, languageModel);
        this.ignoreWordsWithLength = 1;
        this.setCheckCompound(true);
        this.addExamplePair(Example.wrong((String)"This <marker>sentenc</marker> contains a spelling mistake."), Example.fixed((String)"This <marker>sentence</marker> contains a spelling mistake."));
        String languageSpecificIgnoreFile = this.getSpellingFileName().replace(".txt", "_" + language.getShortCodeWithCountryAndVariant() + ".txt");
        for (String ignoreWord : this.wordListLoader.loadWords(languageSpecificIgnoreFile)) {
            this.addIgnoreWords(ignoreWord);
        }
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int idx, AnalyzedTokenReadings[] tokens) throws IOException {
        List ruleMatches = super.getRuleMatches(word, startPos, sentence, ruleMatchesSoFar, idx, tokens);
        if (ruleMatches.size() > 0) {
            IrregularForms forms = this.getIrregularFormsOrNull(word);
            if (forms != null) {
                String message = "Possible spelling mistake. Did you mean <suggestion>" + forms.forms.get(0) + "</suggestion>, the " + forms.formName + " form of the " + forms.posName + " '" + forms.baseform + "'?";
                this.addFormsToFirstMatch(message, sentence, ruleMatches, forms.forms);
            } else {
                VariantInfo variantInfo = this.isValidInOtherVariant(word);
                if (variantInfo != null) {
                    String message = "Possible spelling mistake. '" + word + "' is " + variantInfo.getVariantName() + ".";
                    this.replaceFormsOfFirstMatch(message, sentence, ruleMatches, variantInfo.otherVariant());
                }
            }
        }
        return ruleMatches;
    }

    @Nullable
    protected VariantInfo isValidInOtherVariant(String word) {
        return null;
    }

    private void addFormsToFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, List<String> forms) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch((Rule)this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        ArrayList<String> allSuggestions = new ArrayList<String>(forms);
        for (String repl : oldMatch.getSuggestedReplacements()) {
            if (allSuggestions.contains(repl)) continue;
            allSuggestions.add(repl);
        }
        newMatch.setSuggestedReplacements(allSuggestions);
        ruleMatches.set(0, newMatch);
    }

    private void replaceFormsOfFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, String suggestion) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch((Rule)this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        SuggestedReplacement sugg = new SuggestedReplacement(suggestion);
        sugg.setShortDescription(this.language.getName());
        newMatch.setSuggestedReplacementObjects(Collections.singletonList(sugg));
        ruleMatches.set(0, newMatch);
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word) {
        IrregularForms irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("ed"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("d"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "s", Arrays.asList("s"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "es", Arrays.asList("es"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "er", Arrays.asList("er"), "JJR", "adjective", "comparative");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "est", Arrays.asList("est"), "JJS", "adjective", "superlative");
        return irregularFormsOrNull;
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word, String wordSuffix, List<String> suffixes, String posTag, String posName, String formName) {
        try {
            for (String suffix : suffixes) {
                if (!word.endsWith(wordSuffix)) continue;
                String baseForm = word.substring(0, word.length() - suffix.length());
                String[] forms = synthesizer.synthesize(new AnalyzedToken(word, null, baseForm), posTag);
                ArrayList<String> result = new ArrayList<String>();
                for (String form : forms) {
                    if (this.speller1.isMisspelled(form)) continue;
                    result.add(form);
                }
                result.remove(word);
                result.remove("badder");
                result.remove("baddest");
                result.remove("spake");
                if (result.size() <= 0) continue;
                return new IrregularForms(baseForm, posName, formName, result);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        String suggestion;
        if ("Alot".equals(word)) {
            return Arrays.asList("A lot");
        }
        if ("alot".equals(word)) {
            return Arrays.asList("a lot");
        }
        if ("thru".equals(word)) {
            return Arrays.asList("through");
        }
        if ("speach".equals(word)) {
            return Arrays.asList("speech");
        }
        if ("icecreem".equals(word)) {
            return Arrays.asList("ice cream");
        }
        if ("fora".equals(word)) {
            return Arrays.asList("for a");
        }
        if ("te".equals(word)) {
            return Arrays.asList("the");
        }
        if ("todays".equals(word)) {
            return Arrays.asList("today's");
        }
        if ("Todays".equals(word)) {
            return Arrays.asList("Today's");
        }
        if ("todo".equals(word)) {
            return Arrays.asList("to-do", "to do");
        }
        if ("Todo".equals(word)) {
            return Arrays.asList("To-do", "To do");
        }
        if ("heres".equals(word)) {
            return Arrays.asList("here's");
        }
        if ("Heres".equals(word)) {
            return Arrays.asList("Here's");
        }
        if ("McDonalds".equals(word)) {
            return Arrays.asList("McDonald's");
        }
        if ("ecommerce".equals(word)) {
            return Arrays.asList("e-commerce");
        }
        if ("Ecommerce".equals(word)) {
            return Arrays.asList("E-Commerce");
        }
        if ("eCommerce".equals(word)) {
            return Arrays.asList("e-commerce");
        }
        if ("elearning".equals(word)) {
            return Arrays.asList("e-learning");
        }
        if ("eLearning".equals(word)) {
            return Arrays.asList("e-learning");
        }
        if ("ebook".equals(word)) {
            return Arrays.asList("e-book");
        }
        if ("eBook".equals(word)) {
            return Arrays.asList("e-book");
        }
        if ("Ebook".equals(word)) {
            return Arrays.asList("E-Book");
        }
        if ("ie".equals(word)) {
            return Arrays.asList("i.e.");
        }
        if ("eg".equals(word)) {
            return Arrays.asList("e.g.");
        }
        if ("Thx".equals(word)) {
            return Arrays.asList("Thanks");
        }
        if ("thx".equals(word)) {
            return Arrays.asList("thanks");
        }
        if ("Sry".equals(word)) {
            return Arrays.asList("Sorry");
        }
        if ("sry".equals(word)) {
            return Arrays.asList("sorry");
        }
        if ("Lil".equals(word)) {
            return Arrays.asList("Little");
        }
        if ("lil".equals(word)) {
            return Arrays.asList("little");
        }
        if ("Sucka".equals(word)) {
            return Arrays.asList("Sucker");
        }
        if ("sucka".equals(word)) {
            return Arrays.asList("sucker");
        }
        if ("center".equals(word)) {
            return Arrays.asList("centre");
        }
        if ("ur".equals(word)) {
            return Arrays.asList("your", "you are");
        }
        if ("Ur".equals(word)) {
            return Arrays.asList("Your", "You are");
        }
        if ("ure".equals(word)) {
            return Arrays.asList("your", "you are");
        }
        if ("Ure".equals(word)) {
            return Arrays.asList("Your", "You are");
        }
        if ("mins".equals(word)) {
            return Arrays.asList("minutes", "min");
        }
        if ("addon".equals(word)) {
            return Arrays.asList("add-on");
        }
        if ("addons".equals(word)) {
            return Arrays.asList("add-ons");
        }
        if ("afterparty".equals(word)) {
            return Arrays.asList("after-party");
        }
        if ("Afterparty".equals(word)) {
            return Arrays.asList("After-party");
        }
        if ("wellbeing".equals(word)) {
            return Arrays.asList("well-being");
        }
        if ("addendums".equals(word)) {
            return Arrays.asList("addenda");
        }
        if ("algas".equals(word)) {
            return Arrays.asList("algae");
        }
        if ("alumnas".equals(word)) {
            return Arrays.asList("alumnae");
        }
        if ("alumnuses".equals(word)) {
            return Arrays.asList("alumni");
        }
        if ("analysises".equals(word)) {
            return Arrays.asList("analyses");
        }
        if ("appendixs".equals(word)) {
            return Arrays.asList("appendices");
        }
        if ("axises".equals(word)) {
            return Arrays.asList("axes");
        }
        if ("bacilluses".equals(word)) {
            return Arrays.asList("bacilli");
        }
        if ("bacteriums".equals(word)) {
            return Arrays.asList("bacteria");
        }
        if ("basises".equals(word)) {
            return Arrays.asList("bases");
        }
        if ("beaus".equals(word)) {
            return Arrays.asList("beaux");
        }
        if ("bisons".equals(word)) {
            return Arrays.asList("bison");
        }
        if ("buffalos".equals(word)) {
            return Arrays.asList("buffaloes");
        }
        if ("calfs".equals(word)) {
            return Arrays.asList("calves");
        }
        if ("childs".equals(word)) {
            return Arrays.asList("children");
        }
        if ("crisises".equals(word)) {
            return Arrays.asList("crises");
        }
        if ("criterions".equals(word)) {
            return Arrays.asList("criteria");
        }
        if ("curriculums".equals(word)) {
            return Arrays.asList("curricula");
        }
        if ("datums".equals(word)) {
            return Arrays.asList("data");
        }
        if ("deers".equals(word)) {
            return Arrays.asList("deer");
        }
        if ("diagnosises".equals(word)) {
            return Arrays.asList("diagnoses");
        }
        if ("echos".equals(word)) {
            return Arrays.asList("echoes");
        }
        if ("elfs".equals(word)) {
            return Arrays.asList("elves");
        }
        if ("ellipsises".equals(word)) {
            return Arrays.asList("ellipses");
        }
        if ("embargos".equals(word)) {
            return Arrays.asList("embargoes");
        }
        if ("erratums".equals(word)) {
            return Arrays.asList("errata");
        }
        if ("firemans".equals(word)) {
            return Arrays.asList("firemen");
        }
        if ("fishs".equals(word)) {
            return Arrays.asList("fishes", "fish");
        }
        if ("genuses".equals(word)) {
            return Arrays.asList("genera");
        }
        if ("gooses".equals(word)) {
            return Arrays.asList("geese");
        }
        if ("halfs".equals(word)) {
            return Arrays.asList("halves");
        }
        if ("heros".equals(word)) {
            return Arrays.asList("heroes");
        }
        if ("indexs".equals(word)) {
            return Arrays.asList("indices", "indexes");
        }
        if ("lifes".equals(word)) {
            return Arrays.asList("lives");
        }
        if ("mans".equals(word)) {
            return Arrays.asList("men");
        }
        if ("matrixs".equals(word)) {
            return Arrays.asList("matrices");
        }
        if ("meanses".equals(word)) {
            return Arrays.asList("means");
        }
        if ("mediums".equals(word)) {
            return Arrays.asList("media");
        }
        if ("memorandums".equals(word)) {
            return Arrays.asList("memoranda");
        }
        if ("mooses".equals(word)) {
            return Arrays.asList("moose");
        }
        if ("mosquitos".equals(word)) {
            return Arrays.asList("mosquitoes");
        }
        if ("neurosises".equals(word)) {
            return Arrays.asList("neuroses");
        }
        if ("nucleuses".equals(word)) {
            return Arrays.asList("nuclei");
        }
        if ("oasises".equals(word)) {
            return Arrays.asList("oases");
        }
        if ("ovums".equals(word)) {
            return Arrays.asList("ova");
        }
        if ("oxs".equals(word)) {
            return Arrays.asList("oxen");
        }
        if ("oxes".equals(word)) {
            return Arrays.asList("oxen");
        }
        if ("paralysises".equals(word)) {
            return Arrays.asList("paralyses");
        }
        if ("potatos".equals(word)) {
            return Arrays.asList("potatoes");
        }
        if ("radiuses".equals(word)) {
            return Arrays.asList("radii");
        }
        if ("selfs".equals(word)) {
            return Arrays.asList("selves");
        }
        if ("serieses".equals(word)) {
            return Arrays.asList("series");
        }
        if ("sheeps".equals(word)) {
            return Arrays.asList("sheep");
        }
        if ("shelfs".equals(word)) {
            return Arrays.asList("shelves");
        }
        if ("scissorses".equals(word)) {
            return Arrays.asList("scissors");
        }
        if ("specieses".equals(word)) {
            return Arrays.asList("species");
        }
        if ("stimuluses".equals(word)) {
            return Arrays.asList("stimuli");
        }
        if ("stratums".equals(word)) {
            return Arrays.asList("strata");
        }
        if ("tableaus".equals(word)) {
            return Arrays.asList("tableaux");
        }
        if ("thats".equals(word)) {
            return Arrays.asList("those");
        }
        if ("thesises".equals(word)) {
            return Arrays.asList("theses");
        }
        if ("thiefs".equals(word)) {
            return Arrays.asList("thieves");
        }
        if ("thises".equals(word)) {
            return Arrays.asList("these");
        }
        if ("tomatos".equals(word)) {
            return Arrays.asList("tomatoes");
        }
        if ("tooths".equals(word)) {
            return Arrays.asList("teeth");
        }
        if ("torpedos".equals(word)) {
            return Arrays.asList("torpedoes");
        }
        if ("vertebras".equals(word)) {
            return Arrays.asList("vertebrae");
        }
        if ("vetos".equals(word)) {
            return Arrays.asList("vetoes");
        }
        if ("vitas".equals(word)) {
            return Arrays.asList("vitae");
        }
        if ("watchs".equals(word)) {
            return Arrays.asList("watches");
        }
        if ("wifes".equals(word)) {
            return Arrays.asList("wives");
        }
        if ("womans".equals(word)) {
            return Arrays.asList("women");
        }
        if ("tippy-top".equals(word) || "tippytop".equals(word)) {
            return Arrays.asList("tip-top", "top most");
        }
        if (word.endsWith("ys") && !this.speller1.isMisspelled(suggestion = word.replaceFirst("ys$", "ies"))) {
            return Arrays.asList(suggestion);
        }
        return super.getAdditionalTopSuggestions(suggestions, word);
    }

    private static class IrregularForms {
        final String baseform;
        final String posName;
        final String formName;
        final List<String> forms;

        private IrregularForms(String baseform, String posName, String formName, List<String> forms) {
            this.baseform = baseform;
            this.posName = posName;
            this.formName = formName;
            this.forms = forms;
        }
    }
}

