/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.English;
import org.languagetool.rules.Rule;
import org.languagetool.rules.en.BritishReplaceRule;
import org.languagetool.rules.en.MorfologikBritishSpellerRule;
import org.languagetool.rules.en.UnitConversionRuleImperial;

public class BritishEnglish
extends English {
    @Override
    public String[] getCountries() {
        return new String[]{"GB"};
    }

    @Override
    public String getName() {
        return "English (GB)";
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new BritishReplaceRule(messages));
        rules.add((Rule)new MorfologikBritishSpellerRule(messages, this, userConfig, altLanguages));
        rules.add((Rule)new UnitConversionRuleImperial(messages));
        return rules;
    }

    @Override
    public int getPriorityForId(String id) {
        switch (id) {
            case "OXFORD_SPELLING_ISATION_NOUNS": {
                return -20;
            }
            case "OXFORD_SPELLING_ISE_VERBS": {
                return -21;
            }
            case "OXFORD_SPELLING_IZE": {
                return -22;
            }
        }
        return super.getPriorityForId(id);
    }
}

