/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Category;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class ContractionSpellingRule
extends AbstractSimpleReplaceRule {
    public static final String CONTRACTION_SPELLING_RULE = "EN_CONTRACTION_SPELLING";
    private static final Map<String, List<String>> wrongWords = ContractionSpellingRule.load((String)"/en/contractions.txt");
    private static final Locale EN_LOCALE = new Locale("en");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public ContractionSpellingRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(new Category("Possible Typo"));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"We <marker>havent</marker> earned anything."), Example.fixed((String)"We <marker>haven't</marker> earned anything."));
    }

    public final String getId() {
        return CONTRACTION_SPELLING_RULE;
    }

    public String getDescription() {
        return "Spelling of English contractions";
    }

    public String getShort() {
        return "Spelling mistake";
    }

    public boolean isDictionaryBasedSpellingRule() {
        return false;
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Possible spelling mistake found";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public Locale getLocale() {
        return EN_LOCALE;
    }
}

