/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.List;
import java.util.ResourceBundle;
import java.util.Stack;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ConfusionProbabilityRule;
import org.languagetool.rules.Example;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tokenizers.en.EnglishWordTokenizer;

public class EnglishConfusionProbabilityRule
extends ConfusionProbabilityRule {
    private final EnglishWordTokenizer tokenizer = new EnglishWordTokenizer(){

        @Override
        public String getTokenizingCharacters() {
            return super.getTokenizingCharacters() + "-";
        }

        @Override
        public List<String> tokenize(String text) {
            List<String> tokens = super.tokenize(text);
            String prev = null;
            Stack<String> l = new Stack<String>();
            for (String token : tokens) {
                if ("'".equals(prev)) {
                    if (token.equals("m")) {
                        l.pop();
                        l.push("'m");
                    } else if (token.equals("re")) {
                        l.pop();
                        l.push("'re");
                    } else if (token.equals("ve")) {
                        l.pop();
                        l.push("'ve");
                    } else if (token.equals("ll")) {
                        l.pop();
                        l.push("'ll");
                    } else {
                        l.push(token);
                    }
                } else {
                    l.push(token);
                }
                prev = token;
            }
            return l;
        }
    };

    public EnglishConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public EnglishConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        super(messages, languageModel, language, grams);
        this.addExamplePair(Example.wrong((String)"I didn't <marker>now</marker> where it came from."), Example.fixed((String)"I didn't <marker>know</marker> where it came from."));
    }

    protected WordTokenizer getWordTokenizer() {
        return this.tokenizer;
    }
}

