/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.el;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class NumeralStressRule
extends Rule {
    private final Map<String, String> suffixMap = new HashMap<String, String>();
    private final Pattern numeral;
    private final Pattern stressedNumber;
    private final Pattern stressedSuffix;

    public NumeralStressRule(ResourceBundle messages) {
        super(messages);
        String[] unstressedSfx = new String[]{"\u03bf\u03c2", "\u03bf\u03c5", "\u03bf", "\u03bf\u03bd", "\u03bf\u03b9", "\u03c9\u03bd", "\u03bf\u03c5\u03c2", "\u03b7", "\u03b7\u03c2", "\u03b7\u03bd", "\u03b5\u03c2", "\u03b1"};
        String[] stressedSfx = new String[]{"\u03cc\u03c2", "\u03bf\u03cd", "\u03cc", "\u03cc\u03bd", "\u03bf\u03af", "\u03ce\u03bd", "\u03bf\u03cd\u03c2", "\u03ae", "\u03ae\u03c2", "\u03ae\u03bd", "\u03ad\u03c2", "\u03ac"};
        StringBuilder stressedSuffixRE = new StringBuilder();
        for (int i = 0; i < stressedSfx.length; ++i) {
            if (i > 0) {
                stressedSuffixRE.append('|');
            }
            stressedSuffixRE.append(stressedSfx[i]);
            this.suffixMap.put(stressedSfx[i], unstressedSfx[i]);
            this.suffixMap.put(unstressedSfx[i], stressedSfx[i]);
        }
        StringBuilder pattern = new StringBuilder("([1-9][0-9]*)(");
        pattern.append((CharSequence)stressedSuffixRE);
        for (String sfx : unstressedSfx) {
            pattern.append('|').append(sfx);
        }
        pattern.append(')');
        this.numeral = Pattern.compile(pattern.toString());
        this.stressedNumber = Pattern.compile("[0-9]*[0|2-9]0");
        this.stressedSuffix = Pattern.compile(stressedSuffixRE.toString());
        this.setCategory(new Category(new CategoryId("ORTHOGRAPHY"), "Orthography"));
        this.init();
    }

    private void init() {
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"\u039f <marker>20\u03bf\u03c2</marker> \u03b1\u03b9\u03ce\u03bd\u03b1\u03c2 \u03bc\u03b1\u03b6\u03af \u03bc\u03b5 \u03c4\u03bf\u03bd 21\u03bf \u03b1\u03b9\u03ce\u03bd\u03b1 \u03ba\u03b1\u03c4\u03b1\u03c4\u03ac\u03c3\u03c3\u03b5\u03c4\u03b1\u03b9 \u03b1\u03c0\u03cc \u03c4\u03bf\u03c5\u03c2 \u03b9\u03c3\u03c4\u03bf\u03c1\u03b9\u03ba\u03bf\u03cd\u03c2 \u03c3\u03c4\u03b7 \u03a3\u03cd\u03b3\u03c7\u03c1\u03bf\u03bd\u03b7 \u0399\u03c3\u03c4\u03bf\u03c1\u03af\u03b1."), Example.fixed((String)"\u039f <marker>20\u03cc\u03c2</marker> \u03b1\u03b9\u03ce\u03bd\u03b1\u03c2 \u03bc\u03b1\u03b6\u03af \u03bc\u03b5 \u03c4\u03bf\u03bd 21\u03bf \u03b1\u03b9\u03ce\u03bd\u03b1 \u03ba\u03b1\u03c4\u03b1\u03c4\u03ac\u03c3\u03c3\u03b5\u03c4\u03b1\u03b9 \u03b1\u03c0\u03cc \u03c4\u03bf\u03c5\u03c2 \u03b9\u03c3\u03c4\u03bf\u03c1\u03b9\u03ba\u03bf\u03cd\u03c2 \u03c3\u03c4\u03b7 \u03a3\u03cd\u03b3\u03c7\u03c1\u03bf\u03bd\u03b7 \u0399\u03c3\u03c4\u03bf\u03c1\u03af\u03b1."));
    }

    public String getId() {
        return "GREEK_ORTHOGRAPHY_NUMERAL_STRESS";
    }

    public String getDescription() {
        return "\u0388\u03bb\u03b5\u03b3\u03c7\u03bf\u03c2 \u03c4\u03bf\u03bd\u03b9\u03c3\u03bc\u03bf\u03cd \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ce\u03bd";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings token : tokens = sentence.getTokensWithoutWhitespace()) {
            boolean hasStress;
            Matcher m = this.numeral.matcher(token.getToken());
            if (!m.matches()) continue;
            String number = m.group(1);
            String suffix = m.group(2);
            boolean needsStress = this.stressedNumber.matcher(number).matches();
            if (needsStress == (hasStress = this.stressedSuffix.matcher(suffix).matches())) continue;
            suffix = this.suffixMap.get(suffix);
            String suggestion = number + suffix;
            String msg = "<suggestion>" + suggestion + "</suggestion>";
            RuleMatch match = new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), msg, "\u03a0\u03c1\u03cc\u03b2\u03bb\u03b7\u03bc\u03b1 \u03bf\u03c1\u03b8\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b1\u03c2");
            ruleMatches.add(match);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

