/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatBeginningRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.el.GreekUnpairedBracketsRule;
import org.languagetool.rules.el.MorfologikGreekSpellerRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.el.GreekSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.el.GreekTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.el.GreekWordTokenizer;

public class Greek
extends Language {
    private Disambiguator disambiguator;
    private SentenceTokenizer sentenceTokenizer;
    private Synthesizer synthesizer;
    private Tagger tagger;
    private String name = "Greek";

    public final String getShortName() {
        return "el";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final String[] getCountries() {
        return new String[]{"GR"};
    }

    public final Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Panagiotis Minos")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GreekUnpairedBracketsRule(messages, this), new LongSentenceRule(messages), new MorfologikGreekSpellerRule(messages, this), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new WordRepeatBeginningRule(messages, (Language)this), new WordRepeatRule(messages, (Language)this)});
    }

    public final Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new GreekTagger();
        }
        return this.tagger;
    }

    public final SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public final Tokenizer getWordTokenizer() {
        return new GreekWordTokenizer();
    }

    public final Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new GreekSynthesizer();
        }
        return this.synthesizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new XmlRuleDisambiguator((Language)new Greek());
        }
        return this.disambiguator;
    }
}

