/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.de;

import com.google.common.base.Suppliers;
import de.danielnaber.jwordsplitter.EmbeddedGermanDictionary;
import de.danielnaber.jwordsplitter.GermanWordSplitter;
import de.danielnaber.jwordsplitter.InputTooLongException;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.languagetool.tokenizers.Tokenizer;

public class GermanCompoundTokenizer
implements Tokenizer {
    private static final Supplier<GermanCompoundTokenizer> strictInstance = Suppliers.memoize(() -> {
        try {
            return new GermanCompoundTokenizer(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    private static final Supplier<GermanCompoundTokenizer> nonStrictInstance = Suppliers.memoize(() -> {
        try {
            return new GermanCompoundTokenizer(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    private final ExtendedGermanWordSplitter wordSplitter = new ExtendedGermanWordSplitter(false);

    public GermanCompoundTokenizer() throws IOException {
        this(true);
    }

    public GermanCompoundTokenizer(boolean strictMode) throws IOException {
        this.wordSplitter.setStrictMode(strictMode);
        this.wordSplitter.setMinimumWordLength(3);
        this.wordSplitter.addException("Absolventen", Arrays.asList("Absolventen"));
        this.wordSplitter.addException("Acetat", Arrays.asList("Acetat"));
        this.wordSplitter.addException("Alkoholabstinenz", Arrays.asList("Alkohol", "abstinenz"));
        this.wordSplitter.addException("Androgen", Arrays.asList("Androgen"));
        this.wordSplitter.addException("Auberginen", Arrays.asList("Auberginen"));
        this.wordSplitter.addException("Auckland", Arrays.asList("Auckland"));
        this.wordSplitter.addException("Boston", Arrays.asList("Boston"));
        this.wordSplitter.addException("Brandenburg", Arrays.asList("Brandenburg"));
        this.wordSplitter.addException("Broadcast", Arrays.asList("Broadcast"));
        this.wordSplitter.addException("Buchsbaum", Arrays.asList("Buchsbaum"));
        this.wordSplitter.addException("Chiemsee", Arrays.asList("Chiemsee"));
        this.wordSplitter.addException("Coffein", Arrays.asList("Coffein"));
        this.wordSplitter.addException("Drohnen", Arrays.asList("Drohnen"));
        this.wordSplitter.addException("Eiben", Arrays.asList("Eiben"));
        this.wordSplitter.addException("Eingroschen", Arrays.asList("Eingroschen"));
        this.wordSplitter.addException("Einkomponenten", Arrays.asList("Einkomponenten"));
        this.wordSplitter.addException("Elster", Arrays.asList("Elster"));
        this.wordSplitter.addException("Engineering", Arrays.asList("Engineering"));
        this.wordSplitter.addException("Factoring", Arrays.asList("Factoring"));
        this.wordSplitter.addException("Flexodruck", Arrays.asList("Flexo", "druck"));
        this.wordSplitter.addException("Graviton", Arrays.asList("Graviton"));
        this.wordSplitter.addException("G\u00f6ttinnen", Arrays.asList("G\u00f6ttinnen"));
        this.wordSplitter.addException("Hallesche", Arrays.asList("Hallesche"));
        this.wordSplitter.addException("Hinspiel", Arrays.asList("Hinspiel"));
        this.wordSplitter.addException("Homogen", Arrays.asList("Homogen"));
        this.wordSplitter.addException("Kolleggen", Arrays.asList("Kolleggen"));
        this.wordSplitter.addException("Karstadt", Arrays.asList("Karstadt"));
        this.wordSplitter.addException("Kartier", Arrays.asList("Kartier"));
        this.wordSplitter.addException("Kaukasus", Arrays.asList("Kaukasus"));
        this.wordSplitter.addException("Knoblauch", Arrays.asList("Knoblauch"));
        this.wordSplitter.addException("Kollagen", Arrays.asList("Kollagen"));
        this.wordSplitter.addException("Kommerz", Arrays.asList("Kommerz"));
        this.wordSplitter.addException("Mentoring", Arrays.asList("Mentoring"));
        this.wordSplitter.addException("Monarchen", Arrays.asList("Monarchen"));
        this.wordSplitter.addException("Oligarchen", Arrays.asList("Oligarchen"));
        this.wordSplitter.addException("Optimal", Arrays.asList("Optimal"));
        this.wordSplitter.addException("Saunieren", Arrays.asList("Saunieren"));
        this.wordSplitter.addException("Schiessen", Arrays.asList("Schiessen"));
        this.wordSplitter.addException("Spielgeleier", Arrays.asList("Spielgeleier"));
        this.wordSplitter.addException("Halleschen", Arrays.asList("Halleschen"));
        this.wordSplitter.addException("Reinigungstab", Arrays.asList("Reinigungs", "tab"));
        this.wordSplitter.addException("Reinigungstabs", Arrays.asList("Reinigungs", "tabs"));
        this.wordSplitter.addException("Tauschwerte", Arrays.asList("Tausch", "werte"));
        this.wordSplitter.addException("Tauschwertes", Arrays.asList("Tausch", "wertes"));
        this.wordSplitter.addException("Kinderspielen", Arrays.asList("Kinder", "spielen"));
        this.wordSplitter.addException("Buchhaltungstrick", Arrays.asList("Buchhaltungs", "trick"));
        this.wordSplitter.addException("Buchhaltungstricks", Arrays.asList("Buchhaltungs", "tricks"));
        this.wordSplitter.addException("Haushaltstrick", Arrays.asList("Haushalts", "trick"));
        this.wordSplitter.addException("Haushaltstricks", Arrays.asList("Haushalts", "tricks"));
        this.wordSplitter.addException("Verkaufstrick", Arrays.asList("Verkaufs", "trick"));
        this.wordSplitter.addException("Verkaufstricks", Arrays.asList("Verkaufs", "tricks"));
        this.wordSplitter.addException("Ablenkungstrick", Arrays.asList("Ablenkungs", "trick"));
        this.wordSplitter.addException("Ablenkungstricks", Arrays.asList("Ablenkungs", "tricks"));
        this.wordSplitter.addException("Manipulationstrick", Arrays.asList("Manipulations", "trick"));
        this.wordSplitter.addException("Manipulationstricks", Arrays.asList("Manipulations", "tricks"));
        this.wordSplitter.addException("Erziehungstrick", Arrays.asList("Erziehungs", "trick"));
        this.wordSplitter.addException("Erziehungstricks", Arrays.asList("Erziehungs", "tricks"));
        this.wordSplitter.addException("Messetage", Arrays.asList("Messe", "tage"));
        this.wordSplitter.addException("Messetagen", Arrays.asList("Messe", "tagen"));
        this.wordSplitter.addException("karamelligen", Arrays.asList("karamelligen"));
        this.wordSplitter.addException("H\u00e4kelnadel", Arrays.asList("H\u00e4kel", "nadel"));
        this.wordSplitter.addException("H\u00e4kelnadeln", Arrays.asList("H\u00e4kel", "nadeln"));
        this.wordSplitter.addException("Freiberg", Arrays.asList("Freiberg"));
        this.wordSplitter.addException("Abtestat", Arrays.asList("Abtestat"));
        this.wordSplitter.addException("Abtestaten", Arrays.asList("Abtestaten"));
        this.wordSplitter.addException("Freibergs", Arrays.asList("Freibergs"));
        this.wordSplitter.addException("Kreuzberg", Arrays.asList("Kreuzberg"));
        this.wordSplitter.addException("Kreuzbergs", Arrays.asList("Kreuzbergs"));
        this.wordSplitter.addException("Digitalisierung", Arrays.asList("Digitalisierung"));
        this.wordSplitter.addException("Abtrocknung", Arrays.asList("Abtrocknung"));
        this.wordSplitter.addException("Erl\u00f6sung", Arrays.asList("Erl\u00f6sung"));
        this.wordSplitter.addException("Feuerung", Arrays.asList("Feuerung"));
        this.wordSplitter.addException("Aktivierung", Arrays.asList("Aktivierung"));
        this.wordSplitter.addException("Protokollierung", Arrays.asList("Protokollierung"));
        this.wordSplitter.addException("Budgetierung", Arrays.asList("Budgetierung"));
        this.wordSplitter.addException("Faltung", Arrays.asList("Faltung"));
        this.wordSplitter.addException("Anh\u00e4ufung", Arrays.asList("Anh\u00e4ufung"));
        this.wordSplitter.addException("Aufkohlung", Arrays.asList("Aufkohlung"));
        this.wordSplitter.addException("Festigung", Arrays.asList("Festigung"));
        this.wordSplitter.addException("Allerheiligen", Arrays.asList("Allerheiligen"));
        this.wordSplitter.addException("Druckerpressen", Arrays.asList("Drucker", "pressen"));
        this.wordSplitter.addException("Habitat", Arrays.asList("Habitat"));
        this.wordSplitter.addException("Augarten", Arrays.asList("Augarten"));
        this.wordSplitter.addException("Auszeit", Arrays.asList("Auszeit"));
        this.wordSplitter.addException("Bewegtbild", Arrays.asList("Bewegt", "bild"));
        this.wordSplitter.addException("Bigband", Arrays.asList("Bigband"));
        this.wordSplitter.addException("Bisexuelle", Arrays.asList("Bisexuelle"));
        this.wordSplitter.addException("Bisexuellen", Arrays.asList("Bisexuellen"));
        this.wordSplitter.addException("Bunsenbrenner", Arrays.asList("Bunsenbrenner"));
        this.wordSplitter.addException("Carbon", Arrays.asList("Carbon"));
        this.wordSplitter.addException("Carsharing", Arrays.asList("Carsharing"));
        this.wordSplitter.addException("Castor", Arrays.asList("Castor"));
        this.wordSplitter.addException("Catering", Arrays.asList("Catering"));
        this.wordSplitter.addException("Cholesterin", Arrays.asList("Cholesterin"));
        this.wordSplitter.addException("Damast", Arrays.asList("Damast"));
        this.wordSplitter.addException("Dispositiv", Arrays.asList("Dispositiv"));
        this.wordSplitter.addException("Emittent", Arrays.asList("Emittent"));
        this.wordSplitter.addException("Emittenten", Arrays.asList("Emittenten"));
        this.wordSplitter.addException("Express", Arrays.asList("Express"));
        this.wordSplitter.addException("Fairness", Arrays.asList("Fairness"));
        this.wordSplitter.addException("Fiberglas", Arrays.asList("Fiberglas"));
        this.wordSplitter.addException("Globus", Arrays.asList("Globus"));
        this.wordSplitter.addException("G\u00f6ttinnen", Arrays.asList("G\u00f6ttinnen"));
        this.wordSplitter.addException("Illustration", Arrays.asList("Illustration"));
        this.wordSplitter.addException("Muttertag", Arrays.asList("Muttertag"));
        this.wordSplitter.addException("Muttertags", Arrays.asList("Muttertags"));
        this.wordSplitter.addException("Patriarchen", Arrays.asList("Patriarchen"));
        this.wordSplitter.addException("Phosgen", Arrays.asList("Phosgen"));
        this.wordSplitter.addException("Vatertag", Arrays.asList("Vatertag"));
        this.wordSplitter.addException("Vatertags", Arrays.asList("Vatertags"));
        this.wordSplitter.addException("Vaterland", Arrays.asList("Vaterland"));
        this.wordSplitter.addException("Vaterlands", Arrays.asList("Vaterlands"));
        this.wordSplitter.addException("Wehrmacht", Arrays.asList("Wehrmacht"));
        this.wordSplitter.addException("Wehrmachts", Arrays.asList("Wehrmachts"));
    }

    public List<String> tokenize(String word) {
        try {
            return this.wordSplitter.splitWord(word);
        }
        catch (InputTooLongException e) {
            return Collections.singletonList(word);
        }
    }

    public static GermanCompoundTokenizer getStrictInstance() {
        return strictInstance.get();
    }

    public static GermanCompoundTokenizer getNonStrictInstance() {
        return nonStrictInstance.get();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: " + GermanCompoundTokenizer.class.getSimpleName() + " <wordsToSplit... or file>");
            System.exit(1);
        }
        GermanCompoundTokenizer tokenizer = new GermanCompoundTokenizer();
        if (new File(args[0]).exists()) {
            System.out.println("Working on lines from " + args[0] + ":");
            List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
            for (String line : lines) {
                System.out.println(tokenizer.tokenize(line));
            }
        } else {
            for (String arg : args) {
                System.out.println(tokenizer.tokenize(arg));
            }
        }
    }

    static class ExtendedGermanWordSplitter
    extends GermanWordSplitter {
        ExtendedGermanWordSplitter(boolean hideInterfixCharacters) throws IOException {
            super(hideInterfixCharacters, ExtendedGermanWordSplitter.extendedList());
        }

        static Set<String> extendedList() {
            ObjectOpenHashSet words = new ObjectOpenHashSet((Collection)EmbeddedGermanDictionary.getWords());
            words.add((Object)"influencer");
            words.add((Object)"katheterisierung");
            words.add((Object)"r\u00fccklass");
            words.add((Object)"abdichtung");
            words.add((Object)"laptop");
            words.add((Object)"verschattung");
            words.add((Object)"paradeiser");
            words.add((Object)"einreichung");
            words.add((Object)"bestatter");
            words.add((Object)"divergenz");
            words.add((Object)"schrumpf");
            words.add((Object)"degustation");
            words.add((Object)"schaft");
            words.add((Object)"abstreifer");
            words.add((Object)"aufputz");
            words.add((Object)"gl\u00fchw\u00fcrmchen");
            words.add((Object)"aufwertung");
            words.add((Object)"einhausung");
            words.add((Object)"lackier");
            words.add((Object)"zarge");
            words.add((Object)"pluralisierung");
            words.add((Object)"schanzen");
            words.add((Object)"abscheide");
            words.add((Object)"rangier");
            words.add((Object)"temporal");
            words.add((Object)"kartonage");
            words.add((Object)"kartonagen");
            words.add((Object)"rebellion");
            words.add((Object)"binokular");
            words.add((Object)"umverlegung");
            words.add((Object)"umhausung");
            words.add((Object)"\u00fcberholung");
            words.add((Object)"chloroplasten");
            words.add((Object)"nachrangigkeit");
            words.add((Object)"spital");
            words.add((Object)"turnus");
            words.add((Object)"teilnehmenden");
            words.add((Object)"pensionisten");
            words.add((Object)"graduierten");
            words.add((Object)"beladung");
            words.add((Object)"controller");
            words.add((Object)"resilienz");
            words.add((Object)"mitf\u00fchr");
            words.add((Object)"trauma");
            words.add((Object)"abtau");
            words.add((Object)"normung");
            words.add((Object)"mikroskopie");
            words.add((Object)"bitumen");
            words.add((Object)"erfolglosigkeit");
            words.add((Object)"pneumatik");
            words.add((Object)"anlasser");
            words.add((Object)"allozierung");
            words.add((Object)"alphabetisierung");
            words.add((Object)"aktuator");
            words.add((Object)"akademisierung");
            words.add((Object)"allergiker");
            words.add((Object)"queer");
            words.add((Object)"filament");
            words.add((Object)"querung");
            words.add((Object)"curling");
            words.add((Object)"opioid");
            words.add((Object)"booster");
            words.add((Object)"schmuse");
            words.add((Object)"thrombozyten");
            words.add((Object)"dysfunktion");
            words.add((Object)"storchen");
            words.add((Object)"nasch");
            words.add((Object)"esperanto");
            words.add((Object)"passivierung");
            words.add((Object)"radikalisierung");
            words.add((Object)"erleuchtung");
            words.add((Object)"verwalter");
            words.add((Object)"verbiss");
            words.add((Object)"ausleih");
            words.add((Object)"rutsch");
            words.add((Object)"kufen");
            words.add((Object)"entferner");
            words.add((Object)"debitoren");
            words.add((Object)"terrakotta");
            words.add((Object)"graffiti");
            words.add((Object)"auffahr");
            words.add((Object)"anmutung");
            words.add((Object)"kritzel");
            words.add((Object)"salami");
            words.add((Object)"eukalyptus");
            words.add((Object)"kreativ");
            words.add((Object)"hochvolt");
            words.add((Object)"trading");
            words.add((Object)"extraktion");
            words.add((Object)"verstetigung");
            words.add((Object)"diagonal");
            words.add((Object)"margen");
            words.add((Object)"synonym");
            words.add((Object)"aufbringung");
            words.add((Object)"robustheit");
            words.add((Object)"nachuntersuchung");
            words.add((Object)"erstkommunion");
            words.add((Object)"hauptstadt");
            words.add((Object)"neustart");
            words.add((Object)"polarisierung");
            words.add((Object)"vollstreckbarkeit");
            words.add((Object)"vollziehung");
            words.add((Object)"kasko");
            words.add((Object)"blitzableiter");
            words.add((Object)"abschattungen");
            words.add((Object)"kuscheltier");
            words.add((Object)"gastro");
            words.add((Object)"hortensien");
            words.trim();
            return words;
        }
    }
}

