/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tools.StringTools;

public class PotentialCompoundFilter
extends RuleFilter {
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        String part1 = arguments.get("part1");
        String part2 = arguments.get("part2");
        String part1capitalized = part1;
        String part2capitalized = part2;
        String part2lowercase = part2;
        if (!StringTools.isMixedCase((String)part2) && !StringTools.isAllUppercase((String)part2)) {
            part2lowercase = part2.toLowerCase();
            part2capitalized = StringTools.uppercaseFirstChar((String)part2.toLowerCase());
        }
        if (!StringTools.isMixedCase((String)part1) && !StringTools.isAllUppercase((String)part1)) {
            part1capitalized = StringTools.uppercaseFirstChar((String)part1.toLowerCase());
        }
        String joinedWord = part1capitalized + part2lowercase;
        String hyphenatedWord = part1capitalized + "-" + part2capitalized;
        ArrayList<CallSite> replacements = new ArrayList<CallSite>();
        List<CallSite> tokens = Collections.singletonList(joinedWord);
        List tokensList = GermanyGerman.getInstance().getTagger().tag(tokens);
        AnalyzedTokenReadings[] tokensArray = new AnalyzedTokenReadings[2];
        AnalyzedToken sentenceStartToken = new AnalyzedToken("", "SENT_START", null);
        AnalyzedToken[] startTokenArray = new AnalyzedToken[]{sentenceStartToken};
        tokensArray[0] = new AnalyzedTokenReadings(startTokenArray, 0);
        tokensArray[1] = (AnalyzedTokenReadings)tokensList.get(0);
        AnalyzedSentence analyzedSentence = new AnalyzedSentence(tokensArray);
        RuleMatch[] matches = GermanyGerman.getInstance().getDefaultSpellingRule().match(analyzedSentence);
        if (matches.length == 0) {
            if (joinedWord.length() > 20) {
                replacements.add((CallSite)((Object)hyphenatedWord));
            }
            replacements.add((CallSite)((Object)joinedWord));
        } else {
            replacements.add((CallSite)((Object)hyphenatedWord));
        }
        if (!replacements.isEmpty()) {
            String message = match.getMessage();
            RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
            ruleMatch.setType(match.getType());
            ruleMatch.setSuggestedReplacements(replacements);
            return ruleMatch;
        }
        return null;
    }
}

