/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class GermanCompoundRule
extends AbstractCompoundRule {
    private static final List<DisambiguationPatternRule> ANTI_PATTERNS = GermanCompoundRule.makeAntiPatterns(Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"an|um"), PatternRuleBuilderHelper.token((String)"die"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+")), Arrays.asList(new PatternTokenBuilder().tokenRegex("von|vom").setSkip(5).build(), PatternRuleBuilderHelper.token((String)"aus"), PatternRuleBuilderHelper.token((String)"gedacht")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"rund|etwa|zirka|cirka|ungef\u00e4hr|ann\u00e4hernd|grob|wohl|gegen|sch\u00e4tzungsweise"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ca"), PatternRuleBuilderHelper.token((String)"."), PatternRuleBuilderHelper.tokenRegex((String)"\\d+")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Kung"), PatternRuleBuilderHelper.token((String)"Fu"), PatternRuleBuilderHelper.tokenRegex((String)"Panda|Fighting")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Harlem"), PatternRuleBuilderHelper.token((String)"Gospel"), PatternRuleBuilderHelper.token((String)"Singers")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Always"), PatternRuleBuilderHelper.token((String)"on"), PatternRuleBuilderHelper.tokenRegex((String)"my|your|the|an?|their")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"sich|uns|ihm|ihr|mir|euch"), PatternRuleBuilderHelper.token((String)"selbst"), PatternRuleBuilderHelper.tokenRegex((String)"gerecht.*"))), (Language)GermanyGerman.getInstance());
    private static volatile CompoundRuleData compoundData;

    public GermanCompoundRule(ResourceBundle messages, Language lang, UserConfig userConfig) throws IOException {
        super(messages, lang, userConfig, "Dieses Wort wird mit Bindestrich geschrieben.", "Dieses Wort wird zusammengeschrieben.", "Diese W\u00f6rter werden zusammengeschrieben oder mit Bindestrich getrennt.", "Zusammenschreibung von W\u00f6rtern");
        super.setCategory(Categories.COMPOUNDING.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Wenn es schlimmer wird, solltest Du zum <marker>HNO Arzt</marker> gehen."), Example.fixed((String)"Wenn es schlimmer wird, solltest Du zum <marker>HNO-Arzt</marker> gehen."));
    }

    public String getId() {
        return "DE_COMPOUNDS";
    }

    public String getDescription() {
        return "Zusammenschreibung von W\u00f6rtern, z. B. 'CD-ROM' statt 'CD ROM'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompoundRuleData getCompoundRuleData() {
        CompoundRuleData data = compoundData;
        if (data != null) return data;
        Class<GermanCompoundRule> clazz = GermanCompoundRule.class;
        synchronized (GermanCompoundRule.class) {
            data = compoundData;
            if (data != null) return data;
            compoundData = data = new CompoundRuleData(new String[]{"/de/compounds.txt", "/de/compound-cities.txt"});
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data;
        }
    }

    public boolean isMisspelled(String word) throws IOException {
        return GermanyGerman.getInstance().getDefaultSpellingRule().isMisspelled(word);
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return ANTI_PATTERNS;
    }
}

