/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestionFilter;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tools.StringTools;

public class AdaptSuggestionFilter
extends RuleFilter {
    private static final German german = new German();
    private static final Pattern ART_PRO_PATTERN = Pattern.compile("(ART|PRO):.*");
    private static final Pattern MAS_FEM_NEU_PATTERN = Pattern.compile("MAS|FEM|NEU");
    private static final Pattern PRO_POS_ETC_PATTERN = Pattern.compile("PRO:POS:(NOM|AKK|GEN|DAT):(SIN|PLU):(MAS|FEM|NEU)");
    private static final Pattern STV_BEG_PATTERN = Pattern.compile(":(STV|BEG).*");

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) {
        RuleMatch newMatch = null;
        List<CallSite> newSugg = new ArrayList();
        if (patternTokenPos > 0) {
            boolean detAdjNoun;
            AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
            AnalyzedTokenReadings prevToken = tokens[patternTokenPos - 1];
            boolean detNoun = prevToken.hasPosTagStartingWith("ART:") || prevToken.hasPosTagStartingWith("PRO:");
            boolean bl = detAdjNoun = patternTokenPos > 1 && (tokens[patternTokenPos - 2].hasPosTagStartingWith("ART:") || tokens[patternTokenPos - 2].hasPosTagStartingWith("PRO:")) && prevToken.hasPosTagStartingWith("ADJ:");
            if (detNoun) {
                newMatch = new RuleMatch(match.getRule(), match.getSentence(), prevToken.getStartPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
                for (String replacement : match.getSuggestedReplacements()) {
                    List<String> adaptedDets = this.getAdaptedDet(prevToken, replacement);
                    for (String adaptedDet : adaptedDets) {
                        String newRepl = adaptedDet + " " + replacement;
                        if (newSugg.contains(newRepl)) continue;
                        newSugg.add((CallSite)((Object)newRepl));
                    }
                }
                newMatch.setSuggestedReplacements(newSugg);
            } else if (detAdjNoun) {
                // empty if block
            }
        }
        AgreementRule agreementRule = new AgreementRule(JLanguageTool.getMessageBundle(), german);
        SuggestionFilter suggestionFilter = new SuggestionFilter((Rule)agreementRule, (Language)german);
        if (newSugg.size() > 0) {
            newSugg = StringTools.startsWithUppercase((String)((String)newSugg.get(0))) ? suggestionFilter.filter(newSugg, "{} ist das.") : suggestionFilter.filter(newSugg, "Das ist {}.");
            newMatch.setSuggestedReplacements(newSugg);
            return newMatch;
        }
        return match;
    }

    List<String> getAdaptedDet(AnalyzedTokenReadings detToken, String repl) {
        String oldDetBaseform = this.getBaseform(detToken, "(ART|PRO):.*");
        ArrayList<String> result = new ArrayList<String>();
        try {
            String replGender = this.getNounGender(repl);
            if (replGender == null || oldDetBaseform == null) {
                return result;
            }
            for (AnalyzedToken reading : detToken.getReadings()) {
                String[] replDet;
                if (reading.getPOSTag() == null || !reading.getPOSTag().startsWith("ART:") && !reading.getPOSTag().startsWith("PRO:")) continue;
                String newDetPos = MAS_FEM_NEU_PATTERN.matcher(reading.getPOSTag()).replaceAll(replGender).replace("BEG", "(BEG|B/S)").replace(":STV", "");
                for (String s : replDet = GermanSynthesizer.INSTANCE.synthesize(new AnalyzedToken(oldDetBaseform, null, oldDetBaseform), newDetPos, true)) {
                    if (StringTools.startsWithUppercase((String)detToken.getToken())) {
                        if (!s.toLowerCase().startsWith(detToken.getToken().substring(0, 1).toLowerCase())) continue;
                        result.add(StringTools.uppercaseFirstChar((String)s));
                        continue;
                    }
                    if (!s.startsWith(detToken.getToken().substring(0, 1))) continue;
                    result.add(s);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    List<String> getAdaptedDetAdj(AnalyzedTokenReadings detToken, AnalyzedTokenReadings adjToken, String repl) {
        String oldDetBaseform = this.getBaseform(detToken, "(ART|PRO):.*");
        String oldAdjBaseform = this.getBaseform(adjToken, "ADJ:.*");
        ArrayList<String> result = new ArrayList<String>();
        try {
            String replGender = this.getNounGender(repl);
            if (replGender == null || oldDetBaseform == null || oldAdjBaseform == null) {
                return result;
            }
            for (AnalyzedToken reading : detToken.getReadings()) {
                String newAdjPos;
                if (reading.getPOSTag() == null || !ART_PRO_PATTERN.matcher(reading.getPOSTag()).matches()) continue;
                String newDetPos = MAS_FEM_NEU_PATTERN.matcher(reading.getPOSTag()).replaceAll(replGender).replace("BEG", "(BEG|B/S)");
                if (newDetPos.startsWith("ART:")) {
                    newAdjPos = MAS_FEM_NEU_PATTERN.matcher(reading.getPOSTag()).replaceAll(replGender).replace("BEG", "(BEG|B/S)").replace(":STV", "");
                } else if (newDetPos.startsWith("PRO:")) {
                    newAdjPos = STV_BEG_PATTERN.matcher(PRO_POS_ETC_PATTERN.matcher(newDetPos).replaceAll("ADJ:$1:$2:$3")).replaceFirst(":GRU:IND");
                } else {
                    throw new RuntimeException("Unexpected POS tag: " + newDetPos);
                }
                String[] replDet = GermanSynthesizer.INSTANCE.synthesize(new AnalyzedToken(oldDetBaseform, null, oldDetBaseform), newDetPos, true);
                String[] replAdj = GermanSynthesizer.INSTANCE.synthesize(new AnalyzedToken(oldAdjBaseform, null, oldAdjBaseform), newAdjPos, true);
                for (String det : replDet) {
                    if (!det.startsWith(detToken.getToken().substring(0, 1))) continue;
                    for (String adj : replAdj) {
                        String newDetAdj = det + " " + adj;
                        if (result.contains(newDetAdj)) continue;
                        result.add(newDetAdj);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private String getBaseform(AnalyzedTokenReadings token, String tagStartsWith) {
        String baseform = null;
        for (AnalyzedToken reading : token.getReadings()) {
            if (reading.getPOSTag() == null || !reading.getPOSTag().matches(tagStartsWith)) continue;
            baseform = reading.getLemma();
        }
        return baseform;
    }

    @Nullable
    private String getNounGender(String word) throws IOException {
        List<AnalyzedTokenReadings> readings = GermanTagger.INSTANCE.tag(Collections.singletonList(word));
        for (AnalyzedTokenReadings atr : readings) {
            String[] parts;
            String pos;
            if (atr.getReadings().size() <= 0 || (pos = ((AnalyzedToken)atr.getReadings().get(0)).getPOSTag()) == null || !pos.startsWith("SUB:") || (parts = pos.split(":")).length < 4) continue;
            return parts[3];
        }
        return null;
    }
}

