/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.BaseLanguageModel;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ConfusionPair;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SpecificIdRule;
import org.languagetool.tools.StringTools;

public class ProhibitedCompoundRule
extends Rule {
    public static final String RULE_ID = "DE_PROHIBITED_COMPOUNDS";
    private static final List<Pair> lowercasePairs = Arrays.asList(new Pair("knoten", "Verschlingung von F\u00e4den", "konten", "Plural von 'Konto'"), new Pair("schaf", "Tier", "schaft", "'-schaft' (Element zur Wortbildung, z. B. 'Freundschaft')"), new Pair("schafen", "Dativ Plural von 'Schaf'", "schaften", "'-schaften' (Element zur Wortbildung, z. B. 'Freundschaften')"), new Pair("alpen", "Hochgebirge in Mittel- und S\u00fcdeuropa", "alben", "Plural von 'Album'"), new Pair("pillen", "Tabletten", "pullen", "Plural von 'Pulle' (Flasche)"), new Pair("tauben", "Vogelart", "trauben", "Obstsorte"), new Pair("panel", "ausgew\u00e4hlte Personengruppe", "paneel", "Platte f\u00fcr Wand- und Deckenverkleidungen"), new Pair("nabe", "Mittelteil eines Rades", "narbe", "verheilende Wunde"), new Pair("first", "h\u00f6chste Kante an einem geneigten Dach", "frist", "sp\u00e4tester Zeitpunkt"), new Pair("koma", "Zustand tiefer Bewusstlosigkeit", "komma", "Satzzeichen"), new Pair("korn", "Getreide sowie dessen Frucht", "kron", "Vorsilbe z.B. in 'Kronkorken'"), new Pair("bauten", "Form von 'Bau' (Bauwerk, Haus, ...)", "beuten", "Form von 'Beute'"), new Pair("file", "engl. 'Datei'", "filet", "ein St\u00fcck Fleisch oder Fisch"), new Pair("zecke", "blutsaugender Parasit", "zwecke", "Dativ von 'Zweck' (Ziel)"), new Pair("frucht", "Teil einer Pflanze; Obst", "furcht", "Angst"), new Pair("rate", "Verh\u00e4ltnis zwischen zwei Gr\u00f6\u00dfen", "ratte", "Nagetier"), new Pair("posten", "Arbeitsplatz, Wachposten", "posen", "Pose: betonte K\u00f6rperhaltung"), new Pair("himmel", "Bereich \u00fcber der Erde", "hummel", "Insekt"), new Pair("server", "Computer", "servier", "zu 'servieren'"), new Pair("ziege", "Tier", "ziegel", "Ziegelstein"), new Pair("robe", "Kleidungsst\u00fcck", "probe", "Test, Kontrolle"), new Pair("mode", "Kleidung", "monde", "Begleiter eines Planeten"), new Pair("eigen", "'selbst', z.B. 'Eigenzitat'", "eingen", "M\u00f6glicher Tippfehler"), new Pair("st\u00fcmpfe", "Rest eines K\u00f6rpergliedes", "str\u00fcmpfe", "Bekleidungsst\u00fcck f\u00fcr den Fu\u00df"), new Pair("gel\u00e4nde", "Gebiet", "gel\u00e4nder", "Konstruktion zum Festhalten entlang von Treppen"), new Pair("tropen", "feuchtwarme Gebiete am \u00c4quator", "tropfen", "kleine Menge Fl\u00fcssigkeit"), new Pair("enge", "Mangel an Platz", "menge", "Anzahl an Einheiten"), new Pair("ritt", "Reiten", "tritt", "Aufsetzen eines Fu\u00dfes"), new Pair("beine", "K\u00f6rperteil", "biene", "Insekt"), new Pair("rebe", "Weinrebe", "reibe", "K\u00fcchenreibe"), new Pair("ass", "Spielkarte", "pass", "Reisepass; \u00dcbergang durch ein Gebirge"), new Pair("t\u00fcrmer", "Turmw\u00e4chter", "t\u00fcrme", "Plural von 'Turm' (Bauwerk)"), new Pair("soge", "ziehende Str\u00f6mungen", "sorge", "bedr\u00fcckendes Gef\u00fchl"), new Pair("panne", "technischer Defekt", "spanne", "Zeitraum"), new Pair("elfer", "Elfmeter", "helfer", "Person, die hilft"), new Pair("gase", "Plural von 'Gas' (Aggregatzustand)", "gasse", "kleine Stra\u00dfe"), new Pair("ekel", "Abscheu", "enkel", "Kind eines eigenen Kindes"), new Pair("reis", "Nahrungsmittel", "reise", "Ausflug/Fahrt"), new Pair("h\u00fcte", "Kopfbedeckungen", "h\u00e4ute", "Plural von 'Haut'"), new Pair("werbereich", null, "erbereich", null), new Pair("lage", "Position", "alge", "im Wasser lebende Organismen"), new Pair("sph\u00e4re", "Kugel", "sp\u00e4hreh", null), new Pair("schenke", "Gastwirtschaft (auch: Sch\u00e4nke)", "schenkel", "Ober- und Unterschenkel"), new Pair("mai", "Monat nach April", "mail", "E-Mail"), new Pair("pump", "'auf Pump': umgangssprachlich f\u00fcr 'auf Kredit'", "pumpe", "Ger\u00e4t zur Bef\u00f6rderung von Fl\u00fcssigkeiten"), new Pair("mitte", "zentral", "mittel", "Methode, um etwas zu erreichen"), new Pair("fein", "feink\u00f6rnig, genau, gut", "feind", "Gegner"), new Pair("traum", "Erleben w\u00e4hrend des Schlafes", "trauma", "Verletzung"), new Pair("name", "Bezeichnung (z.B. 'Vorname')", "nahme", "zu 'nehmen' (z.B. 'Teilnahme')"), new Pair("bart", "Haarbewuchs im Gesicht", "dart", "Wurfpfeil"), new Pair("hart", "fest", "dart", "Wurfpfeil"), new Pair("speiche", "Verbindung zwischen Nabe und Felge beim Rad", "speicher", "Lagerraum"), new Pair("kart", "Gokart (Fahrzeug)", "karte", "Fahrkarte, Postkarte, Landkarte, ..."), new Pair("karts", "Kart = Gokart (Fahrzeug)", "karte", "Fahrkarte, Postkarte, Landkarte, ..."), new Pair("kiefer", "kn\u00f6cherner Teil des Sch\u00e4dels", "kiefern", "Kieferngew\u00e4chse (Baum)"), new Pair("gel", "dickfl\u00fcssige Masse", "geld", "Zahlungsmittel"), new Pair("kamp", "Flurname f\u00fcr ein St\u00fcck Land", "kampf", "Auseinandersetzung"), new Pair("l\u00e4use", "Insekt", "l\u00e4ufe", "Bewegungsart"), new Pair("l\u00e4usen", "Insekt", "l\u00e4ufen", "Bewegungsart"), new Pair("ruck", "pl\u00f6tzliche Bewegung", "druck", "Belastung"), new Pair("br\u00fcste", "Plural von Brust", "b\u00fcrste", "Ger\u00e4t mit Borsten, z.B. zum Reinigen"), new Pair("attraktion", "Sehensw\u00fcrdigkeit", "akttaktion", "vermutlicher Tippfehler"), new Pair("turn", "zu 'turnen'", "turm", "hohes Bauwerk"), new Pair("mit", "Pr\u00e4position", "miet", "zu 'Miete' (\u00dcberlassung gegen Bezahlung)"), new Pair("bart", "Behaarung im Gesicht", "brat", "zu 'braten', z.B. 'Bratkartoffel'"), new Pair("uhr", "Instrument zur Zeitmessung", "ur", "urspr\u00fcnglich"), new Pair("abschluss", "Ende", "abschuss", "Vorgang des Abschie\u00dfens, z.B. mit einer Waffe"), new Pair("brache", "verlassenes Grundst\u00fcck", "branche", "Wirtschaftszweig"), new Pair("wieder", "erneut, wiederholt, nochmal (Wiederholung, Wiedervorlage, ...)", "wider", "gegen, entgegen (Widerwille, Widerstand, Widerspruch, ...)"), new Pair("leer", "ohne Inhalt", "lehr", "bezogen auf Ausbildung und Wissen"), new Pair("gewerbe", "wirtschaftliche T\u00e4tigkeit", "gewebe", "gewebter Stoff; Verbund \u00e4hnlicher Zellen"), new Pair("klima", "langfristige Wetterzust\u00e4nde", "lima", "Hauptstadt von Peru"), new Pair("modell", "vereinfachtes Abbild der Wirklichkeit", "model", "Fotomodell"), new Pair("h\u00e4ufigkeit", "Anzahl von Ereignissen", "h\u00e4utigkeit", "z.B. in Dunkelh\u00e4utigkeit"), new Pair("hin", "in Richtung", "hirn", "Gehirn, Denkapparat"), new Pair("verkl\u00e4rung", "Besch\u00f6nigung, Darstellung in einem besseren Licht", "erkl\u00e4rung", "Darstellung, Erl\u00e4uterung"), new Pair("punk", "Jugendkultur", "punkt", "Satzzeichen"), new Pair("haft", "Freiheitsentzug", "schaft", "-schaft (Element zur Wortbildung)"), new Pair("stande", "zu 'Stand'", "stange", "l\u00e4nglicher Gegenstand"));
    private static final Pattern HERRN_FRAU = Pattern.compile("Herrn?|Frau|Dr|Prof|Mag|Hr|Fr|Mr|Mrs|Ms|Fr\u00e4ulein");
    private static final List<String> ignoreWords = Arrays.asList("Die", "De");
    private static final List<String> blacklistRegex = Arrays.asList("Lande(basis|basen|region|gebiets?|gebieten?|regionen|betriebs?|betrieben?|offizieren?|bereichs?|bereichen?|einrichtung|einrichtungen|massen?|plans?|versuchs?|versuchen?)", "Model(vertrags?|vertr\u00e4gen?|erfahrung|erfahrungen|szene|welt)", "(Raum|Surf|Jazz|Herbst|Gymnastik|Normal)schuhen?", "preis", "reis\u00e4hnlich(e|e[nmrs])?", "neugestartet(e|e[nmrs])?", "reisender", "[a-z\u00f6\u00e4\u00fc\u00df]+sender", "gra(ph|f)ische?", "gra(ph|f)ische[rsnm]", "gra(ph|f)s?$", "gra(ph|f)en", "gra(ph|f)in", "gra(ph|f)ik", "gra(ph|f)ie", "Gra(ph|f)its?", ".+gra(ph|f)its?");
    private static LinguServices linguServices;
    private static final LoadingCache<String, Set<String>> cache;
    protected AhoCorasickDoubleArrayTrie<String> ahoCorasickDoubleArrayTrie;
    protected Map<String, List<Pair>> pairMap;
    private static final AhoCorasickDoubleArrayTrie<String> prohibitedCompoundRuleSearcher;
    private static final Map<String, List<Pair>> prohibitedCompoundRulePairMap;
    private final BaseLanguageModel lm;
    private final Language language;
    private Pair confusionPair = null;

    private static void addAllCaseVariants(List<Pair> candidatePairs, Pair lcPair) {
        candidatePairs.add(new Pair(lcPair.part1, lcPair.part1Desc, lcPair.part2, lcPair.part2Desc));
        String ucPart1 = StringTools.uppercaseFirstChar((String)lcPair.part1);
        String ucPart2 = StringTools.uppercaseFirstChar((String)lcPair.part2);
        if (!lcPair.part1.equals(ucPart1) || !lcPair.part2.equals(ucPart2)) {
            candidatePairs.add(new Pair(ucPart1, lcPair.part1Desc, ucPart2, lcPair.part2Desc));
        }
    }

    private static void addUpperCaseVariants(List<Pair> pairs) {
        for (Pair lcPair : lowercasePairs) {
            if (StringTools.startsWithUppercase((String)lcPair.part1)) {
                throw new IllegalArgumentException("Use all-lowercase word in " + ProhibitedCompoundRule.class + ": " + lcPair.part1);
            }
            if (StringTools.startsWithUppercase((String)lcPair.part2)) {
                throw new IllegalArgumentException("Use all-lowercase word in " + ProhibitedCompoundRule.class + ": " + lcPair.part2);
            }
            ProhibitedCompoundRule.addAllCaseVariants(pairs, lcPair);
        }
    }

    protected static void addItemsFromConfusionSets(List<Pair> pairs, String confusionSetsFile, boolean isUpperCase) {
        try {
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            try (InputStream confusionSetStream = dataBroker.getFromResourceDirAsStream(confusionSetsFile);){
                ConfusionSetLoader loader = new ConfusionSetLoader((Language)GermanyGerman.INSTANCE);
                Map confusionPairs = loader.loadConfusionPairs(confusionSetStream);
                for (Map.Entry entry : confusionPairs.entrySet()) {
                    for (ConfusionPair pair : (List)entry.getValue()) {
                        boolean allUpper = pair.getTerms().stream().allMatch(k -> StringTools.startsWithUppercase((String)k.getString()) && !ignoreWords.contains(k.getString()));
                        if (!allUpper && isUpperCase) continue;
                        List cSet = pair.getTerms();
                        if (cSet.size() != 2) {
                            throw new RuntimeException("Got confusion set with != 2 items: " + cSet);
                        }
                        Iterator it = cSet.iterator();
                        ConfusionString part1 = (ConfusionString)it.next();
                        ConfusionString part2 = (ConfusionString)it.next();
                        pairs.add(new Pair(part1.getString(), part1.getDescription(), part2.getString(), part2.getDescription()));
                        if (isUpperCase) {
                            pairs.add(new Pair(StringTools.lowercaseFirstChar((String)part1.getString()), part1.getDescription(), StringTools.lowercaseFirstChar((String)part2.getString()), part2.getDescription()));
                            continue;
                        }
                        pairs.add(new Pair(StringTools.uppercaseFirstChar((String)part1.getString()), part1.getDescription(), StringTools.uppercaseFirstChar((String)part2.getString()), part2.getDescription()));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static AhoCorasickDoubleArrayTrie<String> setupAhoCorasickSearch(List<Pair> pairs, Map<String, List<Pair>> pairMap) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Pair pair : pairs) {
            map.put(pair.part1, pair.part1);
            map.put(pair.part2, pair.part2);
            pairMap.putIfAbsent(pair.part1, new LinkedList());
            pairMap.putIfAbsent(pair.part2, new LinkedList());
            pairMap.get(pair.part1).add(pair);
            pairMap.get(pair.part2).add(pair);
        }
        AhoCorasickDoubleArrayTrie ahoCorasickDoubleArrayTrie = new AhoCorasickDoubleArrayTrie();
        ahoCorasickDoubleArrayTrie.build(map);
        return ahoCorasickDoubleArrayTrie;
    }

    public ProhibitedCompoundRule(ResourceBundle messages, LanguageModel lm, UserConfig userConfig, Language language) {
        super(messages);
        this.lm = (BaseLanguageModel)Objects.requireNonNull(lm);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.ahoCorasickDoubleArrayTrie = prohibitedCompoundRuleSearcher;
        this.pairMap = prohibitedCompoundRulePairMap;
        this.language = language;
        linguServices = userConfig != null ? userConfig.getLinguServices() : null;
        this.addExamplePair(Example.wrong((String)"Da steht eine <marker>Lehrzeile</marker> zu viel."), Example.fixed((String)"Da steht eine <marker>Leerzeile</marker> zu viel."));
    }

    public String getId() {
        return RULE_ID;
    }

    public String getDescription() {
        return "Markiert wahrscheinlich falsche Komposita wie 'Lehrzeile', wenn 'Leerzeile' h\u00e4ufiger vorkommt.";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings prevReadings = null;
        for (AnalyzedTokenReadings readings : sentence.getTokensWithoutWhitespace()) {
            String tmpWord = readings.getToken();
            if (prevReadings != null && prevReadings.hasAnyPartialPosTag(new String[]{"EIG:"}) && StringTools.startsWithUppercase((String)tmpWord) && (readings.hasAnyPartialPosTag(new String[]{"EIG:"}) || readings.isPosTagUnknown()) || prevReadings != null && HERRN_FRAU.matcher(prevReadings.getToken()).matches()) continue;
            ArrayList<String> wordsParts = new ArrayList<String>(Arrays.asList(tmpWord.split("-")));
            int partsStartPos = 0;
            for (String wordPart : wordsParts) {
                partsStartPos = this.getMatches(sentence, ruleMatches, readings, partsStartPos, wordPart, 0);
            }
            String noHyphens = this.removeHyphensAndAdaptCase(tmpWord);
            if (noHyphens != null) {
                this.getMatches(sentence, ruleMatches, readings, 0, noHyphens, tmpWord.length() - noHyphens.length());
            }
            prevReadings = readings;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static boolean isMisspelled(String word) {
        if (linguServices == null) {
            return GermanyGerman.INSTANCE.getDefaultSpellingRule().isMisspelled(word);
        }
        return !linguServices.isCorrectSpell(word, (Language)GermanyGerman.INSTANCE);
    }

    private int getMatches(AnalyzedSentence sentence, List<RuleMatch> ruleMatches, AnalyzedTokenReadings readings, int partsStartPos, String wordPart, int toPosCorrection) {
        if (readings.isTagged() && !readings.hasPartialPosTag("SUB") && !readings.hasPosTagStartingWith("EIG:") || wordPart.length() <= 6) {
            return partsStartPos += wordPart.length() + 1;
        }
        ArrayList<Pair> candidatePairs = new ArrayList<Pair>();
        if (this.confusionPair == null) {
            List wordList = this.ahoCorasickDoubleArrayTrie.parseText((CharSequence)wordPart);
            for (AhoCorasickDoubleArrayTrie.Hit hit : wordList) {
                List<Pair> pair = this.pairMap.get(hit.value);
                if (pair == null) continue;
                candidatePairs.addAll(pair);
            }
        } else {
            ProhibitedCompoundRule.addAllCaseVariants(candidatePairs, this.confusionPair);
        }
        ArrayList<WeightedRuleMatch> weightedMatches = new ArrayList<WeightedRuleMatch>();
        for (Pair pair : candidatePairs) {
            String variant = null;
            if (wordPart.contains(pair.part1)) {
                variant = wordPart.replaceFirst(pair.part1, pair.part2);
            } else if (wordPart.contains(pair.part2)) {
                variant = wordPart.replaceFirst(pair.part2, pair.part1);
            }
            if (variant == null) {
                partsStartPos += wordPart.length() + 1;
                continue;
            }
            long wordCount = this.lm.getCount(wordPart);
            long variantCount = this.lm.getCount(variant);
            Set blacklist = (Set)cache.getUnchecked((Object)"/de/compound_exceptions.txt");
            if (variantCount <= (long)this.getThreshold() || wordCount != 0L || blacklist.contains(wordPart) || ProhibitedCompoundRule.isMisspelled(variant) || !blacklistRegex.stream().noneMatch(k -> wordPart.matches(".*" + k + ".*"))) continue;
            String msg = pair.part1Desc != null && pair.part2Desc != null ? "M\u00f6glicher Tippfehler. " + StringTools.uppercaseFirstChar((String)pair.part1) + ": " + pair.part1Desc + ", " + StringTools.uppercaseFirstChar((String)pair.part2) + ": " + pair.part2Desc : "M\u00f6glicher Tippfehler: " + pair.part1 + "/" + pair.part2;
            int fromPos = readings.getStartPos() + partsStartPos;
            int toPos = fromPos + wordPart.length() + toPosCorrection;
            String id = StringTools.toId((String)(this.getId() + "_" + pair.part1 + "_" + pair.part2), (Language)this.language);
            String desc = "Markiert wahrscheinlich falsche Komposita mit Teilwort '" + StringTools.uppercaseFirstChar((String)pair.part1) + "' statt '" + StringTools.uppercaseFirstChar((String)pair.part2) + "' und umgekehrt";
            SpecificIdRule idRule = new SpecificIdRule(id, desc, this.isPremium(), this.getCategory(), this.getLocQualityIssueType(), this.getTags());
            RuleMatch match = new RuleMatch((Rule)idRule, sentence, fromPos, toPos, msg);
            match.setSuggestedReplacement(variant);
            weightedMatches.add(new WeightedRuleMatch(variantCount, match));
        }
        if (weightedMatches.size() > 0) {
            Collections.sort(weightedMatches);
            ruleMatches.add(((WeightedRuleMatch)weightedMatches.get((int)0)).match);
        }
        return partsStartPos += wordPart.length() + 1;
    }

    int getThreshold() {
        return 0;
    }

    public void setConfusionPair(Pair confusionPair) {
        this.confusionPair = confusionPair;
    }

    @Nullable
    String removeHyphensAndAdaptCase(String word) {
        String[] parts = word.split("-");
        if (parts.length > 1) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (String part : parts) {
                if (part.length() <= 1) {
                    return null;
                }
                sb.append(i == 0 ? part : StringTools.lowercaseFirstChar((String)part));
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    static {
        cache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Set<String>>(){

            @NotNull
            public Set<String> load(@NotNull String path) {
                HashSet<String> words = new HashSet<String>();
                List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
                for (String line : lines) {
                    if (line.startsWith("#")) continue;
                    words.add(line.replaceFirst("#.*", "").trim());
                }
                return words;
            }
        });
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        HashMap<String, List<Pair>> pairMap = new HashMap<String, List<Pair>>();
        ProhibitedCompoundRule.addUpperCaseVariants(pairs);
        ProhibitedCompoundRule.addItemsFromConfusionSets(pairs, "/de/confusion_sets.txt", true);
        prohibitedCompoundRuleSearcher = ProhibitedCompoundRule.setupAhoCorasickSearch(pairs, pairMap);
        prohibitedCompoundRulePairMap = pairMap;
    }

    public static class Pair {
        private final String part1;
        private final String part1Desc;
        private final String part2;
        private final String part2Desc;

        public Pair(String part1, String part1Desc, String part2, String part2Desc) {
            this.part1 = part1;
            this.part1Desc = part1Desc;
            this.part2 = part2;
            this.part2Desc = part2Desc;
        }

        public String toString() {
            return this.part1 + "/" + this.part2;
        }
    }

    static class WeightedRuleMatch
    implements Comparable<WeightedRuleMatch> {
        long weight;
        RuleMatch match;

        WeightedRuleMatch(long weight, RuleMatch match) {
            this.weight = weight;
            this.match = match;
        }

        @Override
        public int compareTo(@NotNull WeightedRuleMatch other) {
            return Long.compare(other.weight, this.weight);
        }
    }
}

