/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import com.google.common.base.Suppliers;
import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.SpellingData;

public class OldSpellingRule
extends Rule {
    private static final String FILE_PATH = "/de/alt_neu.csv";
    private static final List<String> EXCEPTIONS = Arrays.asList("Schlo\u00df Holte", "Schlo\u00df Neuhaus", "Schlo\u00df Ricklingen", "Schlo\u00df-Nauses", "Schlo\u00df R\u00f6tteln", "Klinikum Schlo\u00df Winnenden", "Grazer Schlo\u00dfberg", "H\u00f6chster Schlo\u00df", "Bell Telephone", "Telephone Company", "American Telephone", "England Telephone", "Mobile Telephone", "Cordless Telephone", "Telephone Line", "World Telephone", "Tip Top", "Hans Joachim Bla\u00df", "kurz fassen");
    private static final Supplier<SpellingData> DATA = Suppliers.memoize(() -> new SpellingData(FILE_PATH));
    private static final Pattern CHARS = Pattern.compile("[a-zA-Z\u00f6\u00e4\u00fc\u00df]");
    private final Language language;

    public OldSpellingRule(ResourceBundle messages, Language language) {
        this.language = language;
        this.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"Der <marker>Abflu\u00df</marker> ist schon wieder verstopft."), Example.fixed((String)"Der <marker>Abfluss</marker> ist schon wieder verstopft."));
    }

    public String getId() {
        return "OLD_SPELLING_RULE";
    }

    public String getDescription() {
        return "Findet Schreibweisen, die nur in der alten Rechtschreibung g\u00fcltig waren";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text = sentence.getText();
        List hits = DATA.get().getTrie().parseText((CharSequence)text);
        List sentStartHits = DATA.get().getSentenceStartTrie().parseText((CharSequence)text);
        HashSet<Integer> startPositions = new HashSet<Integer>();
        Collections.reverse(hits);
        for (AhoCorasickDoubleArrayTrie.Hit hit : hits) {
            if (startPositions.contains(hit.begin) || this.ignoreMatch((AhoCorasickDoubleArrayTrie.Hit<String>)hit, text)) continue;
            this.addMatch(sentence, (AhoCorasickDoubleArrayTrie.Hit<String>)hit, matches);
            startPositions.add(hit.begin);
        }
        for (AhoCorasickDoubleArrayTrie.Hit hit : sentStartHits) {
            if (startPositions.contains(hit.begin) || hit.begin != 0 || this.ignoreMatch((AhoCorasickDoubleArrayTrie.Hit<String>)hit, text)) continue;
            this.addMatch(sentence, (AhoCorasickDoubleArrayTrie.Hit<String>)hit, matches);
            break;
        }
        return this.toRuleMatchArray(matches);
    }

    private void addMatch(AnalyzedSentence sentence, AhoCorasickDoubleArrayTrie.Hit<String> hit, List<RuleMatch> matches) {
        String message = "Diese Schreibweise war nur in der alten Rechtschreibung korrekt.";
        RuleMatch match = new RuleMatch((Rule)this, sentence, hit.begin, hit.end, message, "Alte Rechtschreibung");
        String[] suggestions = ((String)hit.value).split("\\|");
        match.setSuggestedReplacements(Arrays.asList(suggestions));
        String covered = sentence.getText().substring(hit.begin, hit.end);
        if (suggestions.length > 0 && suggestions[0].replaceFirst("ss", "\u00df").equals(covered)) {
            if (this.language.getShortCodeWithCountryAndVariant().equals("de-AT") && covered.toLowerCase().contains("gescho\u00df")) {
                return;
            }
            match.setMessage(message + " Das Wort wird mit 'ss' geschrieben, wenn davor eine kurz gesprochene Silbe steht.");
        }
        matches.add(match);
    }

    private boolean ignoreMatch(AhoCorasickDoubleArrayTrie.Hit<String> hit, String text) {
        String before4;
        String before5;
        for (String exception : EXCEPTIONS) {
            if (!text.regionMatches(true, hit.begin, exception, 0, exception.length()) && !text.regionMatches(true, hit.end - exception.length(), exception, 0, exception.length())) continue;
            return true;
        }
        if (hit.begin > 0 && !this.isBoundary(text.substring(hit.begin - 1, hit.begin))) {
            return true;
        }
        if (hit.end < text.length() && !this.isBoundary(text.substring(hit.end, hit.end + 1))) {
            return true;
        }
        if (hit.begin - 6 >= 0 && text.startsWith("Prof.", hit.begin - 6)) {
            return true;
        }
        if (hit.begin - 5 >= 0 && ((before5 = text.substring(hit.begin - 5, hit.begin - 1)).equals("Herr") || before5.equals("Frau"))) {
            return true;
        }
        return hit.begin - 4 >= 0 && ((before4 = text.substring(hit.begin - 4, hit.begin - 1)).equals("Hr.") || before4.equals("Fr.") || before4.equals("Dr."));
    }

    private boolean isBoundary(String s) {
        return !CHARS.matcher(s).matches();
    }
}

