/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.de;

import com.google.common.base.Suppliers;
import de.danielnaber.jwordsplitter.EmbeddedGermanDictionary;
import de.danielnaber.jwordsplitter.GermanWordSplitter;
import de.danielnaber.jwordsplitter.InputTooLongException;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.languagetool.tokenizers.Tokenizer;

public class GermanCompoundTokenizer
implements Tokenizer {
    private static final Supplier<GermanCompoundTokenizer> strictInstance = Suppliers.memoize(() -> {
        try {
            return new GermanCompoundTokenizer(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    private static final Supplier<GermanCompoundTokenizer> nonStrictInstance = Suppliers.memoize(() -> {
        try {
            return new GermanCompoundTokenizer(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    private final ExtendedGermanWordSplitter wordSplitter = new ExtendedGermanWordSplitter(false);

    public GermanCompoundTokenizer() throws IOException {
        this(true);
    }

    public GermanCompoundTokenizer(boolean strictMode) throws IOException {
        this.wordSplitter.setStrictMode(strictMode);
        this.wordSplitter.setMinimumWordLength(3);
        this.wordSplitter.addException("Alkoholabstinenz", Arrays.asList("Alkohol", "abstinenz"));
        this.wordSplitter.addException("Hallesche", Arrays.asList("Hallesche"));
        this.wordSplitter.addException("Kolleggen", Arrays.asList("Kolleggen"));
        this.wordSplitter.addException("Saunieren", Arrays.asList("Saunieren"));
        this.wordSplitter.addException("Spielgeleier", Arrays.asList("Spielgeleier"));
        this.wordSplitter.addException("Halleschen", Arrays.asList("Halleschen"));
        this.wordSplitter.addException("Reinigungstab", Arrays.asList("Reinigungs", "tab"));
        this.wordSplitter.addException("Reinigungstabs", Arrays.asList("Reinigungs", "tabs"));
        this.wordSplitter.addException("Tauschwerte", Arrays.asList("Tausch", "werte"));
        this.wordSplitter.addException("Tauschwertes", Arrays.asList("Tausch", "wertes"));
        this.wordSplitter.addException("Kinderspielen", Arrays.asList("Kinder", "spielen"));
        this.wordSplitter.addException("Buchhaltungstrick", Arrays.asList("Buchhaltungs", "trick"));
        this.wordSplitter.addException("Buchhaltungstricks", Arrays.asList("Buchhaltungs", "tricks"));
        this.wordSplitter.addException("Haushaltstrick", Arrays.asList("Haushalts", "trick"));
        this.wordSplitter.addException("Haushaltstricks", Arrays.asList("Haushalts", "tricks"));
        this.wordSplitter.addException("Verkaufstrick", Arrays.asList("Verkaufs", "trick"));
        this.wordSplitter.addException("Verkaufstricks", Arrays.asList("Verkaufs", "tricks"));
        this.wordSplitter.addException("Ablenkungstrick", Arrays.asList("Ablenkungs", "trick"));
        this.wordSplitter.addException("Ablenkungstricks", Arrays.asList("Ablenkungs", "tricks"));
        this.wordSplitter.addException("Manipulationstrick", Arrays.asList("Manipulations", "trick"));
        this.wordSplitter.addException("Manipulationstricks", Arrays.asList("Manipulations", "tricks"));
        this.wordSplitter.addException("Erziehungstrick", Arrays.asList("Erziehungs", "trick"));
        this.wordSplitter.addException("Erziehungstricks", Arrays.asList("Erziehungs", "tricks"));
        this.wordSplitter.addException("Messetage", Arrays.asList("Messe", "tage"));
        this.wordSplitter.addException("Messetagen", Arrays.asList("Messe", "tagen"));
        this.wordSplitter.addException("karamelligen", Arrays.asList("karamelligen"));
        this.wordSplitter.addException("H\u00e4kelnadel", Arrays.asList("H\u00e4kel", "nadel"));
        this.wordSplitter.addException("H\u00e4kelnadeln", Arrays.asList("H\u00e4kel", "nadeln"));
        this.wordSplitter.addException("Freiberg", Arrays.asList("Freiberg"));
        this.wordSplitter.addException("Abtestat", Arrays.asList("Abtestat"));
        this.wordSplitter.addException("Abtestaten", Arrays.asList("Abtestaten"));
        this.wordSplitter.addException("Freibergs", Arrays.asList("Freibergs"));
        this.wordSplitter.addException("Kreuzberg", Arrays.asList("Kreuzberg"));
        this.wordSplitter.addException("Kreuzbergs", Arrays.asList("Kreuzbergs"));
        this.wordSplitter.addException("Digitalisierung", Arrays.asList("Digitalisierung"));
        this.wordSplitter.addException("Abtrocknung", Arrays.asList("Abtrocknung"));
        this.wordSplitter.addException("Erl\u00f6sung", Arrays.asList("Erl\u00f6sung"));
        this.wordSplitter.addException("Feuerung", Arrays.asList("Feuerung"));
        this.wordSplitter.addException("Aktivierung", Arrays.asList("Aktivierung"));
        this.wordSplitter.addException("Protokollierung", Arrays.asList("Protokollierung"));
        this.wordSplitter.addException("Budgetierung", Arrays.asList("Budgetierung"));
        this.wordSplitter.addException("Faltung", Arrays.asList("Faltung"));
        this.wordSplitter.addException("Anh\u00e4ufung", Arrays.asList("Anh\u00e4ufung"));
        this.wordSplitter.addException("Aufkohlung", Arrays.asList("Aufkohlung"));
        this.wordSplitter.addException("Festigung", Arrays.asList("Festigung"));
        this.wordSplitter.addException("Allerheiligen", Arrays.asList("Allerheiligen"));
        this.wordSplitter.addException("Druckerpressen", Arrays.asList("Drucker", "pressen"));
    }

    public List<String> tokenize(String word) {
        try {
            return this.wordSplitter.splitWord(word);
        }
        catch (InputTooLongException e) {
            return Collections.singletonList(word);
        }
    }

    public static GermanCompoundTokenizer getStrictInstance() {
        return strictInstance.get();
    }

    public static GermanCompoundTokenizer getNonStrictInstance() {
        return nonStrictInstance.get();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: " + GermanCompoundTokenizer.class.getSimpleName() + " <wordsToSplit... or file>");
            System.exit(1);
        }
        GermanCompoundTokenizer tokenizer = new GermanCompoundTokenizer();
        if (new File(args[0]).exists()) {
            System.out.println("Working on lines from " + args[0] + ":");
            List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
            for (String line : lines) {
                System.out.println(tokenizer.tokenize(line));
            }
        } else {
            for (String arg : args) {
                System.out.println(tokenizer.tokenize(arg));
            }
        }
    }

    static class ExtendedGermanWordSplitter
    extends GermanWordSplitter {
        ExtendedGermanWordSplitter(boolean hideInterfixCharacters) throws IOException {
            super(hideInterfixCharacters, ExtendedGermanWordSplitter.extendedList());
        }

        static Set<String> extendedList() {
            ObjectOpenHashSet words = new ObjectOpenHashSet((Collection)EmbeddedGermanDictionary.getWords());
            words.add((Object)"salami");
            words.add((Object)"eukalyptus");
            words.add((Object)"kreativ");
            words.add((Object)"hochvolt");
            words.add((Object)"trading");
            words.add((Object)"extraktion");
            words.add((Object)"verstetigung");
            words.add((Object)"diagonal");
            words.add((Object)"margen");
            words.add((Object)"synonym");
            words.add((Object)"aufbringung");
            words.add((Object)"robustheit");
            words.add((Object)"nachuntersuchung");
            words.add((Object)"erstkommunion");
            words.add((Object)"hauptstadt");
            words.add((Object)"neustart");
            words.add((Object)"polarisierung");
            words.add((Object)"vollstreckbarkeit");
            words.add((Object)"vollziehung");
            words.add((Object)"kasko");
            words.add((Object)"blitzableiter");
            words.add((Object)"abschattungen");
            words.add((Object)"kuscheltier");
            words.add((Object)"gastro");
            words.trim();
            return words;
        }
    }
}

