/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.de;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.CombiningTagger;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.de.AdjectiveTags;
import org.languagetool.tagging.de.VerbPrefixes;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanTagger
extends BaseTagger {
    private static final List<String> allAdjGruTags = new ArrayList<String>();
    private static final Pattern mitarbeitendenPattern = Pattern.compile("[A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00fc\u00df]{2,25}mitarbeitenden?");
    private static final Pattern genderGapChars = Pattern.compile("[*:_/]");
    private static final Pattern afterAsterisk = Pattern.compile("in(nen)?|r|e");
    private static final Pattern innenPattern1 = Pattern.compile("in(nen)-[A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00fc\u00df-]+");
    private static final Pattern anythingDash = Pattern.compile(".*-");
    private static final Pattern innenPattern2 = Pattern.compile("innen[a-z\u00f6\u00e4\u00fc\u00df-]+");
    private static final Pattern DDD_ER_PATTERN = Pattern.compile("\\d{4}+er");
    private static final List<String> nounTagExpansionExceptions;
    private static final String[] prefixesSeparableVerbs;
    private static final String prefixesSeparableVerbsRegexp = "^(gegeneinander|durcheinander|nebeneinander|\u00fcbereinander|aufeinander|auseinander|beieinander|aneinander|ineinander|zueinander|gegen\u00fcber|beisammen|gegen\u00fcber|hernieder|r\u00fcckw\u00e4rts|wiederauf|wiederein|wiederher|zufrieden|zwangsvor|entgegen|hinunter|abhanden|aufrecht|aufw\u00e4rts|ausw\u00e4rts|beiseite|danieder|drauflos|einw\u00e4rts|herunter|hindurch|verr\u00fcckt|vorw\u00e4rts|zunichte|zusammen|zwangsum|zwischen|abseits|abw\u00e4rts|entlang|hinfort|\u00e4hnlich|daneben|general|her\u00fcber|hierher|hierhin|hin\u00fcber|schwarz|trocken|\u00fcberein|vorlieb|vor\u00fcber|wichtig|zurecht|zuwider|hinweg|allein|besser|daheim|doppel|feinst|fertig|herauf|heraus|herbei|hinauf|hinaus|hinein|kaputt|kennen|k\u00fcrzer|mittag|nieder|runter|sicher|sitzen|voraus|vorbei|vorweg|weiter|wieder|zugute|zur\u00fcck|zwangs|abend|blank|brust|dahin|davon|drauf|drein|durch|einig|empor|grund|herum|h\u00f6her|klein|knapp|krank|krumm|kugel|n\u00e4her|neben|offen|preis|r\u00fcber|ruhig|statt|still|\u00fcbrig|umher|unter|voran|zweck|acht|drei|fehl|feil|fort|frei|gro\u00df|hand|hart|heim|hier|hoch|klar|lahm|miss|nach|nahe|quer|rauf|raus|rein|r\u00fcck|satt|sto\u00df|teil|\u00fcber|voll|wach|wahr|warm|wert|wohl|auf|aus|bei|ehe|ein|eis|end|her|hin|los|ma\u00df|mit|not|out|ran|rum|tot|vor|weg|weh|ab|an|da|um|zu)";
    private static final String[] prefixesNonSeparableVerbs;
    private static final String prefixesNonSeparableVerbsRegexp = "^(be|emp|ent|er|hinter|miss|un|ver|zer)";
    private static final String[] prefixesVerbs;
    private static final String prefixesVerbsRegexp = "^(gegeneinander|durcheinander|nebeneinander|\u00fcbereinander|aufeinander|auseinander|beieinander|aneinander|ineinander|zueinander|gegen\u00fcber|beisammen|gegen\u00fcber|hernieder|r\u00fcckw\u00e4rts|wiederauf|wiederein|wiederher|zufrieden|zwangsvor|entgegen|hinunter|abhanden|aufrecht|aufw\u00e4rts|ausw\u00e4rts|beiseite|danieder|drauflos|einw\u00e4rts|herunter|hindurch|verr\u00fcckt|vorw\u00e4rts|zunichte|zusammen|zwangsum|zwischen|abseits|abw\u00e4rts|entlang|hinfort|\u00e4hnlich|daneben|general|her\u00fcber|hierher|hierhin|hin\u00fcber|schwarz|trocken|\u00fcberein|vorlieb|vor\u00fcber|wichtig|zurecht|zuwider|hinweg|hinter|allein|besser|daheim|doppel|feinst|fertig|herauf|heraus|herbei|hinauf|hinaus|hinein|kaputt|kennen|k\u00fcrzer|mittag|nieder|runter|sicher|sitzen|voraus|vorbei|vorweg|weiter|wieder|zugute|zur\u00fcck|zwangs|abend|blank|brust|dahin|davon|drauf|drein|durch|einig|empor|grund|herum|h\u00f6her|klein|knapp|krank|krumm|kugel|n\u00e4her|neben|offen|preis|r\u00fcber|ruhig|statt|still|\u00fcbrig|umher|unter|voran|zweck|miss|acht|drei|fehl|feil|fort|frei|gro\u00df|hand|hart|heim|hier|hoch|klar|lahm|miss|nach|nahe|quer|rauf|raus|rein|r\u00fcck|satt|sto\u00df|teil|\u00fcber|voll|wach|wahr|warm|wert|wohl|emp|ent|ver|zer|auf|aus|bei|ehe|ein|eis|end|her|hin|los|ma\u00df|mit|not|out|ran|rum|tot|vor|weg|weh|be|er|un|ab|an|da|um|zu)";
    private static final String[] partizip2contains1PluPra;
    private static final String[] partizip2contains1PluPrt;
    private static final String[] postagsPartizipEndingE;
    private static final String[] postagsPartizipEndingEm;
    private static final String[] postagsPartizipEndingEn;
    private static final String[] postagsPartizipEndingEr;
    private static final String[] postagsPartizipEndingEs;
    private static final String[] notAVerb;
    private static final List<String> tagsForWeise;
    private final ManualTagger removalTagger = (ManualTagger)((CombiningTagger)this.getWordTagger()).getRemovalTagger();
    private static final Supplier<ExpansionInfos> expansionInfos;
    public static final GermanTagger INSTANCE;

    public GermanTagger() {
        super("/de/german.dict", Locale.GERMAN);
    }

    private static ExpansionInfos initExpansionInfos() {
        Object2ObjectOpenHashMap verbInfos = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap nominalizedVerbInfos = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap nominalizedGenVerbInfos = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap adjInfos = new Object2ObjectOpenHashMap();
        String filename = "de/hunspell/spelling.txt";
        List spellingWords = new CachingWordListLoader().loadWords(filename);
        for (String line : spellingWords) {
            String word;
            if (line.endsWith("/PA") || line.endsWith("/AP")) {
                throw new RuntimeException("Use '/P' or '/A', but not both for a word in " + filename + ": " + line);
            }
            if (line.endsWith("/P")) {
                word = line.replaceFirst("/.*", "");
                GermanTagger.fillAdjInfos(word, "", GermanTagger.toPA2(AdjectiveTags.tagsForAdj), (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "e", GermanTagger.toPA2(AdjectiveTags.tagsForAdjE), (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "en", GermanTagger.toPA2(AdjectiveTags.tagsForAdjEn), (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "er", GermanTagger.toPA2(AdjectiveTags.tagsForAdjEr), (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "em", GermanTagger.toPA2(AdjectiveTags.tagsForAdjEm), (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "es", GermanTagger.toPA2(AdjectiveTags.tagsForAdjEs), (Map<String, List<AdjInfo>>)adjInfos);
                continue;
            }
            if (line.endsWith("/A") && !line.endsWith("ste/A") && !line.endsWith("er/A")) {
                word = line.replaceFirst("/.*", "");
                GermanTagger.fillAdjInfos(word, "", AdjectiveTags.tagsForAdj, (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "e", AdjectiveTags.tagsForAdjE, (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "en", AdjectiveTags.tagsForAdjEn, (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "er", AdjectiveTags.tagsForAdjEr, (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "em", AdjectiveTags.tagsForAdjEm, (Map<String, List<AdjInfo>>)adjInfos);
                GermanTagger.fillAdjInfos(word, "es", AdjectiveTags.tagsForAdjEs, (Map<String, List<AdjInfo>>)adjInfos);
                continue;
            }
            if (!line.contains("_") || line.endsWith("_in")) continue;
            String[] parts = line.replace("#.*", "").trim().split("_");
            String prefix = parts[0];
            String verbBaseform = parts[1];
            try {
                String[] forms;
                for (String form : forms = GermanSynthesizer.INSTANCE.synthesizeForPosTags(verbBaseform, s -> s.startsWith("VER:"))) {
                    if (form.contains("\u00df")) continue;
                    verbInfos.put(prefix + form, new PrefixInfixVerb(prefix, "", verbBaseform));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            verbInfos.put(prefix + "zu" + verbBaseform, new PrefixInfixVerb(prefix, "zu", verbBaseform));
            nominalizedVerbInfos.put(StringTools.uppercaseFirstChar((String)prefix) + verbBaseform, new NominalizedVerb(StringTools.uppercaseFirstChar((String)prefix), verbBaseform));
            nominalizedGenVerbInfos.put(StringTools.uppercaseFirstChar((String)prefix) + verbBaseform + "s", new NominalizedGenitiveVerb(StringTools.uppercaseFirstChar((String)prefix), verbBaseform));
        }
        return new ExpansionInfos((Map<String, PrefixInfixVerb>)verbInfos, (Map<String, NominalizedVerb>)nominalizedVerbInfos, (Map<String, NominalizedGenitiveVerb>)nominalizedGenVerbInfos, (Map<String, List<AdjInfo>>)adjInfos);
    }

    private static List<String> toPA2(List<String> tags) {
        return tags.stream().map(k -> k.replaceAll("ADJ:", "PA2:")).map(k -> k + ":VER").collect(Collectors.toList());
    }

    private static void fillAdjInfos(String word, String suffix, List<String> tagsForForm, Map<String, List<AdjInfo>> adjInfos) {
        ArrayList<AdjInfo> l = new ArrayList<AdjInfo>();
        String fullform = word + suffix;
        for (String tag : tagsForForm) {
            l.add(new AdjInfo(word, fullform, tag));
        }
        adjInfos.put(fullform, l);
    }

    private List<TaggedWord> addStem(List<TaggedWord> analyzedWordResults, String stem) {
        ArrayList<TaggedWord> result = new ArrayList<TaggedWord>();
        for (TaggedWord tw : analyzedWordResults) {
            String lemma = tw.getLemma();
            if (stem.length() > 0 && stem.charAt(stem.length() - 1) != '-' && tw.getPosTag().startsWith("SUB")) {
                lemma = lemma.toLowerCase();
            }
            result.add(new TaggedWord(stem + lemma, tw.getPosTag()));
        }
        return result;
    }

    private String sanitizeWord(String word) {
        String result = word;
        if (!word.endsWith("-")) {
            String[] splitWord = word.split("-");
            String lastPart = splitWord.length > 1 && !splitWord[splitWord.length - 1].trim().equals("") ? splitWord[splitWord.length - 1] : word;
            List<String> compoundedWord = GermanCompoundTokenizer.getStrictInstance().tokenize(lastPart);
            lastPart = compoundedWord.size() > 1 && StringTools.startsWithUppercase((String)word) ? StringTools.uppercaseFirstChar((String)compoundedWord.get(compoundedWord.size() - 1)) : compoundedWord.get(compoundedWord.size() - 1);
            List<TaggedWord> tagged = this.tag(lastPart);
            if (tagged.size() > 0 && (StringUtils.startsWithAny((CharSequence)tagged.get(0).getPosTag(), (CharSequence[])new CharSequence[]{"SUB", "ADJ"}) || this.matchesUppercaseAdjective(lastPart))) {
                result = lastPart;
            }
        }
        return result;
    }

    @Nullable
    public AnalyzedTokenReadings lookup(String word) throws IOException {
        List<AnalyzedTokenReadings> result = this.tag(Collections.singletonList(word), false);
        AnalyzedTokenReadings atr = result.get(0);
        if (atr.getAnalyzedToken(0).getPOSTag() == null) {
            return null;
        }
        return atr;
    }

    public List<TaggedWord> tag(String word) {
        return this.getWordTagger().tag(word);
    }

    private boolean matchesUppercaseAdjective(String unknownUppercaseToken) {
        List temp = this.getWordTagger().tag(StringTools.lowercaseFirstChar((String)unknownUppercaseToken));
        return temp.size() > 0 && ((TaggedWord)temp.get(0)).getPosTag().startsWith("ADJ");
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        return this.tag(sentenceTokens, true);
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens, boolean ignoreCase) throws IOException {
        boolean firstWord = true;
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        int idxPos = 0;
        String prevWord = null;
        for (String word : sentenceTokens) {
            int idx;
            ArrayList<AnalyzedToken> readings = new ArrayList<AnalyzedToken>();
            ArrayList taggerTokens = null;
            if (idxPos + 2 < sentenceTokens.size() && genderGapChars.matcher(sentenceTokens.get(idxPos + 1)).matches()) {
                if (afterAsterisk.matcher(sentenceTokens.get(idxPos + 2)).matches()) {
                    taggerTokens = new ArrayList();
                    taggerTokens.addAll(this.getWordTagger().tag(word));
                    taggerTokens.addAll(this.getWordTagger().tag(word + sentenceTokens.get(idxPos + 2)));
                } else if (innenPattern1.matcher(sentenceTokens.get(idxPos + 2)).matches()) {
                    String lastPart = anythingDash.matcher(sentenceTokens.get(idxPos + 2)).replaceFirst("");
                    taggerTokens = new ArrayList(this.getWordTagger().tag(lastPart));
                } else if (innenPattern2.matcher(sentenceTokens.get(idxPos + 2)).matches()) {
                    int idx2 = sentenceTokens.get(idxPos + 2).lastIndexOf("innen");
                    String lastPart = StringTools.uppercaseFirstChar((String)sentenceTokens.get(idxPos + 2).substring(idx2 + "innen".length()));
                    taggerTokens = new ArrayList(this.getWordTagger().tag(lastPart));
                }
            }
            if (taggerTokens == null) {
                taggerTokens = this.getWordTagger().tag(word);
            }
            if ((firstWord || ":".equals(prevWord)) && taggerTokens.isEmpty() && ignoreCase) {
                taggerTokens = this.getWordTagger().tag(word.toLowerCase());
                firstWord = !StringUtils.isAlphanumeric((CharSequence)word);
            } else if (pos == 0 && ignoreCase) {
                taggerTokens.addAll(this.getWordTagger().tag(word.toLowerCase()));
            } else if (pos > 1 && taggerTokens.isEmpty() && ignoreCase && (idx = sentenceTokens.indexOf(word)) > 2 && sentenceTokens.get(idx - 1).contentEquals("\u201e") && sentenceTokens.get(idx - 3).contentEquals(":")) {
                taggerTokens.addAll(this.getWordTagger().tag(word.toLowerCase()));
            }
            if (taggerTokens.size() > 0) {
                readings.addAll(this.getAnalyzedTokens(taggerTokens, word));
                if (!StringUtils.startsWithAny((CharSequence)word.toLowerCase(), (CharSequence[])prefixesSeparableVerbs) && !StringUtils.startsWithAny((CharSequence)word.toLowerCase(), (CharSequence[])notAVerb) && (word.equals(word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()) || word.equals(word.toLowerCase()))) {
                    String lstPrt = "";
                    String frstPrt = "";
                    if (StringUtils.startsWithAny((CharSequence)word.toLowerCase(), (CharSequence[])prefixesNonSeparableVerbs)) {
                        lstPrt = RegExUtils.removePattern((String)word.toLowerCase(), (String)prefixesNonSeparableVerbsRegexp);
                        frstPrt = StringUtils.removeEnd((String)word, (String)lstPrt);
                    } else {
                        lstPrt = word;
                        frstPrt = "";
                    }
                    List verbs = this.getWordTagger().tag(lstPrt);
                    for (TaggedWord v : verbs) {
                        if (sentenceTokens.indexOf(word) != 0 && !word.equals(word.substring(0, 1).toLowerCase() + word.substring(1)) || StringUtils.equalsAny((CharSequence)lstPrt, (CharSequence[])new CharSequence[]{"gar", "mal", "null", "trotz"})) continue;
                        if (StringUtils.startsWithAny((CharSequence)v.getPosTag(), (CharSequence[])new CharSequence[]{"VER:IMP:SIN:SFT"}) && !((Object)readings).toString().contains("VER:1:SIN:PR\u00c4:SFT")) {
                            readings.add(new AnalyzedToken(word, "VER:1:SIN:PR\u00c4:SFT", frstPrt.toLowerCase() + v.getLemma()));
                        }
                        if (!StringUtils.startsWithAny((CharSequence)v.getPosTag(), (CharSequence[])new CharSequence[]{"VER:1:SIN:PR\u00c4:SFT"}) || ((Object)readings).toString().contains("VER:IMP:SIN:SFT")) continue;
                        readings.add(new AnalyzedToken(word, "VER:IMP:SIN:SFT", frstPrt.toLowerCase() + v.getLemma()));
                    }
                }
            } else {
                boolean addNounTags;
                PrefixInfixVerb verbInfo = GermanTagger.expansionInfos.get().verbInfos.get(word);
                NominalizedVerb nomVerbInfo = GermanTagger.expansionInfos.get().nominalizedVerbInfos.get(word);
                NominalizedGenitiveVerb nomGenVerbInfo = GermanTagger.expansionInfos.get().nominalizedGenVerbInfos.get(word);
                List<AdjInfo> adjInfos = GermanTagger.expansionInfos.get().adjInfos.get(word);
                boolean bl = addNounTags = !nounTagExpansionExceptions.contains(word);
                if (verbInfo != null) {
                    if (StringTools.startsWithLowercase((String)verbInfo.prefix)) {
                        String noPrefixForm = word.substring(verbInfo.prefix.length() + verbInfo.infix.length());
                        List<TaggedWord> tags = this.tag(noPrefixForm);
                        boolean isSFT = false;
                        for (TaggedWord taggedWord : tags) {
                            if (taggedWord.getPosTag() == null || !StringUtils.startsWithAny((CharSequence)taggedWord.getPosTag(), (CharSequence[])new CharSequence[]{"VER:", "PA1:", "PA2:"}) || StringUtils.startsWithAny((CharSequence)taggedWord.getPosTag(), (CharSequence[])new CharSequence[]{"VER:MOD", "VER:AUX"})) continue;
                            String flektion = taggedWord.getPosTag().substring(taggedWord.getPosTag().length() - 3, taggedWord.getPosTag().length());
                            if (StringUtils.startsWithAny((CharSequence)verbInfo.prefix, (CharSequence[])prefixesSeparableVerbs) && !StringUtils.containsAny((CharSequence)word, (CharSequence[])notAVerb)) {
                                if (StringUtils.startsWithAny((CharSequence)taggedWord.getPosTag(), (CharSequence[])new CharSequence[]{"VER:1", "VER:2", "VER:3"}) && (sentenceTokens.indexOf(word) == 0 || word.equals(word.substring(0, 1).toLowerCase() + word.substring(1)))) {
                                    readings.add(new AnalyzedToken(word, taggedWord.getPosTag() + ":NEB", verbInfo.prefix + taggedWord.getLemma()));
                                } else if (!StringUtils.startsWithAny((CharSequence)taggedWord.getPosTag(), (CharSequence[])new CharSequence[]{"VER:IMP"})) {
                                    readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), verbInfo.prefix + taggedWord.getLemma()));
                                } else if (StringUtils.startsWithAny((CharSequence)taggedWord.getPosTag(), (CharSequence[])new CharSequence[]{"VER:IMP:SIN"}) && !readings.contains("VER:1:SIN:PR\u00c4") && (flektion.equals("SFT") || !word.matches(".*i.+"))) {
                                    readings.add(new AnalyzedToken(word, "VER:1:SIN:PR\u00c4:" + flektion + ":NEB", verbInfo.prefix + taggedWord.getLemma()));
                                }
                            } else if (StringUtils.startsWithAny((CharSequence)verbInfo.prefix, (CharSequence[])prefixesNonSeparableVerbs) && !StringUtils.containsAny((CharSequence)word, (CharSequence[])notAVerb)) {
                                if (StringUtils.startsWithAny((CharSequence)taggedWord.getPosTag(), (CharSequence[])new CharSequence[]{"VER:IMP:SIN"}) && !readings.contains("VER:1:SIN:PR\u00c4") || StringUtils.startsWithAny((CharSequence)taggedWord.getPosTag(), (CharSequence[])new CharSequence[]{"VER:1:SIN:PR\u00c4"}) && !readings.contains("VER:IMP:SIN")) {
                                    if (flektion.equals("SFT") || !word.matches(".*i.+")) {
                                        readings.add(new AnalyzedToken(word, "VER:IMP:SIN" + flektion, verbInfo.prefix + taggedWord.getLemma()));
                                        readings.add(new AnalyzedToken(word, "VER:1:SIN:PR\u00c4:" + flektion, verbInfo.prefix + taggedWord.getLemma()));
                                    }
                                } else {
                                    readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), verbInfo.prefix + taggedWord.getLemma()));
                                }
                            }
                            if (!taggedWord.getPosTag().contains(":SFT")) continue;
                            isSFT = true;
                        }
                        if ("zu".equals(verbInfo.infix)) {
                            readings.clear();
                            readings.add(new AnalyzedToken(word, "VER:EIZ:" + (isSFT ? "SFT" : "NON"), verbInfo.prefix + verbInfo.verbBaseform));
                        }
                    }
                } else if (nomVerbInfo != null && addNounTags) {
                    readings.add(new AnalyzedToken(word, "SUB:NOM:SIN:NEU:INF", nomVerbInfo.prefix + nomVerbInfo.verbBaseform));
                    readings.add(new AnalyzedToken(word, "SUB:AKK:SIN:NEU:INF", nomVerbInfo.prefix + nomVerbInfo.verbBaseform));
                    readings.add(new AnalyzedToken(word, "SUB:DAT:SIN:NEU:INF", nomVerbInfo.prefix + nomVerbInfo.verbBaseform));
                } else if (nomGenVerbInfo != null && addNounTags) {
                    readings.add(new AnalyzedToken(word, "SUB:GEN:SIN:NEU:INF", nomGenVerbInfo.prefix + nomGenVerbInfo.verbBaseform));
                } else if (adjInfos != null) {
                    for (AdjInfo adjInfo : adjInfos) {
                        readings.add(new AnalyzedToken(adjInfo.fullForm, adjInfo.tag, adjInfo.baseform));
                    }
                } else if (this.isWeiseException(word)) {
                    for (String tag : tagsForWeise) {
                        readings.add(new AnalyzedToken(word, tag, word));
                    }
                } else if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{word}) && mitarbeitendenPattern.matcher(word).matches()) {
                    int idx3 = word.indexOf("mitarbeitende");
                    String firstPart = word.substring(0, idx3);
                    String lastPart = word.substring(idx3);
                    List mitarbeitendeTags = this.getWordTagger().tag(StringTools.uppercaseFirstChar((String)lastPart));
                    for (TaggedWord mitarbeitendeTag : mitarbeitendeTags) {
                        readings.add(new AnalyzedToken(word, mitarbeitendeTag.getPosTag(), firstPart + "mitarbeitende"));
                    }
                } else if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{word})) {
                    List<String> compoundParts = GermanCompoundTokenizer.getStrictInstance().tokenize(word);
                    if (compoundParts.size() <= 1) {
                        List<AnalyzedToken> imperativeFormList = this.getImperativeForm(word, sentenceTokens, pos);
                        List<AnalyzedToken> substantivatedFormsList = this.getSubstantivatedForms(word, sentenceTokens);
                        if (imperativeFormList.size() > 0) {
                            readings.addAll(imperativeFormList);
                        } else if (substantivatedFormsList.size() > 0) {
                            readings.addAll(substantivatedFormsList);
                        } else {
                            String lastPart;
                            if (StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"bitter", "dunkel", "erz", "extra", "fr\u00fch", "gemein", "hyper", "lau", "mega", "minder", "stock", "super", "tod", "ultra", "un", "ur"}) && (lastPart = RegExUtils.removePattern((String)word, (String)"^(bitter|dunkel|erz|extra|fr\u00fch|gemein|grund|hyper|lau|mega|minder|stock|super|tod|ultra|u[nr]|voll)")).length() > 3) {
                                String string = StringUtils.removeEnd((String)word, (String)lastPart);
                                List taggedWords = this.getWordTagger().tag(lastPart);
                                for (TaggedWord taggedWord : taggedWords) {
                                    if (string.length() == 2 && taggedWord.getPosTag().startsWith("VER")) continue;
                                    readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), string + taggedWord.getLemma()));
                                }
                            }
                            if (StringUtils.split((String)word, (char)' ').length == 1 && !Character.isDigit(word.charAt(0))) {
                                String wordOrig = word;
                                word = this.sanitizeWord(word);
                                String string = wordOrig.substring(0, wordOrig.length() - word.length());
                                List<String> compoundedWord = GermanCompoundTokenizer.getStrictInstance().tokenize(word);
                                word = compoundedWord.size() > 1 ? StringTools.uppercaseFirstChar((String)compoundedWord.get(compoundedWord.size() - 1)) : compoundedWord.get(compoundedWord.size() - 1);
                                List linkedTaggerTokens = this.addStem(this.getWordTagger().tag(word), string);
                                if (wordOrig.contains("-") && linkedTaggerTokens.isEmpty() && this.matchesUppercaseAdjective(word)) {
                                    word = StringTools.lowercaseFirstChar((String)word);
                                    linkedTaggerTokens = this.getWordTagger().tag(word);
                                }
                                word = wordOrig;
                                boolean wordStartsUppercase = StringTools.startsWithUppercase((String)word);
                                if (linkedTaggerTokens.isEmpty()) {
                                    if (StringUtils.startsWithAny((CharSequence)word.toLowerCase(), (CharSequence[])prefixesVerbs) && !StringUtils.containsAny((CharSequence)word.toLowerCase(), (CharSequence[])notAVerb) && (word.equals(word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()) || word.equals(word.toLowerCase()))) {
                                        String lastPart2 = RegExUtils.removePattern((String)word.toLowerCase(), (String)prefixesVerbsRegexp);
                                        if (lastPart2.length() > 2) {
                                            String firstPart2 = StringUtils.removeEnd((String)word, (String)lastPart2);
                                            if (StringUtils.startsWithAny((CharSequence)lastPart2, (CharSequence[])new CharSequence[]{"zu"})) {
                                                String infinitiv = StringUtils.removeStart((String)lastPart2, (String)"zu");
                                                List infs = this.getWordTagger().tag(infinitiv);
                                                Iterator iterator = infs.iterator();
                                                while (iterator.hasNext()) {
                                                    TaggedWord inf = (TaggedWord)iterator.next();
                                                    if (!inf.getPosTag().startsWith("VER:INF")) continue;
                                                    String[] pstg = RegExUtils.replaceFirst((String)inf.getPosTag(), (String)"INF", (String)"EIZ");
                                                    readings.add(new AnalyzedToken(word, (String)pstg, firstPart2 + inf.getLemma()));
                                                }
                                            }
                                            List taggedWords = this.getWordTagger().tag(lastPart2);
                                            for (TaggedWord taggedWord : taggedWords) {
                                                if (!(!taggedWord.getPosTag().startsWith("VER") || taggedWord.getPosTag().startsWith("VER:PA") || taggedWord.getPosTag().startsWith("VER:AUX") || taggedWord.getPosTag().startsWith("VER:MOD") || firstPart2.equals("un"))) {
                                                    if (taggedWord.getPosTag().startsWith("VER:INF")) {
                                                        if (word.equals(word.substring(0, 1).toUpperCase() + word.substring(1))) {
                                                            readings.add(new AnalyzedToken(word, "SUB:NOM:SIN:NEU:INF", word));
                                                            readings.add(new AnalyzedToken(word, "SUB:DAT:SIN:NEU:INF", word));
                                                            readings.add(new AnalyzedToken(word, "SUB:AKK:SIN:NEU:INF", word));
                                                            if (sentenceTokens.indexOf(word) != 0) continue;
                                                            readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), firstPart2.toLowerCase() + taggedWord.getLemma()));
                                                            continue;
                                                        }
                                                        readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), firstPart2.toLowerCase() + taggedWord.getLemma()));
                                                        continue;
                                                    }
                                                    if (taggedWord.getPosTag().startsWith("VER:IMP")) {
                                                        String flekt = taggedWord.getPosTag().substring(taggedWord.getPosTag().length() - 3, taggedWord.getPosTag().length());
                                                        if (!word.equals(word.toLowerCase()) && sentenceTokens.indexOf(word) != 0) continue;
                                                        if (!StringUtils.equalsAny((CharSequence)firstPart2.toLowerCase(), (CharSequence[])prefixesSeparableVerbs)) {
                                                            readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), firstPart2.toLowerCase() + taggedWord.getLemma()));
                                                            if (!taggedWord.getPosTag().startsWith("VER:IMP:SIN") || readings.contains("VER:1:SIN:PR\u00c4") || readings.contains("VER:IMP:SIN:NON")) continue;
                                                            readings.add(new AnalyzedToken(word, "VER:1:SIN:PR\u00c4:" + flekt, firstPart2 + taggedWord.getLemma()));
                                                            continue;
                                                        }
                                                        if (readings.contains("VER:1:SIN:PR\u00c4") || !flekt.equals("SFT") && word.matches(".*i.+")) continue;
                                                        readings.add(new AnalyzedToken(word, "VER:1:SIN:PR\u00c4:" + flekt + ":NEB", firstPart2 + taggedWord.getLemma()));
                                                        continue;
                                                    }
                                                    if (StringUtils.equalsAny((CharSequence)firstPart2.toLowerCase(), (CharSequence[])prefixesSeparableVerbs) && (word.equals(word.toLowerCase()) || sentenceTokens.indexOf(word) == 0)) {
                                                        if (taggedWord.getPosTag().endsWith(":NEB")) {
                                                            readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), firstPart2.toLowerCase() + taggedWord.getLemma()));
                                                        } else {
                                                            readings.add(new AnalyzedToken(word, taggedWord.getPosTag() + ":NEB", firstPart2.toLowerCase() + taggedWord.getLemma()));
                                                        }
                                                        if (!taggedWord.getPosTag().startsWith("VER:3:SIN:PR\u00c4") || !firstPart2.equals("durch") && !firstPart2.equals("um")) continue;
                                                        if (taggedWord.getPosTag().startsWith("VER:3:SIN:PR\u00c4")) {
                                                            readings.add(new AnalyzedToken(word, "VER:PA2:SFT", firstPart2 + taggedWord.getLemma()));
                                                        } else {
                                                            readings.add(new AnalyzedToken(word, "VER:PA2:NON", firstPart2 + taggedWord.getLemma()));
                                                        }
                                                        readings.add(new AnalyzedToken(word, "PA2:PRD:GRU:VER", word));
                                                        continue;
                                                    }
                                                    if (!StringUtils.equalsAny((CharSequence)firstPart2.toLowerCase(), (CharSequence[])prefixesNonSeparableVerbs) || !word.equals(word.toLowerCase()) && sentenceTokens.indexOf(word) != 0) continue;
                                                    readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), firstPart2.toLowerCase() + taggedWord.getLemma()));
                                                    if (!taggedWord.getPosTag().startsWith("VER:3:SIN:PR\u00c4:SFT") && (!taggedWord.getPosTag().startsWith("VER:1:PLU:PR\u00c4:NON") || !StringUtils.containsAny((CharSequence)taggedWord.getLemma(), (CharSequence[])partizip2contains1PluPra)) && (!taggedWord.getPosTag().startsWith("VER:1:PLU:PRT:NON") || !StringUtils.containsAny((CharSequence)taggedWord.getLemma(), (CharSequence[])partizip2contains1PluPrt))) continue;
                                                    if (!firstPart2.equals("un")) {
                                                        String fl = taggedWord.getPosTag().substring(taggedWord.getPosTag().length() - 3, taggedWord.getPosTag().length());
                                                        readings.add(new AnalyzedToken(word, "VER:PA2:" + fl, firstPart2 + taggedWord.getLemma()));
                                                    }
                                                    readings.add(new AnalyzedToken(word, "PA2:PRD:GRU:VER", word));
                                                    continue;
                                                }
                                                if (!taggedWord.getPosTag().startsWith("PA") && !taggedWord.getPosTag().startsWith("VER:PA") || !word.equals(word.toLowerCase()) && sentenceTokens.indexOf(word) != 0 || firstPart2.equals("un") && taggedWord.getPosTag().startsWith("VER:PA")) continue;
                                                readings.add(new AnalyzedToken(word, taggedWord.getPosTag(), firstPart2.toLowerCase() + taggedWord.getLemma()));
                                            }
                                            String[] partizipSuffixes = new String[]{"e", "em", "en", "er", "es"};
                                            String middlePart = "";
                                            String suffix = "";
                                            for (String sffx : partizipSuffixes) {
                                                if (!lastPart2.endsWith(sffx)) continue;
                                                middlePart = lastPart2.substring(0, lastPart2.length() - sffx.length());
                                                suffix = sffx;
                                            }
                                            List taggedMiddle = this.getWordTagger().tag(middlePart);
                                            block24: for (TaggedWord taggedM : taggedMiddle) {
                                                if (!taggedM.getPosTag().startsWith("VER:3:SIN:PR\u00c4:SFT") || !word.equals(word.toLowerCase()) && sentenceTokens.indexOf(word) != 0) continue;
                                                String lemma = word.substring(0, word.length() - suffix.length());
                                                switch (suffix) {
                                                    case "e": {
                                                        for (String posEndsWithE : postagsPartizipEndingE) {
                                                            readings.add(new AnalyzedToken(word, "PA2:" + posEndsWithE, lemma));
                                                        }
                                                        continue block24;
                                                    }
                                                    case "em": {
                                                        for (String posEndsWithEm : postagsPartizipEndingEm) {
                                                            readings.add(new AnalyzedToken(word, "PA2:" + posEndsWithEm, lemma));
                                                        }
                                                        continue block24;
                                                    }
                                                    case "en": {
                                                        for (String posEndsWithEn : postagsPartizipEndingEn) {
                                                            readings.add(new AnalyzedToken(word, "PA2:" + posEndsWithEn, lemma));
                                                        }
                                                        continue block24;
                                                    }
                                                    case "er": {
                                                        for (String posEndsWithEr : postagsPartizipEndingEr) {
                                                            readings.add(new AnalyzedToken(word, "PA2:" + posEndsWithEr, lemma));
                                                        }
                                                        continue block24;
                                                    }
                                                    case "es": {
                                                        for (String posEndsWithEs : postagsPartizipEndingEs) {
                                                            readings.add(new AnalyzedToken(word, "PA2:" + posEndsWithEs, lemma));
                                                        }
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                    } else {
                                        readings.add(this.getNoInfoToken(word));
                                    }
                                } else if (wordStartsUppercase) {
                                    readings.addAll(this.getAnalyzedTokens(linkedTaggerTokens, word));
                                } else {
                                    readings.addAll(this.getAnalyzedTokens(linkedTaggerTokens, word, compoundedWord));
                                }
                            } else {
                                readings.add(this.getNoInfoToken(word));
                            }
                        }
                    } else if (idxPos + 2 >= sentenceTokens.size() || !sentenceTokens.get(idxPos + 1).equals(".") || !sentenceTokens.get(idxPos + 2).matches("com|net|org|de|at|ch|fr|uk|gov")) {
                        List partTaggerTokens;
                        String lastPart = compoundParts.get(compoundParts.size() - 1);
                        if (StringTools.startsWithUppercase((String)word) && !StringUtils.containsAny((CharSequence)lastPart, (CharSequence[])new CharSequence[]{"freie", "freier", "freien", "freies", "freiem"})) {
                            lastPart = StringTools.uppercaseFirstChar((String)lastPart);
                        }
                        if ((partTaggerTokens = this.getWordTagger().tag(lastPart)).isEmpty()) {
                            readings.add(this.getNoInfoToken(word));
                        } else {
                            List<Object> temp = this.getAnalyzedTokens(partTaggerTokens, word, compoundParts);
                            String string = compoundParts.get(0);
                            ArrayList<String> prfxs = new ArrayList<String>(Arrays.asList("ab", "abend", "abhanden", "acht", "\u00e4hnlich", "allein", "an", "auf", "aufeinander", "aufrecht", "aufw\u00e4rts", "aus", "auseinander", "ausw\u00e4rts", "bei", "beieinander", "beisammen", "beiseite", "besser", "blank", "brust", "da", "daheim", "dahin", "daneben", "danieder", "davon", "doppel", "drauflos", "drei", "drein", "durch", "durcheinander", "ehe", "ein", "einig", "einw\u00e4rts", "eis", "empor", "end", "fehl", "feil", "feinst", "fort", "frei", "gegen\u00fcber", "general", "gro\u00df", "grund", "hand", "hart", "heim", "her", "herauf", "heraus", "herbei", "hernieder", "her\u00fcber", "herum", "herunter", "hier", "hierher", "hierhin", "hin", "hinauf", "hinaus", "hindurch", "hinein", "hin\u00fcber", "hoch", "h\u00f6her", "ineinander", "kaputt", "kennen", "klar", "klein", "knapp", "krank", "krumm", "kugel", "k\u00fcrzer", "lahm", "los", "ma\u00df", "miss", "mit", "mittag", "nach", "nahe", "n\u00e4her", "neben", "nebeneinander", "nieder", "offen", "out", "preis", "quer", "ran", "rauf", "raus", "rein", "r\u00fcber", "r\u00fcck", "r\u00fcckw\u00e4rts", "ruhig", "rum", "runter", "satt", "schwarz", "sicher", "sitzen", "statt", "still", "sto\u00df", "teil", "tot", "trocken", "\u00fcber", "\u00fcberein", "\u00fcbereinander", "\u00fcbrig", "um", "umher", "unter", "verr\u00fcckt", "voll", "vor", "voran", "voraus", "vorbei", "vorlieb", "vor\u00fcber", "vorw\u00e4rts", "vorweg", "wach", "wahr", "warm", "weg", "weh", "weiter", "wert", "wichtig", "wieder", "wiederauf", "wiederein", "wiederher", "wohl", "zu", "zueinander", "zufrieden", "zugute", "zunichte", "zurecht", "zur\u00fcck", "zusammen", "zuwider", "zwangs", "zwangsum", "zwangsvor", "zweck", "zwischen"));
                            if (prfxs.contains(string)) {
                                for (TaggedWord tag : partTaggerTokens) {
                                    if (StringUtils.startsWithAny((CharSequence)tag.getPosTag(), (CharSequence[])new CharSequence[]{"VER:1", "VER:2", "VER:3"}) && (sentenceTokens.indexOf(word) == 0 || word.equals(word.substring(0, 1).toLowerCase() + word.substring(1)))) {
                                        if (StringUtils.endsWith((CharSequence)tag.getPosTag(), (CharSequence)"NEB")) {
                                            readings.add(new AnalyzedToken(word, tag.getPosTag(), string + tag.getLemma()));
                                            continue;
                                        }
                                        readings.add(new AnalyzedToken(word, tag.getPosTag() + ":NEB", string + tag.getLemma()));
                                        continue;
                                    }
                                    if (StringUtils.startsWithAny((CharSequence)tag.getPosTag(), (CharSequence[])new CharSequence[]{"VER:IMP"})) continue;
                                    readings.add(new AnalyzedToken(word, tag.getPosTag(), string + tag.getLemma()));
                                }
                            } else {
                                temp = temp.stream().filter(k -> !k.getPOSTag().contains("VER")).collect(Collectors.toList());
                                readings.addAll(temp);
                            }
                        }
                    }
                }
                if (readings.isEmpty()) {
                    readings.add(this.getNoInfoToken(word));
                }
            }
            tokenReadings.add(new AnalyzedTokenReadings(readings.toArray(new AnalyzedToken[0]), pos));
            pos += word.length();
            prevWord = word;
            ++idxPos;
        }
        return tokenReadings;
    }

    @Nullable
    String prefixedVerbLastPart(String word) {
        for (String prefix : VerbPrefixes.get()) {
            List<TaggedWord> tags;
            if (!word.startsWith(prefix) || !(tags = this.tag(word.replaceFirst("^" + prefix, ""))).stream().anyMatch(k -> k.getPosTag() != null && k.getPosTag().startsWith("VER"))) continue;
            return word.substring(prefix.length());
        }
        return null;
    }

    boolean isWeiseException(String word) {
        if (word.endsWith("erweise")) {
            List<TaggedWord> tags = this.tag(StringUtils.removeEnd((String)word, (String)"erweise"));
            return tags.stream().anyMatch(k -> k.getPosTag() != null && k.getPosTag().startsWith("ADJ"));
        }
        return false;
    }

    private List<AnalyzedToken> getImperativeForm(String word, List<String> sentenceTokens, int pos) {
        int idx = sentenceTokens.indexOf(word);
        String previousWord = "";
        while (--idx > -1 && StringUtils.isWhitespace((CharSequence)(previousWord = sentenceTokens.get(idx)))) {
        }
        if (!(pos == 0 && sentenceTokens.size() > 1 || StringUtils.equalsAnyIgnoreCase((CharSequence)previousWord, (CharSequence[])new CharSequence[]{"ich", "er", "es", "sie", "bitte", "aber", "nun", "jetzt", "\u201e"}))) {
            return Collections.emptyList();
        }
        String w = pos == 0 || "\u201e".equals(previousWord) ? word.toLowerCase() : word;
        List taggedWithE = this.getWordTagger().tag(w.concat("e"));
        for (TaggedWord tagged : taggedWithE) {
            if (!tagged.getPosTag().startsWith("VER:IMP:SIN")) continue;
            if (this.removalTagger != null && this.removalTagger.tag(w).contains(tagged)) break;
            return this.getAnalyzedTokens(Arrays.asList(tagged), word);
        }
        return Collections.emptyList();
    }

    private List<AnalyzedToken> getSubstantivatedForms(String word, List<String> sentenceTokens) {
        if (word.endsWith("er")) {
            if (DDD_ER_PATTERN.matcher(word).matches()) {
                ArrayList<AnalyzedToken> list = new ArrayList<AnalyzedToken>();
                for (String tag : allAdjGruTags) {
                    list.add(new AnalyzedToken(word, tag, word));
                }
                return list;
            }
            List lowerCaseTags = this.getWordTagger().tag(word.toLowerCase());
            if (lowerCaseTags.stream().anyMatch(t -> t.getPosTag().startsWith("ADV"))) {
                return Collections.emptyList();
            }
            int idx = sentenceTokens.indexOf(word);
            while (++idx < sentenceTokens.size()) {
                String nextWord = sentenceTokens.get(idx);
                if (StringUtils.isWhitespace((CharSequence)nextWord)) continue;
                if (nextWord.length() <= 0 || !Character.isUpperCase(nextWord.charAt(0)) && !"als".equals(nextWord)) break;
                return Collections.emptyList();
            }
            String femaleForm = word.substring(0, word.length() - 1);
            List taggedFemaleForm = this.getWordTagger().tag(femaleForm);
            boolean isSubstantivatedForm = taggedFemaleForm.stream().anyMatch(t -> t.getPosTag().equals("SUB:NOM:SIN:FEM:ADJ"));
            if (isSubstantivatedForm) {
                ArrayList<AnalyzedToken> list = new ArrayList<AnalyzedToken>();
                list.add(new AnalyzedToken(word, "SUB:NOM:SIN:MAS:ADJ", word));
                list.add(new AnalyzedToken(word, "SUB:GEN:PLU:MAS:ADJ", word));
                return list;
            }
        }
        return Collections.emptyList();
    }

    private AnalyzedToken getNoInfoToken(String word) {
        return new AnalyzedToken(word, null, null);
    }

    private List<AnalyzedToken> getAnalyzedTokens(List<TaggedWord> taggedWords, String word) {
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            result.add(new AnalyzedToken(word, taggedWord.getPosTag(), taggedWord.getLemma()));
        }
        return result;
    }

    private List<AnalyzedToken> getAnalyzedTokens(List<TaggedWord> taggedWords, String word, List<String> compoundParts) {
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            if (taggedWord.getPosTag() != null && taggedWord.getPosTag().startsWith("VER:IMP")) continue;
            List<String> allButLastPart = compoundParts.subList(0, compoundParts.size() - 1);
            StringBuilder lemma = new StringBuilder();
            int i = 0;
            for (String s : allButLastPart) {
                lemma.append(i == 0 ? s : StringTools.lowercaseFirstChar((String)s));
                ++i;
            }
            lemma.append(StringTools.lowercaseFirstChar((String)taggedWord.getLemma()));
            result.add(new AnalyzedToken(word, taggedWord.getPosTag(), lemma.toString()));
        }
        return result;
    }

    static {
        for (String nomAkkGenDat : Arrays.asList("NOM", "AKK", "GEN", "DAT")) {
            for (String pluSin : Arrays.asList("PLU", "SIN")) {
                for (String masFemNeu : Arrays.asList("MAS", "FEM", "NEU")) {
                    for (String defIndSol : Arrays.asList("DEF", "IND", "SOL")) {
                        allAdjGruTags.add("ADJ:" + nomAkkGenDat + ":" + pluSin + ":" + masFemNeu + ":GRU:" + defIndSol);
                    }
                }
            }
        }
        nounTagExpansionExceptions = Arrays.asList("Wegstrecken");
        prefixesSeparableVerbs = new String[]{"gegeneinander", "durcheinander", "nebeneinander", "\u00fcbereinander", "aufeinander", "auseinander", "beieinander", "aneinander", "ineinander", "zueinander", "gegen\u00fcber", "beisammen", "gegen\u00fcber", "hernieder", "r\u00fcckw\u00e4rts", "wiederauf", "wiederein", "wiederher", "zufrieden", "zwangsvor", "entgegen", "hinunter", "abhanden", "aufrecht", "aufw\u00e4rts", "ausw\u00e4rts", "beiseite", "danieder", "drauflos", "einw\u00e4rts", "herunter", "hindurch", "verr\u00fcckt", "vorw\u00e4rts", "zunichte", "zusammen", "zwangsum", "zwischen", "abseits", "abw\u00e4rts", "entlang", "hinfort", "\u00e4hnlich", "daneben", "general", "her\u00fcber", "hierher", "hierhin", "hin\u00fcber", "schwarz", "trocken", "\u00fcberein", "vorlieb", "vor\u00fcber", "wichtig", "zurecht", "zuwider", "hinweg", "allein", "besser", "daheim", "doppel", "feinst", "fertig", "herauf", "heraus", "herbei", "hinauf", "hinaus", "hinein", "kaputt", "kennen", "k\u00fcrzer", "mittag", "nieder", "runter", "sicher", "sitzen", "voraus", "vorbei", "vorweg", "weiter", "wieder", "zugute", "zur\u00fcck", "zwangs", "abend", "blank", "brust", "dahin", "davon", "drauf", "drein", "durch", "einig", "empor", "grund", "herum", "h\u00f6her", "klein", "knapp", "krank", "krumm", "kugel", "n\u00e4her", "neben", "offen", "preis", "r\u00fcber", "ruhig", "statt", "still", "\u00fcbrig", "umher", "unter", "voran", "zweck", "acht", "drei", "fehl", "feil", "fort", "frei", "gro\u00df", "hand", "hart", "heim", "hier", "hoch", "klar", "lahm", "miss", "nach", "nahe", "quer", "rauf", "raus", "rein", "r\u00fcck", "satt", "sto\u00df", "teil", "\u00fcber", "voll", "wach", "wahr", "warm", "wert", "wohl", "auf", "aus", "bei", "ehe", "ein", "eis", "end", "her", "hin", "los", "ma\u00df", "mit", "out", "ran", "rum", "tot", "vor", "weg", "weh", "ab", "an", "da", "um", "zu"};
        prefixesNonSeparableVerbs = new String[]{"be", "emp", "ent", "er", "hinter", "miss", "un", "ver", "zer"};
        prefixesVerbs = new String[]{"gegeneinander", "durcheinander", "nebeneinander", "\u00fcbereinander", "aufeinander", "auseinander", "beieinander", "aneinander", "ineinander", "zueinander", "gegen\u00fcber", "beisammen", "gegen\u00fcber", "hernieder", "r\u00fcckw\u00e4rts", "wiederauf", "wiederein", "wiederher", "zufrieden", "zwangsvor", "entgegen", "hinunter", "abhanden", "aufrecht", "aufw\u00e4rts", "ausw\u00e4rts", "beiseite", "danieder", "drauflos", "einw\u00e4rts", "herunter", "hindurch", "verr\u00fcckt", "vorw\u00e4rts", "zunichte", "zusammen", "zwangsum", "zwischen", "abseits", "abw\u00e4rts", "entlang", "hinfort", "\u00e4hnlich", "daneben", "general", "her\u00fcber", "hierher", "hierhin", "hin\u00fcber", "schwarz", "trocken", "\u00fcberein", "vorlieb", "vor\u00fcber", "wichtig", "zurecht", "zuwider", "hinweg", "hinter", "allein", "besser", "daheim", "doppel", "feinst", "fertig", "herauf", "heraus", "herbei", "hinauf", "hinaus", "hinein", "kaputt", "kennen", "k\u00fcrzer", "mittag", "nieder", "runter", "sicher", "sitzen", "voraus", "vorbei", "vorweg", "weiter", "wieder", "zugute", "zur\u00fcck", "zwangs", "abend", "blank", "brust", "dahin", "davon", "drauf", "drein", "durch", "einig", "empor", "grund", "herum", "h\u00f6her", "klein", "knapp", "krank", "krumm", "kugel", "n\u00e4her", "neben", "offen", "preis", "r\u00fcber", "ruhig", "statt", "still", "\u00fcbrig", "umher", "unter", "voran", "zweck", "miss", "acht", "drei", "fehl", "feil", "fort", "frei", "gro\u00df", "hand", "hart", "heim", "hier", "hoch", "klar", "lahm", "miss", "nach", "nahe", "quer", "rauf", "raus", "rein", "r\u00fcck", "satt", "sto\u00df", "teil", "\u00fcber", "voll", "wach", "wahr", "warm", "wert", "wohl", "emp", "ent", "ver", "zer", "auf", "aus", "bei", "ehe", "ein", "eis", "end", "her", "hin", "los", "ma\u00df", "mit", "out", "ran", "rum", "tot", "vor", "weg", "weh", "be", "er", "un", "ab", "an", "da", "um", "zu"};
        partizip2contains1PluPra = new String[]{"blasen", "fahren", "fallen", "fangen", "fressen", "geben", "halten", "kommen", "laden", "lassen", "laufen", "lesen", "messen", "raten", "schlafen", "schlagen", "sehen", "tragen", "treten"};
        partizip2contains1PluPrt = new String[]{"bieten", "bleiben", "fliegen", "flie\u00dfen", "heben", "leiden", "meiden", "scheiden", "schlie\u00dfen", "schreiben", "stehen", "steigen", "streiten", "treiben", "weisen", "ziehen"};
        postagsPartizipEndingE = new String[]{"AKK:PLU:FEM:GRU:SOL:VER", "AKK:PLU:MAS:GRU:SOL:VER", "AKK:PLU:NEU:GRU:SOL:VER", "AKK:SIN:FEM:GRU:DEF:VER", "AKK:SIN:FEM:GRU:IND:VER", "AKK:SIN:FEM:GRU:SOL:VER", "AKK:SIN:NEU:GRU:DEF:VER", "NOM:PLU:FEM:GRU:SOL:VER", "NOM:PLU:MAS:GRU:SOL:VER", "NOM:PLU:NEU:GRU:SOL:VER", "NOM:SIN:FEM:GRU:DEF:VER", "NOM:SIN:FEM:GRU:IND:VER", "NOM:SIN:FEM:GRU:SOL:VER", "NOM:SIN:MAS:GRU:DEF:VER", "NOM:SIN:NEU:GRU:DEF:VER"};
        postagsPartizipEndingEm = new String[]{"DAT:SIN:MAS:GRU:SOL:VER", "DAT:SIN:NEU:GRU:SOL:VER"};
        postagsPartizipEndingEn = new String[]{"AKK:PLU:FEM:GRU:DEF:VER", "AKK:PLU:FEM:GRU:IND:VER", "AKK:PLU:MAS:GRU:DEF:VER", "AKK:PLU:MAS:GRU:IND:VER", "AKK:PLU:NEU:GRU:DEF:VER", "AKK:PLU:NEU:GRU:IND:VER", "AKK:SIN:MAS:GRU:DEF:VER", "AKK:SIN:MAS:GRU:IND:VER", "AKK:SIN:MAS:GRU:SOL:VER", "DAT:PLU:FEM:GRU:DEF:VER", "DAT:PLU:FEM:GRU:IND:VER", "DAT:PLU:FEM:GRU:SOL:VER", "DAT:PLU:MAS:GRU:DEF:VER", "DAT:PLU:MAS:GRU:IND:VER", "DAT:PLU:MAS:GRU:SOL:VER", "DAT:PLU:NEU:GRU:DEF:VER", "DAT:PLU:NEU:GRU:IND:VER", "DAT:PLU:NEU:GRU:SOL:VER", "DAT:SIN:FEM:GRU:DEF:VER", "DAT:SIN:FEM:GRU:IND:VER", "DAT:SIN:MAS:GRU:DEF:VER", "DAT:SIN:MAS:GRU:IND:VER", "DAT:SIN:NEU:GRU:DEF:VER", "DAT:SIN:NEU:GRU:IND:VER", "GEN:PLU:FEM:GRU:DEF:VER", "GEN:PLU:FEM:GRU:IND:VER", "GEN:PLU:MAS:GRU:DEF:VER", "GEN:PLU:MAS:GRU:IND:VER", "GEN:PLU:NEU:GRU:DEF:VER", "GEN:PLU:NEU:GRU:IND:VER", "GEN:SIN:FEM:GRU:DEF:VER", "GEN:SIN:FEM:GRU:IND:VER", "GEN:SIN:MAS:GRU:DEF:VER", "GEN:SIN:MAS:GRU:IND:VER", "GEN:SIN:MAS:GRU:SOL:VER", "GEN:SIN:NEU:GRU:DEF:VER", "GEN:SIN:NEU:GRU:IND:VER", "GEN:SIN:NEU:GRU:SOL:VER", "NOM:PLU:FEM:GRU:DEF:VER", "NOM:PLU:FEM:GRU:IND:VER", "NOM:PLU:MAS:GRU:DEF:VER", "NOM:PLU:MAS:GRU:IND:VER", "NOM:PLU:NEU:GRU:DEF:VER", "NOM:PLU:NEU:GRU:IND:VER"};
        postagsPartizipEndingEr = new String[]{"DAT:SIN:FEM:GRU:SOL:VER", "GEN:PLU:FEM:GRU:SOL:VER", "GEN:PLU:MAS:GRU:SOL:VER", "GEN:PLU:NEU:GRU:SOL:VER", "GEN:SIN:FEM:GRU:SOL:VER", "NOM:SIN:MAS:GRU:IND:VER", "NOM:SIN:MAS:GRU:SOL:VER", "DAT:SIN:FEM:GRU:SOL:VER", "GEN:PLU:FEM:GRU:SOL:VER", "GEN:PLU:MAS:GRU:SOL:VER", "GEN:PLU:NEU:GRU:SOL:VER", "GEN:SIN:FEM:GRU:SOL:VER", "NOM:SIN:MAS:GRU:IND:VER", "NOM:SIN:MAS:GRU:SOL:VER"};
        postagsPartizipEndingEs = new String[]{"AKK:SIN:NEU:GRU:IND:VER", "AKK:SIN:NEU:GRU:SOL:VER", "NOM:SIN:NEU:GRU:IND:VER", "NOM:SIN:NEU:GRU:SOL:VER"};
        notAVerb = new String[]{"angebot", "anteil", "aufenthalt", "ausdruck", "ausw\u00e4rtsspiel", "beispiel", "bereich", "besondere", "daring", "einfach", "einfachst", "endkasten", "freibetrag", "graut\u00f6ne", "gr\u00fcnt\u00f6ne", "gro\u00dfherz\u00f6ge", "gro\u00dfteil", "hochhaus", "klarerweise", "ma\u00dfnahme", "mitglieder", "nachricht", "nebenfach", "niederlage", "nothing", "notscheid", "preisver", "reinwei\u00df", "schwarzwei\u00df", "schwarzgrau", "schwarzgr\u00fcn", "schwarzt\u00f6ne", "unbesiegt", "unmenge", "unrat", "unver", "verr\u00fcckterweise", "versonnen", "vorlieb", "vorteil", "warmwei\u00df", "wohldefiniert", "wohlergehen", "wohlgemerkt", "zuende", "zuhause", "zumal", "zuver", "darauf", "einmal", "kleinkram", "hochsicher", "ehering", "freitag", "gro\u00dfmeister", "handwerk", "herpes", "nachfolger"};
        tagsForWeise = new ArrayList<String>();
        tagsForWeise.add("ADJ:AKK:PLU:FEM:GRU:SOL");
        tagsForWeise.add("ADJ:AKK:PLU:MAS:GRU:SOL");
        tagsForWeise.add("ADJ:AKK:PLU:NEU:GRU:SOL");
        tagsForWeise.add("ADJ:AKK:SIN:FEM:GRU:DEF");
        tagsForWeise.add("ADJ:AKK:SIN:FEM:GRU:IND");
        tagsForWeise.add("ADJ:AKK:SIN:FEM:GRU:SOL");
        tagsForWeise.add("ADJ:AKK:SIN:NEU:GRU:DEF");
        tagsForWeise.add("ADJ:NOM:PLU:FEM:GRU:SOL");
        tagsForWeise.add("ADJ:NOM:PLU:MAS:GRU:SOL");
        tagsForWeise.add("ADJ:NOM:PLU:NEU:GRU:SOL");
        tagsForWeise.add("ADJ:NOM:SIN:FEM:GRU:DEF");
        tagsForWeise.add("ADJ:NOM:SIN:FEM:GRU:IND");
        tagsForWeise.add("ADJ:NOM:SIN:FEM:GRU:SOL");
        tagsForWeise.add("ADJ:NOM:SIN:MAS:GRU:DEF");
        tagsForWeise.add("ADJ:NOM:SIN:NEU:GRU:DEF");
        tagsForWeise.add("ADJ:PRD:GRU");
        expansionInfos = Suppliers.memoize(GermanTagger::initExpansionInfos);
        INSTANCE = new GermanTagger();
    }

    static class ExpansionInfos {
        Map<String, PrefixInfixVerb> verbInfos;
        Map<String, NominalizedVerb> nominalizedVerbInfos;
        Map<String, NominalizedGenitiveVerb> nominalizedGenVerbInfos;
        Map<String, List<AdjInfo>> adjInfos;

        ExpansionInfos(Map<String, PrefixInfixVerb> verbInfos, Map<String, NominalizedVerb> nominalizedVerbInfos, Map<String, NominalizedGenitiveVerb> nominalizedGenVerbInfos, Map<String, List<AdjInfo>> adjInfos) {
            this.verbInfos = verbInfos;
            this.nominalizedVerbInfos = nominalizedVerbInfos;
            this.nominalizedGenVerbInfos = nominalizedGenVerbInfos;
            this.adjInfos = adjInfos;
        }
    }

    static class NominalizedGenitiveVerb {
        String prefix;
        String verbBaseform;

        NominalizedGenitiveVerb(String prefix, String verbBaseform) {
            this.prefix = prefix;
            this.verbBaseform = verbBaseform;
        }
    }

    static class NominalizedVerb {
        String prefix;
        String verbBaseform;

        NominalizedVerb(String prefix, String verbBaseform) {
            this.prefix = prefix;
            this.verbBaseform = verbBaseform;
        }
    }

    static class AdjInfo {
        String baseform;
        String fullForm;
        String tag;

        AdjInfo(String baseform, String fullForm, String tag) {
            this.baseform = baseform;
            this.fullForm = fullForm;
            this.tag = tag;
        }
    }

    static class PrefixInfixVerb {
        String prefix;
        String infix;
        String verbBaseform;

        PrefixInfixVerb(String prefix, String infix, String verbBaseform) {
            this.prefix = prefix;
            this.infix = infix;
            this.verbBaseform = verbBaseform;
        }
    }
}

