/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStatisticSentenceStyleRule;

public class SentenceWithModalVerbRule
extends AbstractStatisticSentenceStyleRule {
    private static final int DEFAULT_MIN_PERCENT = 18;
    String sentenceMessage = null;

    public SentenceWithModalVerbRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 18);
    }

    private static boolean isModalVerb(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("VER:MOD");
    }

    protected AnalyzedTokenReadings conditionFulfilled(List<AnalyzedTokenReadings> sentence) {
        for (int i = 0; i < sentence.size(); ++i) {
            if (SentenceWithModalVerbRule.isModalVerb(sentence.get(i))) {
                AnalyzedTokenReadings token = sentence.get(i);
                ++i;
                while (i < sentence.size()) {
                    if (sentence.get(i).hasPosTagStartingWith("VER:INF")) {
                        return token;
                    }
                    if (this.isMark(sentence.get(i))) {
                        return null;
                    }
                    ++i;
                }
                continue;
            }
            if (!sentence.get(i).hasPosTagStartingWith("VER:INF")) continue;
            ++i;
            while (i < sentence.size()) {
                if (SentenceWithModalVerbRule.isModalVerb(sentence.get(i))) {
                    return sentence.get(i);
                }
                if (this.isMark(sentence.get(i))) {
                    return null;
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean excludeDirectSpeech() {
        return true;
    }

    protected String getLimitMessage(int limit, double percent) {
        if (limit == 0) {
            return "Modalverb: Modalverben bl\u00e4hen den Text h\u00e4ufig auf und sollten vermieden werden.";
        }
        return "Mehr als " + limit + "% S\u00e4tze mit Modalverben {" + (int)(percent + 0.5) + "%} gefunden. Modalverben bl\u00e4hen den Text h\u00e4ufig auf und sollten vermieden werden.";
    }

    public String getId() {
        return "SENTENCE_WITH_MODAL_VERB_DE";
    }

    public String getDescription() {
        return "Statistische Stilanalyse: S\u00e4tze mit Modalverben";
    }

    public String getConfigureText() {
        return "Anzeigen wenn mehr als ...% S\u00e4tze eines Kapitels Modalverben enthalten:";
    }
}

