/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.ngrams.ConfusionProbabilityRule;

public class GermanConfusionProbabilityRule
extends ConfusionProbabilityRule {
    private static final List<Pattern> SENTENCE_EXCEPTION_PATTERNS = Arrays.asList(Pattern.compile("wir \\("), Pattern.compile("Wie .*?en Sie"), Pattern.compile("fiel(e|en)? .* (aus|auf)"));
    private static final List<String> EXCEPTIONS = Arrays.asList("viel hin und her", "m\u00f6glichkeit wei\u00dft", "du doch trotzdem", "wir stark ausgelastet sind", "wir entwickeln f\u00fcr", "nutzen wir Google", "vertreiben wir", "wir auch nicht", ", dir bei", "fiel hinaus", "setz dir", "du hast dir", "vielen als held", "seht gut", "so viel das", "wie erinnern sie sich", "d\u00fcrfen wir nicht", "kann dich auch", "wie schicken wir", "wie benutzen sie", "wir ja nicht", "wie wir oder", "eine uhrzeit hatten", "damit wir das", "damit wir die", "damit wir dir", "was wird in", "warum wird da", "da mir der", "das wir uns", "so wir k\u00f6nnen", "bestellt Botschafter ein", "bestellt Botschafterin ein", "wie zahlen sie", "unser business", "journalisten gefiltert worden", "f\u00fcr uns filtern", "leinwand gezeigte", "war sich f\u00fcr nichts", "dover corporation", "bringt dich ein", "bringt dich eine", "womit arbeitet", "womit arbeiten", "ich drei bin", "was wird unser", "die wird wieder", "damit wir f\u00fcr", "wie finden sie", "ach die armen", "wie stehen da die", "wir w\u00fcrden sie", "damit wir ihre daten", "kannst du doch gerne", "wie ist hier der Stand", "wie ist der Stand", "dass da Potenzial zu", "das auch hergibt", "hat mich angeschrieben", "sehe gerade", "hole dich auch ab", "w\u00fcrdest du dich vorstellen", "daten wir \u00fcber", "anders seht", "weit fallendem", "weit fallenden", "weit fallendes", "weit fallende", "weit fallender", "wir ja.", "wei\u00dft, wie", "wei\u00dft ja, wie", "wei\u00dft, dass", "wei\u00dft ja, dass", "Vorgestern und Gestern");

    public GermanConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public GermanConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        super(messages, languageModel, language, grams, EXCEPTIONS);
        this.addExamplePair(Example.wrong((String)"W\u00e4hrend Sie das Ganze <marker>mir</marker> einem Holzl\u00f6ffel r\u00fchren\u2026"), Example.fixed((String)"W\u00e4hrend Sie das Ganze <marker>mit</marker> einem Holzl\u00f6ffel r\u00fchren\u2026"));
    }

    protected boolean isException(String sentenceText, int startPos, int endPos) {
        for (Pattern pattern : SENTENCE_EXCEPTION_PATTERNS) {
            Matcher m = pattern.matcher(sentenceText);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    protected boolean isCommonWord(String token) {
        return token.matches("[\\w\u00f6\u00e4\u00fc\u00df\u00d6\u00c4\u00dc]+");
    }
}

