/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.synthesis.BaseSynthesizer;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanSynthesizer
extends BaseSynthesizer {
    public static final GermanSynthesizer INSTANCE = new GermanSynthesizer(Languages.getLanguageForShortCode((String)"de-DE"));
    private static final Set<String> REMOVE = new HashSet<String>(Arrays.asList("unsren", "unsrem", "unsres", "unsre", "unsern", "unserm", "unsrer"));

    public GermanSynthesizer(Language lang) {
        super("de/de.sor", "/de/german_synth.dict", "/de/german_tags.txt", lang);
    }

    protected List<String> lookup(String lemma, String posTag) {
        List lookup = super.lookup(lemma, posTag);
        ArrayList<String> results = new ArrayList<String>();
        for (String s : lookup) {
            boolean lcLookup;
            boolean lcLemma = StringTools.startsWithLowercase((String)lemma);
            if (lcLemma != (lcLookup = StringTools.startsWithLowercase((String)s)) && !lemma.equals("mein") && (!lemma.equals("ich") || REMOVE.contains(s))) continue;
            results.add(s);
        }
        return results;
    }

    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        String[] result = super.synthesize(token, posTag);
        if (result.length == 0) {
            return this.getCompoundForms(token, posTag, false);
        }
        return (String[])Arrays.stream(result).filter(k -> !REMOVE.contains(k)).toArray(String[]::new);
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        String[] result = super.synthesize(token, posTag, posTagRegExp);
        if (result.length == 0) {
            return this.getCompoundForms(token, posTag, posTagRegExp);
        }
        return (String[])Arrays.stream(result).filter(k -> !REMOVE.contains(k)).toArray(String[]::new);
    }

    @NotNull
    private String[] getCompoundForms(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        List<String> parts = GermanCompoundTokenizer.getStrictInstance().tokenize(token.getLemma());
        if (parts.size() == 0) {
            return parts.toArray(new String[0]);
        }
        String maybeHyphen = "";
        if (parts.size() == 1 && token.getLemma() != null && (parts = Arrays.asList(token.getLemma().split("-"))).size() > 1) {
            maybeHyphen = "-";
        }
        String firstPart = String.join((CharSequence)maybeHyphen, parts.subList(0, parts.size() - 1));
        String lastPart = StringTools.uppercaseFirstChar((String)parts.get(parts.size() - 1));
        boolean uppercaseLastPart = !maybeHyphen.equals("") && StringTools.startsWithUppercase((String)parts.get(parts.size() - 1));
        AnalyzedToken lastPartToken = new AnalyzedToken(lastPart, posTag, lastPart);
        String[] lastPartForms = posTagRegExp ? super.synthesize(lastPartToken, posTag, true) : super.synthesize(lastPartToken, posTag);
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        for (String part : lastPartForms) {
            if (uppercaseLastPart) {
                results.add(firstPart + maybeHyphen + part);
                continue;
            }
            results.add(firstPart + maybeHyphen + StringTools.lowercaseFirstChar((String)part));
        }
        return results.toArray(new String[0]);
    }
}

