/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.PrepositionToCases;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

class AgreementSuggestor2 {
    private static final String detTemplate = "ART:IND/DEF:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU";
    private static final String proPosTemplate = "PRO:POS:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU:BEG";
    private static final List<String> proDemTemplates = Arrays.asList("PRO:DEM:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU:BEG", "PRO:DEM:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU:B/S");
    private static final List<String> proIndTemplates = Arrays.asList("PRO:IND:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU:BEG", "PRO:IND:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU:B/S");
    private static final String adjTemplate = "ADJ:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU:GRU:IND/DEF";
    private static final String pa1Template = "PA1:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU:GRU:IND/DEF:VER";
    private static final String pa2Template = "PA2:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU:GRU:IND/DEF:VER";
    private static final List<String> nounTemplates = Arrays.asList("SUB:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU", "SUB:NOM/AKK/DAT/GEN:SIN/PLU:MAS/FEM/NEU:INF");
    private static final List<String> number = Arrays.asList("SIN", "PLU");
    private static final List<String> gender = Arrays.asList("MAS", "FEM", "NEU");
    private static final List<String> cases = Arrays.asList("NOM", "AKK", "DAT", "GEN");
    private static final List<String> nounCases = Arrays.asList("NOM", "AKK", "DAT", "GEN");
    private final Synthesizer synthesizer;
    private final AnalyzedTokenReadings determinerToken;
    private final AnalyzedTokenReadings adjToken1;
    private final AnalyzedTokenReadings adjToken2;
    private final AnalyzedTokenReadings nounToken;
    private final AgreementRule.ReplacementType replacementType;
    private final String origPhrase;
    private AnalyzedTokenReadings prepositionToken;
    private String skippedStr;

    AgreementSuggestor2(Synthesizer synthesizer, AnalyzedTokenReadings determinerToken, AnalyzedTokenReadings nounToken, AgreementRule.ReplacementType replacementType) {
        this(synthesizer, determinerToken, null, nounToken, replacementType);
    }

    AgreementSuggestor2(Synthesizer synthesizer, AnalyzedTokenReadings determinerToken, AnalyzedTokenReadings adjToken1, AnalyzedTokenReadings nounToken, AgreementRule.ReplacementType replacementType) {
        this(synthesizer, determinerToken, adjToken1, null, nounToken, replacementType);
    }

    AgreementSuggestor2(Synthesizer synthesizer, AnalyzedTokenReadings determinerToken, AnalyzedTokenReadings adjToken1, AnalyzedTokenReadings adjToken2, AnalyzedTokenReadings nounToken, AgreementRule.ReplacementType replacementType) {
        this.synthesizer = synthesizer;
        this.determinerToken = determinerToken;
        this.adjToken1 = adjToken1;
        this.adjToken2 = adjToken2;
        this.nounToken = nounToken;
        this.replacementType = replacementType;
        this.origPhrase = this.getOrigPhrase();
    }

    void setPreposition(AnalyzedTokenReadings prep) {
        this.prepositionToken = prep;
    }

    public void setSkipped(String skippedStr) {
        this.skippedStr = skippedStr;
    }

    List<String> getSuggestions() {
        return this.getSuggestions(false);
    }

    List<String> getSuggestions(boolean filter) {
        if (this.replacementType == AgreementRule.ReplacementType.Zur) {
            this.prepositionToken = new AnalyzedTokenReadings(new AnalyzedToken("zu", "", "zu"));
        } else if (this.replacementType == AgreementRule.ReplacementType.Ins) {
            this.prepositionToken = new AnalyzedTokenReadings(new AnalyzedToken("in", "", "zu"));
        }
        try {
            List<Suggestion> suggestions = this.getSuggestionsInternal();
            Collections.sort(suggestions);
            this.addContraction(suggestions);
            if (filter) {
                ArrayList<Suggestion> filteredSuggestions = new ArrayList<Suggestion>();
                int prevCorrections = suggestions.size() > 0 ? suggestions.get((int)0).tokenLevelEdits : 0;
                boolean hadRealSuggestions = false;
                for (Suggestion suggestion : suggestions) {
                    if (hadRealSuggestions && suggestion.tokenLevelEdits > prevCorrections) break;
                    hadRealSuggestions = suggestion.tokenLevelEdits > 0;
                    filteredSuggestions.add(suggestion);
                }
                return filteredSuggestions.stream().map(k -> k.phrase).collect(Collectors.toList());
            }
            return suggestions.stream().map(k -> k.phrase).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addContraction(List<Suggestion> suggestions) {
        if (this.replacementType == AgreementRule.ReplacementType.Zur) {
            suggestions.forEach(k -> {
                if (k.phrase.startsWith("der")) {
                    k.phrase = k.phrase.replaceFirst("der", "zur");
                } else if (k.phrase.startsWith("den")) {
                    k.phrase = k.phrase.replaceFirst("den", "zu");
                } else if (k.phrase.startsWith("dem")) {
                    k.phrase = k.phrase.replaceFirst("dem", "zum");
                }
            });
        } else if (this.replacementType == AgreementRule.ReplacementType.Ins) {
            Iterator<Suggestion> iterator = suggestions.iterator();
            while (iterator.hasNext()) {
                Suggestion s = iterator.next();
                if (s.phrase.startsWith("das")) {
                    s.phrase = s.phrase.replaceFirst("das", "ins");
                    continue;
                }
                if (s.phrase.startsWith("dem")) {
                    s.phrase = s.phrase.replaceFirst("dem", "im");
                    continue;
                }
                if (s.phrase.startsWith("den")) {
                    s.phrase = s.phrase.replaceFirst("den", "in den");
                    continue;
                }
                if (s.phrase.startsWith("die")) {
                    s.phrase = s.phrase.replaceFirst("die", "in die");
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private List<Suggestion> getSuggestionsInternal() throws IOException {
        List<String> nounCases = this.getNounCases();
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (String num : number) {
            for (String gen : gender) {
                for (String aCase : cases) {
                    if (!nounCases.contains(aCase)) continue;
                    for (AnalyzedToken detReading : this.determinerToken.getReadings()) {
                        String[] detSynthesized = this.getDetOrPronounSynth(num, gen, aCase, detReading);
                        String[] adj1Synthesized = this.getAdjSynth(num, gen, aCase, this.adjToken1, detReading);
                        String[] adj2Synthesized = this.getAdjSynth(num, gen, aCase, this.adjToken2, detReading);
                        String[] nounSynthesized = this.getNounSynth(num, gen, aCase);
                        this.combineSynth(result, detSynthesized, adj1Synthesized, adj2Synthesized, nounSynthesized);
                    }
                }
            }
        }
        return result;
    }

    private List<String> getNounCases() {
        if (this.prepositionToken != null) {
            ArrayList<String> result = new ArrayList<String>();
            List<PrepositionToCases.Case> casesForToken = PrepositionToCases.getCasesFor(this.prepositionToken.getToken());
            if (casesForToken.size() > 0) {
                for (PrepositionToCases.Case aCase : casesForToken) {
                    String val = aCase.name().toLowerCase();
                    if (result.contains(val)) continue;
                    result.add(val.toUpperCase());
                }
                return result;
            }
        }
        return nounCases;
    }

    private String[] getDetOrPronounSynth(String num, String gen, String aCase, AnalyzedToken detReading) throws IOException {
        List<String> templates;
        String detPos = detReading.getPOSTag();
        if (detPos == null) {
            return new String[0];
        }
        boolean isDef = detPos.contains(":DEF:");
        if (detPos.contains("ART:")) {
            templates = Collections.singletonList(detTemplate);
        } else if (detPos.contains("PRO:POS:")) {
            templates = Collections.singletonList(proPosTemplate);
        } else if (detPos.contains("PRO:DEM:")) {
            templates = proDemTemplates;
        } else if (detPos.contains("PRO:IND:")) {
            templates = proIndTemplates;
        } else if (detReading.getToken().equals("zur")) {
            templates = Collections.singletonList(detTemplate);
            detReading = new AnalyzedToken("der", "", "der");
            isDef = true;
        } else if (detReading.getToken().equals("ins")) {
            templates = Collections.singletonList(detTemplate);
            detReading = new AnalyzedToken("das", "", "der");
            isDef = true;
        } else {
            return new String[0];
        }
        ArrayList synthesized = new ArrayList();
        for (String template : templates) {
            template = template.replaceFirst("IND/DEF", isDef ? "DEF" : "IND");
            String pos = this.replaceVars(template, num, gen, aCase);
            String[] tmp = this.synthesizer.synthesize(detReading, pos);
            String origFirstChar = detReading.getToken().substring(0, 1);
            synthesized.addAll(Arrays.stream(tmp).filter(k -> k.toLowerCase().startsWith(origFirstChar.toLowerCase())).map(k -> Character.isUpperCase(origFirstChar.charAt(0)) ? StringTools.uppercaseFirstChar((String)k) : k).collect(Collectors.toList()));
        }
        return synthesized.toArray(new String[0]);
    }

    private String[] getAdjSynth(String num, String gen, String aCase, AnalyzedTokenReadings adjToken, AnalyzedToken detReading) throws IOException {
        ArrayList<String> adjSynthesized = new ArrayList<String>();
        if (adjToken != null) {
            for (AnalyzedToken adjReading : adjToken.getReadings()) {
                String[] synthesize;
                boolean detIsDef;
                if (adjReading.getPOSTag() == null || detReading.getPOSTag() == null || adjReading.getToken().equals("meisten") && num.equals("SIN")) continue;
                if (adjReading.getPOSTag().startsWith("ADV:")) {
                    adjSynthesized.add(adjReading.getToken());
                    continue;
                }
                boolean bl = detIsDef = detReading.getPOSTag().contains(":DEF:") || detReading.getToken().equals("ins");
                String template = adjReading.getPOSTag().startsWith("PA1") ? pa1Template : (adjReading.getPOSTag().startsWith("PA2") ? pa2Template : adjTemplate);
                if (adjReading.getPOSTag().contains(":KOM:")) {
                    template = template.replace(":GRU:", ":KOM:");
                } else if (adjReading.getPOSTag().contains(":SUP:")) {
                    template = template.replace(":GRU:", ":SUP:");
                }
                template = template.replaceFirst("IND/DEF", detIsDef ? "DEF" : "IND");
                String adjPos = this.replaceVars(template, num, gen, aCase);
                for (String synthNoun : synthesize = this.synthesizer.synthesize(adjReading, adjPos)) {
                    if (adjSynthesized.contains(synthNoun)) continue;
                    adjSynthesized.add(synthNoun);
                }
            }
        } else {
            adjSynthesized.add("");
        }
        return adjSynthesized.toArray(new String[0]);
    }

    private String[] getNounSynth(String num, String gen, String aCase) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (AnalyzedToken nounReading : this.nounToken.getReadings()) {
            for (String nounTemplate : nounTemplates) {
                String nounPos = this.replaceVars(nounTemplate, num, gen, aCase);
                String[] nounSynthesized = this.synthesizer.synthesize(nounReading, nounPos);
                if (nounSynthesized.length == 0 && nounReading.getToken().contains("-")) {
                    String firstPart = nounReading.getToken().substring(0, nounReading.getToken().lastIndexOf(45) + 1);
                    String lastTokenPart = this.nounToken.getToken().replaceFirst(".*-", "");
                    String lastLemmaPart = nounReading.getLemma() != null ? nounReading.getLemma().replaceFirst(".*-", "") : null;
                    for (String lastPartInflected : nounSynthesized = this.synthesizer.synthesize(new AnalyzedToken(lastTokenPart, "fake_value", lastLemmaPart), nounPos)) {
                        result.add(firstPart + lastPartInflected);
                    }
                    continue;
                }
                result.addAll(Arrays.asList(nounSynthesized));
            }
        }
        Set oldSpelling = result.stream().filter(k -> k.contains("ss")).map(k -> k.replace("ss", "\u00df")).collect(Collectors.toSet());
        return (String[])result.stream().filter(k -> !oldSpelling.contains(k)).toArray(String[]::new);
    }

    private void combineSynth(List<Suggestion> result, String[] detSynthesized, String[] adj1Synthesized, String[] adj2Synthesized, String[] nounSynthesized) {
        for (String detSynthesizedElem : detSynthesized) {
            for (String adj1SynthesizedElem : adj1Synthesized) {
                for (String adj2SynthesizedElem : adj2Synthesized) {
                    for (String nounSynthesizedElem : nounSynthesized) {
                        Integer charLevelEdits;
                        Suggestion suggestion;
                        String elem = detSynthesizedElem;
                        if (this.skippedStr != null) {
                            elem = elem + " " + this.skippedStr;
                        }
                        if (!adj1SynthesizedElem.isEmpty()) {
                            elem = elem + " " + adj1SynthesizedElem;
                        }
                        if (!adj2SynthesizedElem.isEmpty()) {
                            elem = elem + " " + adj2SynthesizedElem;
                        }
                        elem = elem + " " + nounSynthesizedElem;
                        int edits = (detSynthesizedElem.equals(this.determinerToken.getToken()) ? 0 : 1) + (this.adjToken1 == null || adj1SynthesizedElem.equals(this.adjToken1.getToken()) ? 0 : 1) + (this.adjToken2 == null || adj2SynthesizedElem.equals(this.adjToken2.getToken()) ? 0 : 1) + (nounSynthesizedElem.equals(this.nounToken.getToken()) ? 0 : 1);
                        if (edits == 0 || result.contains(suggestion = new Suggestion(elem, edits, charLevelEdits = LevenshteinDistance.getDefaultInstance().apply((CharSequence)elem, (CharSequence)this.origPhrase)))) continue;
                        result.add(suggestion);
                    }
                }
            }
        }
    }

    @NotNull
    private String getOrigPhrase() {
        String origElem = this.determinerToken.getToken();
        if (this.adjToken1 != null) {
            origElem = origElem + " " + this.adjToken1.getToken();
        }
        if (this.adjToken2 != null) {
            origElem = origElem + " " + this.adjToken2.getToken();
        }
        origElem = origElem + " " + this.nounToken.getToken();
        return origElem;
    }

    private String replaceVars(String template, String num, String gen, String aCase) {
        return template.replaceFirst("SIN/PLU", num).replaceFirst("MAS/FEM/NEU", gen).replaceFirst("NOM/AKK/DAT/GEN", aCase);
    }

    private static class Suggestion
    implements Comparable<Suggestion> {
        String phrase;
        int tokenLevelEdits;
        int charLevelCorrections;

        Suggestion(String phrase, int tokenLevelEdits, int charLevelEdits) {
            this.phrase = Objects.requireNonNull(phrase);
            this.tokenLevelEdits = tokenLevelEdits;
            this.charLevelCorrections = charLevelEdits;
        }

        @Override
        public int compareTo(@NotNull Suggestion o) {
            if (this.tokenLevelEdits == o.tokenLevelEdits) {
                return this.charLevelCorrections - o.charLevelCorrections;
            }
            return this.tokenLevelEdits - o.tokenLevelEdits;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Suggestion that = (Suggestion)o;
            return this.tokenLevelEdits == that.tokenLevelEdits && this.phrase.equals(that.phrase);
        }

        public int hashCode() {
            return Objects.hash(this.phrase, this.tokenLevelEdits);
        }

        public String toString() {
            return this.phrase + "/c=" + this.tokenLevelEdits;
        }
    }
}

