/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.de;

import com.google.common.base.Suppliers;
import de.danielnaber.jwordsplitter.EmbeddedGermanDictionary;
import de.danielnaber.jwordsplitter.GermanWordSplitter;
import de.danielnaber.jwordsplitter.InputTooLongException;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.languagetool.tokenizers.Tokenizer;

public class GermanCompoundTokenizer
implements Tokenizer {
    private static final Supplier<GermanCompoundTokenizer> strictInstance = Suppliers.memoize(() -> {
        try {
            return new GermanCompoundTokenizer(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    private static final Supplier<GermanCompoundTokenizer> nonStrictInstance = Suppliers.memoize(() -> {
        try {
            return new GermanCompoundTokenizer(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    private final ExtendedGermanWordSplitter wordSplitter = new ExtendedGermanWordSplitter(false);

    public GermanCompoundTokenizer() throws IOException {
        this(true);
    }

    public GermanCompoundTokenizer(boolean strictMode) throws IOException {
        this.wordSplitter.addException("Hallesche", Arrays.asList("Hallesche"));
        this.wordSplitter.addException("Halleschen", Arrays.asList("Halleschen"));
        this.wordSplitter.addException("Reinigungstab", Arrays.asList("Reinigungs", "tab"));
        this.wordSplitter.addException("Reinigungstabs", Arrays.asList("Reinigungs", "tabs"));
        this.wordSplitter.addException("Tauschwerte", Arrays.asList("Tausch", "werte"));
        this.wordSplitter.addException("Tauschwertes", Arrays.asList("Tausch", "wertes"));
        this.wordSplitter.addException("Kinderspielen", Arrays.asList("Kinder", "spielen"));
        this.wordSplitter.addException("Buchhaltungstrick", Arrays.asList("Buchhaltungs", "trick"));
        this.wordSplitter.addException("Buchhaltungstricks", Arrays.asList("Buchhaltungs", "tricks"));
        this.wordSplitter.setStrictMode(strictMode);
        this.wordSplitter.setMinimumWordLength(3);
    }

    public List<String> tokenize(String word) {
        try {
            return this.wordSplitter.splitWord(word);
        }
        catch (InputTooLongException e) {
            return Collections.singletonList(word);
        }
    }

    public static GermanCompoundTokenizer getStrictInstance() {
        return strictInstance.get();
    }

    public static GermanCompoundTokenizer getNonStrictInstance() {
        return nonStrictInstance.get();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: " + GermanCompoundTokenizer.class.getSimpleName() + " <wordsToSplit... or file>");
            System.exit(1);
        }
        GermanCompoundTokenizer tokenizer = new GermanCompoundTokenizer();
        if (new File(args[0]).exists()) {
            System.out.println("Working on lines from " + args[0] + ":");
            List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
            for (String line : lines) {
                System.out.println(tokenizer.tokenize(line));
            }
        } else {
            for (String arg : args) {
                System.out.println(tokenizer.tokenize(arg));
            }
        }
    }

    static class ExtendedGermanWordSplitter
    extends GermanWordSplitter {
        ExtendedGermanWordSplitter(boolean hideInterfixCharacters) throws IOException {
            super(hideInterfixCharacters, ExtendedGermanWordSplitter.extendedList());
        }

        static Set<String> extendedList() {
            THashSet words = new THashSet((Collection)EmbeddedGermanDictionary.getWords());
            words.add((Object)"synonym");
            words.trimToSize();
            return words;
        }
    }
}

