/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PrepositionToCases {
    private static final Map<String, List<Case>> prep2Cases = new HashMap<String, List<Case>>();

    private PrepositionToCases() {
    }

    private static void add(String prep, Case ... cases) {
        prep2Cases.put(prep, Arrays.asList(cases));
    }

    public static List<Case> getCasesFor(String prep) {
        return prep2Cases.getOrDefault(prep.toLowerCase(), new ArrayList());
    }

    static {
        PrepositionToCases.add("ab", Case.Dat);
        PrepositionToCases.add("abseits", Case.Gen);
        PrepositionToCases.add("abz\u00fcglich", Case.Gen);
        PrepositionToCases.add("an", Case.Dat, Case.Akk);
        PrepositionToCases.add("angesichts", Case.Gen);
        PrepositionToCases.add("anhand", Case.Gen);
        PrepositionToCases.add("anl\u00e4sslich", Case.Gen);
        PrepositionToCases.add("anstatt", Case.Gen);
        PrepositionToCases.add("anstelle", Case.Gen);
        PrepositionToCases.add("auf", Case.Dat, Case.Akk);
        PrepositionToCases.add("aufgrund", Case.Gen);
        PrepositionToCases.add("aus", Case.Dat);
        PrepositionToCases.add("ausgangs", Case.Gen);
        PrepositionToCases.add("ausgenommen", Case.Akk);
        PrepositionToCases.add("ausschlie\u00dflich", Case.Gen);
        PrepositionToCases.add("ausweislich", Case.Gen);
        PrepositionToCases.add("au\u00dfer", Case.Dat);
        PrepositionToCases.add("au\u00dferhalb", Case.Gen);
        PrepositionToCases.add("bar", Case.Gen);
        PrepositionToCases.add("behufs", Case.Gen);
        PrepositionToCases.add("bei", Case.Dat);
        PrepositionToCases.add("beidseits", Case.Gen);
        PrepositionToCases.add("betreffend", Case.Akk);
        PrepositionToCases.add("betreffs", Case.Gen);
        PrepositionToCases.add("bez\u00fcglich", Case.Gen);
        PrepositionToCases.add("binnen", Case.Dat);
        PrepositionToCases.add("bis", Case.Akk);
        PrepositionToCases.add("bis auf", Case.Akk);
        PrepositionToCases.add("dank", Case.Dat, Case.Gen);
        PrepositionToCases.add("diesseits", Case.Gen);
        PrepositionToCases.add("durch", Case.Akk);
        PrepositionToCases.add("eingangs", Case.Gen);
        PrepositionToCases.add("eingedenk", Case.Gen);
        PrepositionToCases.add("einschlie\u00dflich", Case.Gen);
        PrepositionToCases.add("entgegen", Case.Dat);
        PrepositionToCases.add("entlang", Case.Dat, Case.Akk, Case.Gen);
        PrepositionToCases.add("entsprechend", Case.Dat);
        PrepositionToCases.add("exklusive", Case.Gen);
        PrepositionToCases.add("fern", Case.Dat);
        PrepositionToCases.add("fernab", Case.Gen);
        PrepositionToCases.add("f\u00fcr", Case.Akk);
        PrepositionToCases.add("gegen", Case.Akk);
        PrepositionToCases.add("gegen\u00fcber", Case.Dat);
        PrepositionToCases.add("gem\u00e4\u00df", Case.Dat);
        PrepositionToCases.add("getreu", Case.Dat);
        PrepositionToCases.add("halber", Case.Gen);
        PrepositionToCases.add("hinsichtlich", Case.Gen);
        PrepositionToCases.add("hinter", Case.Dat, Case.Akk);
        PrepositionToCases.add("in puncto", Case.Gen);
        PrepositionToCases.add("infolge", Case.Gen);
        PrepositionToCases.add("inklusive", Case.Gen);
        PrepositionToCases.add("inmitten", Case.Gen);
        PrepositionToCases.add("innerhalb", Case.Gen);
        PrepositionToCases.add("innert", Case.Gen);
        PrepositionToCases.add("je", Case.Akk);
        PrepositionToCases.add("jenseits", Case.Gen);
        PrepositionToCases.add("kontra", Case.Akk);
        PrepositionToCases.add("kraft", Case.Gen);
        PrepositionToCases.add("laut", Case.Gen, Case.Dat);
        PrepositionToCases.add("l\u00e4ngs", Case.Gen);
        PrepositionToCases.add("l\u00e4ngsseits", Case.Gen);
        PrepositionToCases.add("mangels", Case.Gen);
        PrepositionToCases.add("mit", Case.Dat);
        PrepositionToCases.add("mitsamt", Case.Dat);
        PrepositionToCases.add("mittels", Case.Gen);
        PrepositionToCases.add("nach", Case.Dat);
        PrepositionToCases.add("namens", Case.Gen);
        PrepositionToCases.add("neben", Case.Dat, Case.Akk);
        PrepositionToCases.add("nebst", Case.Dat);
        PrepositionToCases.add("n\u00e4chst", Case.Dat);
        PrepositionToCases.add("oberhalb", Case.Gen);
        PrepositionToCases.add("ohne", Case.Akk);
        PrepositionToCases.add("per", Case.Akk);
        PrepositionToCases.add("pro", Case.Akk);
        PrepositionToCases.add("r\u00fccksichtlich", Case.Gen);
        PrepositionToCases.add("samt", Case.Dat);
        PrepositionToCases.add("seit", Case.Dat);
        PrepositionToCases.add("seitens", Case.Gen);
        PrepositionToCases.add("seitlich", Case.Gen);
        PrepositionToCases.add("statt", Case.Gen);
        PrepositionToCases.add("trotz", Case.Gen);
        PrepositionToCases.add("um", Case.Akk);
        PrepositionToCases.add("unbeschadet", Case.Gen);
        PrepositionToCases.add("uneingedenk", Case.Gen);
        PrepositionToCases.add("ungeachtet", Case.Gen);
        PrepositionToCases.add("unter", Case.Dat, Case.Akk);
        PrepositionToCases.add("unterhalb", Case.Gen);
        PrepositionToCases.add("unweit", Case.Gen);
        PrepositionToCases.add("vermittels", Case.Gen);
        PrepositionToCases.add("vermittelst", Case.Gen);
        PrepositionToCases.add("verm\u00f6ge", Case.Gen);
        PrepositionToCases.add("versus", Case.Akk);
        PrepositionToCases.add("via", Case.Akk);
        PrepositionToCases.add("vis-\u00e0-vis", Case.Dat);
        PrepositionToCases.add("von", Case.Dat);
        PrepositionToCases.add("vor", Case.Dat, Case.Akk);
        PrepositionToCases.add("vorbehaltlich", Case.Gen);
        PrepositionToCases.add("wegen", Case.Gen);
        PrepositionToCases.add("weitab", Case.Gen);
        PrepositionToCases.add("wider", Case.Akk);
        PrepositionToCases.add("w\u00e4hrend", Case.Gen);
        PrepositionToCases.add("zeit", Case.Gen);
        PrepositionToCases.add("zu", Case.Dat);
        PrepositionToCases.add("zufolge", Case.Dat);
        PrepositionToCases.add("zugunsten", Case.Gen);
        PrepositionToCases.add("zuliebe", Case.Dat);
        PrepositionToCases.add("zuungunsten", Case.Gen);
        PrepositionToCases.add("zuwider", Case.Dat);
        PrepositionToCases.add("zuz\u00fcglich", Case.Gen);
        PrepositionToCases.add("zwecks", Case.Gen);
        PrepositionToCases.add("zwischen", Case.Dat, Case.Akk);
        PrepositionToCases.add("\u00e0", Case.Akk);
        PrepositionToCases.add("\u00fcber", Case.Dat, Case.Akk);
    }

    static enum Case {
        Nom,
        Akk,
        Gen,
        Dat;

    }
}

