/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tools.StringTools;

public class PotentialCompoundFilter
extends RuleFilter {
    private final German language = new GermanyGerman();
    private JLanguageTool lt;

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        this.initLt();
        String part1 = arguments.get("part1");
        String part2 = arguments.get("part2");
        String joinedWord = StringTools.uppercaseFirstChar((String)part1.toLowerCase()) + part2.toLowerCase();
        ArrayList<String> replacements = new ArrayList<String>();
        List matches = this.lt.check(joinedWord);
        if (matches.isEmpty()) {
            if (joinedWord.length() > 20) {
                replacements.add(part1 + "-" + part2);
            }
            replacements.add(joinedWord);
        } else {
            replacements.add(part1 + "-" + part2);
        }
        if (!replacements.isEmpty()) {
            String message = match.getMessage();
            RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
            ruleMatch.setType(match.getType());
            ruleMatch.setSuggestedReplacements(replacements);
            return ruleMatch;
        }
        return null;
    }

    private void initLt() {
        if (this.lt == null) {
            this.lt = new JLanguageTool((Language)this.language);
            for (Rule rule : this.lt.getAllActiveRules()) {
                if (rule.getId().equals("GERMAN_SPELLER_RULE")) continue;
                this.lt.disableRule(rule.getId());
            }
        }
    }
}

