/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStatisticStyleRule;
import org.languagetool.rules.Example;

public class NonSignificantVerbsRule
extends AbstractStatisticStyleRule {
    private static final int DEFAULT_MIN_PER_MILL = 8;
    private static final String[] nonSignificant = new String[]{"haben", "sein", "machen", "tun"};

    public NonSignificantVerbsRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 8);
        this.addExamplePair(Example.wrong((String)"Er <marker>machte</marker> einen Kuchen."), Example.fixed((String)"Das macht mir Angst."));
    }

    private static boolean isUnknownWord(AnalyzedTokenReadings token) {
        return token.isPosTagUnknown() && token.getToken().length() > 2 && token.getToken().matches("^[A-Za-z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]+$");
    }

    private static boolean isException(AnalyzedTokenReadings[] tokens, int num) {
        block5: {
            int i;
            block4: {
                if (!tokens[num].hasLemma("machen")) break block4;
                for (int i2 = 1; i2 < tokens.length; ++i2) {
                    if (!"Angst".equals(tokens[i2].getToken()) && !"frisch".equals(tokens[i2].getToken()) && !"bemerkbar".equals(tokens[i2].getToken()) && !"aufmerksam".equals(tokens[i2].getToken())) continue;
                    return true;
                }
                break block5;
            }
            boolean isHaben = tokens[num].hasLemma("haben");
            if (isHaben) {
                for (i = 1; i < tokens.length; ++i) {
                    String sToken = tokens[i].getToken();
                    if (!sToken.equals("Gl\u00fcck") && !sToken.equals("Angst") && !sToken.equals("Recht") && !sToken.equals("recht")) continue;
                    return true;
                }
            }
            if (!isHaben && !tokens[num].hasLemma("sein")) break block5;
            for (i = 1; i < tokens.length; ++i) {
                if (!tokens[i].hasPosTagStartingWith("PA2") && !tokens[i].hasPosTagStartingWith("VER:PA2") && !NonSignificantVerbsRule.isUnknownWord(tokens[i])) continue;
                return true;
            }
        }
        return false;
    }

    public double denominator() {
        return 1000.0;
    }

    protected int conditionFulfilled(AnalyzedTokenReadings[] tokens, int nAnalysedToken) {
        if (tokens[nAnalysedToken].hasAnyLemma(nonSignificant) && !NonSignificantVerbsRule.isException(tokens, nAnalysedToken)) {
            return nAnalysedToken;
        }
        return -1;
    }

    protected boolean sentenceConditionFulfilled(AnalyzedTokenReadings[] tokens, int nToken) {
        return false;
    }

    protected boolean excludeDirectSpeech() {
        return true;
    }

    protected String getLimitMessage(int limit, double percent) {
        if (limit == 0) {
            return "Dieses Verb hat wenig Aussagekraft. Verwenden Sie wenn m\u00f6glich ein anderes oder formulieren Sie den Satz um.";
        }
        return "Mehr als " + limit + "\u2030 wenig aussagekr\u00e4ftige Verben {" + (int)(percent + 0.5) + "\u2030} gefunden. Verwenden Sie wenn m\u00f6glich ein anderes Verb oder formulieren Sie den Satz um.";
    }

    protected String getSentenceMessage() {
        return null;
    }

    public String getId() {
        return "NON_SIGNIFICANT_VERB_DE";
    }

    public String getDescription() {
        return "Statistische Stilanalyse: Verben mit wenig Aussagekraft";
    }

    public String getConfigureText() {
        return "Anzeigen wenn mehr als ...\u2030 eines Kapitels wenig aussagekr\u00e4ftige Verben sind:";
    }
}

