/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class GermanWordRepeatRule
extends WordRepeatRule {
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Bora"), PatternRuleBuilderHelper.csToken((String)"Bora")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Moin"), PatternRuleBuilderHelper.token((String)"Moin")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Na"), PatternRuleBuilderHelper.token((String)"na")), Arrays.asList(PatternRuleBuilderHelper.token((String)"la"), PatternRuleBuilderHelper.token((String)"la")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Fragen"), PatternRuleBuilderHelper.csToken((String)"fragen")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ha"), PatternRuleBuilderHelper.token((String)"ha")), Arrays.asList(PatternRuleBuilderHelper.token((String)"teils"), PatternRuleBuilderHelper.token((String)"teils")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Marsch"), PatternRuleBuilderHelper.token((String)"Marsch")), Arrays.asList(PatternRuleBuilderHelper.token((String)"hip"), PatternRuleBuilderHelper.token((String)"hip"), PatternRuleBuilderHelper.token((String)"hurra")), Arrays.asList(PatternRuleBuilderHelper.token((String)"m\u00f6p"), PatternRuleBuilderHelper.token((String)"m\u00f6p")), Arrays.asList(PatternRuleBuilderHelper.token((String)"piep"), PatternRuleBuilderHelper.token((String)"piep")), Arrays.asList(PatternRuleBuilderHelper.token((String)"bla"), PatternRuleBuilderHelper.token((String)"bla")), Arrays.asList(PatternRuleBuilderHelper.token((String)"blah"), PatternRuleBuilderHelper.token((String)"blah")), Arrays.asList(PatternRuleBuilderHelper.token((String)"oh"), PatternRuleBuilderHelper.token((String)"oh")), Arrays.asList(PatternRuleBuilderHelper.token((String)"klopf"), PatternRuleBuilderHelper.token((String)"klopf")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ne"), PatternRuleBuilderHelper.token((String)"ne")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Fakten"), PatternRuleBuilderHelper.token((String)"Fakten"), PatternRuleBuilderHelper.token((String)"Fakten")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Top"), PatternRuleBuilderHelper.token((String)"Top"), PatternRuleBuilderHelper.token((String)"Top")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Toi"), PatternRuleBuilderHelper.token((String)"Toi"), PatternRuleBuilderHelper.token((String)"Toi")), Arrays.asList(PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.token((String)"und")), Arrays.asList(PatternRuleBuilderHelper.token((String)"man"), PatternRuleBuilderHelper.token((String)"man"), PatternRuleBuilderHelper.token((String)"man")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Arbeit"), PatternRuleBuilderHelper.token((String)"Arbeit"), PatternRuleBuilderHelper.token((String)"Arbeit")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"\\*|:|\\/"), PatternRuleBuilderHelper.token((String)"in"), PatternRuleBuilderHelper.token((String)"in")), Arrays.asList(PatternRuleBuilderHelper.token((String)"\u00dcben"), PatternRuleBuilderHelper.token((String)"\u00dcben"), PatternRuleBuilderHelper.token((String)"\u00dcben")), Arrays.asList(PatternRuleBuilderHelper.token((String)"cha"), PatternRuleBuilderHelper.token((String)"cha")), Arrays.asList(PatternRuleBuilderHelper.token((String)"zack"), PatternRuleBuilderHelper.token((String)"zack")), Arrays.asList(PatternRuleBuilderHelper.token((String)"sapiens"), PatternRuleBuilderHelper.token((String)"sapiens")), Arrays.asList(PatternRuleBuilderHelper.token((String)"peng"), PatternRuleBuilderHelper.token((String)"peng")), Arrays.asList(PatternRuleBuilderHelper.token((String)"bye"), PatternRuleBuilderHelper.token((String)"bye")), Arrays.asList(PatternRuleBuilderHelper.token((String)"nicht"), PatternRuleBuilderHelper.token((String)"nicht"), PatternRuleBuilderHelper.token((String)"kommunizieren")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Phi"), PatternRuleBuilderHelper.token((String)"Phi")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)",|wei(\u00df|ss)|nicht"), PatternRuleBuilderHelper.token((String)"wer"), PatternRuleBuilderHelper.token((String)"wer"), PatternRuleBuilderHelper.tokenRegex((String)"war|ist|sein")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"ist|war|w\u00e4re?|f\u00fcr|dass"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)".*SUB:.*NEU.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"ist|war|w\u00e4re?|f\u00fcr|dass"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.*"), PatternRuleBuilderHelper.posRegex((String)".*SUB:.*NEU.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"ist|war|w\u00e4re?|f\u00fcr|dass"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.*NEU.*"), PatternRuleBuilderHelper.posRegex((String)"UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"als|wenn"), PatternRuleBuilderHelper.posRegex((String)"(PRO|EIG):.*"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.*NEU.*"), PatternRuleBuilderHelper.posRegex((String)".*SUB:.*NEU.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"werden|w\u00fcrden|sollt?en|m\u00fcsst?en|k\u00f6nnt?en"), PatternRuleBuilderHelper.token((String)"sie"), PatternRuleBuilderHelper.token((String)"sie"), PatternRuleBuilderHelper.posRegex((String)"VER:1:PLU:.*")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)","), new PatternTokenBuilder().csToken("der").matchInflectedForms().build(), new PatternTokenBuilder().csToken("der").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"alle|nur|obwohl|lediglich|f\u00fcr|zwar|aber"), new PatternTokenBuilder().csToken("die").build(), new PatternTokenBuilder().csToken("die").build()), Arrays.asList(PatternRuleBuilderHelper.csToken((String)","), PatternRuleBuilderHelper.posRegex((String)"PRP:.+"), new PatternTokenBuilder().csToken("der").matchInflectedForms().build(), new PatternTokenBuilder().csToken("der").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Leben"), PatternRuleBuilderHelper.csToken((String)"leben")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Stellen"), PatternRuleBuilderHelper.csToken((String)"stellen")), Arrays.asList(PatternRuleBuilderHelper.token((String)"die"), PatternRuleBuilderHelper.csToken((String)"ferne"), PatternRuleBuilderHelper.csToken((String)"Ferne")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Essen"), PatternRuleBuilderHelper.csToken((String)"essen")));
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;

    public GermanWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"In diesem Satz <marker>ist ist</marker> ein Wort doppelt."), Example.fixed((String)"In diesem Satz <marker>ist</marker> ein Wort doppelt."));
        this.antiPatterns = GermanWordRepeatRule.cacheAntiPatterns((Language)language, ANTI_PATTERNS);
    }

    public String getId() {
        return "GERMAN_WORD_REPEAT_RULE";
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        if (position != 2 && tokens[position - 1].getToken().equals("Sie") && tokens[position].getToken().equals("sie") || tokens[position - 1].getToken().equals("sie") && tokens[position].getToken().equals("Sie")) {
            return true;
        }
        if (position != 2 && tokens[position - 1].getToken().equals("Waren") && tokens[position].getToken().equals("waren") || tokens[position - 1].getToken().equals("waren") && tokens[position].getToken().equals("Waren")) {
            return true;
        }
        if (position > 2 && tokens[position - 1].getToken().equals("sie") && tokens[position].getToken().equals("sie")) {
            if (tokens[position - 2].hasPosTag("KON:UNT")) {
                return true;
            }
            if (tokens.length - 1 > position && (tokens[position - 2].hasPosTagStartingWith("VER:3:") && tokens[position + 1].hasPosTag("ZUS") || tokens[position - 2].hasPosTagStartingWith("VER:MOD:3") && tokens[position + 1].hasPosTag("VER:INF:NON"))) {
                return true;
            }
        }
        if (tokens[position].getToken().matches("(?i)^[a-z]$") && position > 1 && tokens[position - 2].getToken().matches("(?i)^[a-z]$") && position + 1 < tokens.length && tokens[position + 1].getToken().matches("(?i)^[a-z]$")) {
            return true;
        }
        return super.ignore(tokens, position);
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }
}

