/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.synthesis.BaseSynthesizer;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanSynthesizer
extends BaseSynthesizer {
    private final GermanCompoundTokenizer splitter;

    public GermanSynthesizer(Language lang) {
        super("/de/german_synth.dict", "/de/german_tags.txt", lang);
        try {
            this.splitter = new GermanCompoundTokenizer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        String[] result = super.synthesize(token, posTag);
        if (result.length == 0) {
            return this.getCompoundForms(token, posTag, false);
        }
        return result;
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        String[] result = super.synthesize(token, posTag, posTagRegExp);
        if (result.length == 0) {
            return this.getCompoundForms(token, posTag, posTagRegExp);
        }
        return result;
    }

    @NotNull
    private String[] getCompoundForms(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        List<String> parts = this.splitter.tokenize(token.getLemma());
        if (parts.size() == 0) {
            return parts.toArray(new String[0]);
        }
        String firstPart = String.join((CharSequence)"", parts.subList(0, parts.size() - 1));
        String lastPart = StringTools.uppercaseFirstChar((String)parts.get(parts.size() - 1));
        AnalyzedToken lastPartToken = new AnalyzedToken(lastPart, posTag, lastPart);
        String[] lastPartForms = posTagRegExp ? super.synthesize(lastPartToken, posTag, true) : super.synthesize(lastPartToken, posTag);
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        for (String part : lastPartForms) {
            results.add(firstPart + StringTools.lowercaseFirstChar((String)part));
        }
        return results.toArray(new String[0]);
    }
}

