/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.AgreementSuggestor;
import org.languagetool.rules.de.AgreementTools;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public class AgreementRule
extends Rule {
    private final German language;
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;
    private JLanguageTool lt;
    private static final AnalyzedToken[] INS_REPLACEMENT = new AnalyzedToken[]{new AnalyzedToken("das", "ART:DEF:AKK:SIN:NEU", "das")};
    private static final AnalyzedToken[] ZUR_REPLACEMENT = new AnalyzedToken[]{new AnalyzedToken("der", "ART:DEF:DAT:SIN:FEM", "der")};
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.regex((String)"ein|das"), PatternRuleBuilderHelper.pos((String)"SUB:NOM:SIN:NEU"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:PLU:.*"), PatternRuleBuilderHelper.posRegex((String)"VER:3:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"uns"), PatternRuleBuilderHelper.token((String)"allen"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*:SIN:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Domain"), PatternRuleBuilderHelper.token((String)"Name"), PatternRuleBuilderHelper.tokenRegex((String)"Systems?")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"der|das|die"), new PatternTokenBuilder().min(0).build(), PatternRuleBuilderHelper.token((String)"Bad"), PatternRuleBuilderHelper.token((String)"Homburger")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"der|die|das"), PatternRuleBuilderHelper.csRegex((String)"einem|[0-9]+er"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"de[rs]"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.*"), PatternRuleBuilderHelper.posRegex((String)"EIG:.*"), PatternRuleBuilderHelper.posRegex((String)"PA2:.*")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"ART:.*FEM.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*FEM.*"), PatternRuleBuilderHelper.token((String)"in"), PatternRuleBuilderHelper.token((String)"der")), Arrays.asList(PatternRuleBuilderHelper.token((String)"einem"), PatternRuleBuilderHelper.token((String)"kalte"), PatternRuleBuilderHelper.token((String)"Schauer")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"die|der"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*"), PatternRuleBuilderHelper.token((String)"GmbH")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Die"), PatternRuleBuilderHelper.regex((String)"Waltons|Einen")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Gro\u00dfe[sn]?"), PatternRuleBuilderHelper.regex((String)"(Bundes)?Verdienstkreuz(es)?")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)".*"), PatternRuleBuilderHelper.token((String)"und"), PatternRuleBuilderHelper.tokenRegex((String)".*"), PatternRuleBuilderHelper.token((String)","), PatternRuleBuilderHelper.token((String)"beides"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Eins|Zwei|Drei|Vier|F\u00fcnf|Sechs|Sieben|Acht|Neun|Zehn|Elf|Zw\u00f6lf"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"bis"), PatternRuleBuilderHelper.token((String)"zu"), PatternRuleBuilderHelper.token((String)"der"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*"), PatternRuleBuilderHelper.posRegex((String)"PA2:.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"jeder?"), PatternRuleBuilderHelper.token((String)"Abitur")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Halle"), PatternRuleBuilderHelper.token((String)"an"), PatternRuleBuilderHelper.token((String)"der"), PatternRuleBuilderHelper.token((String)"Saale")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Dutzend|Hundert|Tausend"), new PatternTokenBuilder().posRegex("ADJ:.*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"dich|mich"), new PatternTokenBuilder().posRegex("ADJ:.*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"die"), PatternRuleBuilderHelper.token((String)"Tausenden"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*PLU.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"das|ein"), PatternRuleBuilderHelper.token((String)"Formart")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"andere"), PatternRuleBuilderHelper.posRegex((String)"VER:PA2.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"der|die|das"), new PatternTokenBuilder().token("eine").setSkip(-1).build(), PatternRuleBuilderHelper.regex((String)"der|die|das"), PatternRuleBuilderHelper.token((String)"andere"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"jede[mnrs]?"), PatternRuleBuilderHelper.regex((String)"anderen?"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"diese[rs]?|keine?"), PatternRuleBuilderHelper.regex((String)"anderer?"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"der|die|das"), PatternRuleBuilderHelper.regex((String)"anderen?"), PatternRuleBuilderHelper.token((String)"Recht"), new PatternTokenBuilder().csToken("haben").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"f\u00fcr"), PatternRuleBuilderHelper.regex((String)"den|die"), PatternRuleBuilderHelper.token((String)"anderen")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"der|eine[sr]"), PatternRuleBuilderHelper.token((String)"anderen"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"andere"), PatternRuleBuilderHelper.regex((String)"anderer?"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"gegen\u00fcber"), PatternRuleBuilderHelper.token((String)"den"), PatternRuleBuilderHelper.token((String)"anderen"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"des|die"), PatternRuleBuilderHelper.token((String)"anderen"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:3:.*"), PatternRuleBuilderHelper.regex((String)"den|die|das"), PatternRuleBuilderHelper.regex((String)"anderen?"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"als"), PatternRuleBuilderHelper.token((String)"andere"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*PLU.*")), Arrays.asList(new PatternTokenBuilder().token("was").setSkip(5).build(), PatternRuleBuilderHelper.token((String)"f\u00fcr"), PatternRuleBuilderHelper.token((String)"ein"), new PatternTokenBuilder().posRegex("ADJ:.*(MAS|NEU).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.*:(MAS|NEU).*")), Arrays.asList(new PatternTokenBuilder().token("was").setSkip(5).build(), PatternRuleBuilderHelper.token((String)"f\u00fcr"), PatternRuleBuilderHelper.token((String)"eine"), new PatternTokenBuilder().posRegex("ADJ:.*FEM.*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.*:FEM.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"was"), PatternRuleBuilderHelper.token((String)"in"), PatternRuleBuilderHelper.token((String)"aller"), new PatternTokenBuilder().token("Welt").setSkip(4).build(), PatternRuleBuilderHelper.token((String)"f\u00fcr"), PatternRuleBuilderHelper.token((String)"ein"), new PatternTokenBuilder().posRegex("ADJ:.*(MAS|NEU).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.*:(MAS|NEU).*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"was"), PatternRuleBuilderHelper.token((String)"in"), PatternRuleBuilderHelper.token((String)"aller"), new PatternTokenBuilder().token("Welt").setSkip(4).build(), PatternRuleBuilderHelper.token((String)"f\u00fcr"), PatternRuleBuilderHelper.token((String)"eine"), new PatternTokenBuilder().posRegex("ADJ:.*FEM.*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.*:FEM.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.token((String)"schwere"), PatternRuleBuilderHelper.token((String)"Konsequenzen")), Arrays.asList(PatternRuleBuilderHelper.token((String)"der"), PatternRuleBuilderHelper.token((String)"Chaos"), PatternRuleBuilderHelper.token((String)"Computer"), PatternRuleBuilderHelper.token((String)"Club")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Echo"), PatternRuleBuilderHelper.tokenRegex((String)"Show|Dot")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"App|Play"), PatternRuleBuilderHelper.token((String)"Store")), Arrays.asList(PatternRuleBuilderHelper.token((String)"dem"), PatternRuleBuilderHelper.token((String)"einen"), PatternRuleBuilderHelper.pos((String)"SUB:NOM:SIN:NEU")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.posRegex((String)"PRO:DEM:.+"), PatternRuleBuilderHelper.posRegex((String)"VER:3:.+"), PatternRuleBuilderHelper.posRegex((String)"SUB:(DAT|NOM):PLU.*")), Arrays.asList(new PatternTokenBuilder().posRegex("SENT_START|VER:AUX:[123].+").negate().build(), PatternRuleBuilderHelper.posRegex((String)"PRP:.+"), new PatternTokenBuilder().posRegex("PRO:DEM:(DAT|AKK).+").tokenRegex("der|dies").matchInflectedForms().build(), PatternRuleBuilderHelper.posRegex((String)"SUB:...:PLU.*")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"PRP:.+"), new PatternTokenBuilder().posRegex("PRO:DEM:(DAT|AKK).+").tokenRegex("der|dies").matchInflectedForms().build(), new PatternTokenBuilder().csTokenRegex("[A-Z\u00c4\u00d6\u00dc].+er").build(), new PatternTokenBuilder().posRegex("SUB.+").build()), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"PRP:.+"), PatternRuleBuilderHelper.posRegex((String)"PRO:DEM:(DAT|AKK).+"), PatternRuleBuilderHelper.posRegex((String)"PA2:(DAT|AKK).+"), PatternRuleBuilderHelper.posRegex((String)"SUB:(DAT|AKK):.*")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:.*[123].*"), PatternRuleBuilderHelper.posRegex((String)"PRO:DEM:DAT:SIN:NEU.*"), PatternRuleBuilderHelper.posRegex((String)"PA2:AKK:PLU.+"), PatternRuleBuilderHelper.posRegex((String)"SUB:AKK:PLU.+")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:.*[123].*"), PatternRuleBuilderHelper.posRegex((String)"PRO:DEM:AKK:SIN:NEU.*"), PatternRuleBuilderHelper.posRegex((String)"PA2:DAT:PLU.+"), PatternRuleBuilderHelper.posRegex((String)"SUB:DAT:PLU.+")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"ADJ:PRD:KOM"), PatternRuleBuilderHelper.csToken((String)"als"), PatternRuleBuilderHelper.regex((String)"d(er|ie|as)"), PatternRuleBuilderHelper.posRegex((String)".+:GEN:.+")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:.*|UNKNOWN"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.csRegex((String)"(\u00fcber)?n\u00e4chste[ns]?|kommende[ns]?|(vor)?letzten"), PatternRuleBuilderHelper.csRegex((String)"Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Montag|D(ien|onner)stag|Mittwoch|Freitag|S(ams|onn)tag|Sonnabend|Woche|Monat|Jahr|Morgens?|Abends|\u00dcbermorgen|Mittags?|Nachmittags?|Vormittags?|Sp\u00e4tabends?|Nachts?")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:.*|UNKNOWN"), PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.csRegex((String)"Januar|Februar|M\u00e4rz|April|Mai|Ju[nl]i|August|September|Oktober|November|Dezember|Montags?|D(ien|onner)stags?|Mittwochs?|Freitags?|S(ams|onn)tags?|Sonnabends?|Morgens?|Abends|\u00dcbermorgen|Mittags?|Nachmittags?|Vormittags?|Sp\u00e4tabends?|Nachts?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.tokenRegex((String)"Januar|Februar|M\u00e4rz|April|Mai|Ju[nl]i|August|September|Oktober|November|Dezember|Montags?|D(ien|onner)stags?|Mittwochs?|Freitags?|S(ams|onn)tags?|Sonnabends?|Morgens?|Abends|\u00dcbermorgen|Mittags?|Nachmittags?|Vormittags?|Sp\u00e4tabends?|Nachts?"), PatternRuleBuilderHelper.posRegex((String)"VER:.*|UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.tokenRegex((String)"(\u00fcber)?n\u00e4chste[ns]?|kommende[ns]?|(vor)?letzten|vorigen"), PatternRuleBuilderHelper.csRegex((String)"Januar|Februar|M\u00e4rz|April|Mai|Ju[nl]i|August|September|Oktober|November|Dezember|Montag|D(ien|onner)stag|Mittwoch|Freitag|S(ams|onn)tag|Sonnabend|Woche|Monat|Jahr|Morgens?|Abends|\u00dcbermorgen|Mittags?|Nachmittags?|Vormittags?|Sp\u00e4tabends?|Nachts?"), PatternRuleBuilderHelper.posRegex((String)"VER:.*|UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.csRegex((String)"Zufall|Sinn|Spa\u00df|Freude"), PatternRuleBuilderHelper.token((String)"?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.csRegex((String)"Zufall|Sinn|Spa\u00df"), PatternRuleBuilderHelper.csToken((String)",")), Arrays.asList(PatternRuleBuilderHelper.token((String)"in"), PatternRuleBuilderHelper.tokenRegex((String)"d(ies)?em"), PatternRuleBuilderHelper.token((String)"Fall"), PatternRuleBuilderHelper.tokenRegex((String)"(?i:hat(te)?)"), PatternRuleBuilderHelper.token((String)"das")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"ADV:.+"), PatternRuleBuilderHelper.tokenRegex((String)"(?i:hat(te)?)"), PatternRuleBuilderHelper.csToken((String)"das")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"von|bei"), PatternRuleBuilderHelper.csRegex((String)"vielen|allen"), PatternRuleBuilderHelper.posRegex((String)"PA2:.*|ADJ:AKK:PLU:.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"de[mnr]|die|das"), PatternRuleBuilderHelper.csRegex((String)"letzte[ns]?|vorige[ns]?"), PatternRuleBuilderHelper.csRegex((String)"Woche|Monat|Jahr(zehnt|hundert)?"), PatternRuleBuilderHelper.posRegex((String)"PRP:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*"), PatternRuleBuilderHelper.posRegex((String)"ART:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*"), PatternRuleBuilderHelper.posRegex((String)"PA2:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"f\u00fcr"), PatternRuleBuilderHelper.csRegex((String)"(viele|alle|[dm]ich|ihn|sie|uns|andere|jeden)"), PatternRuleBuilderHelper.posRegex((String)"ADJ:NOM:.*")), Arrays.asList(new PatternTokenBuilder().tokenRegex("fl\u00f6\u00dfen|machen|jagen").matchInflectedForms().build(), PatternRuleBuilderHelper.csRegex((String)"einem|jedem|keinem"), PatternRuleBuilderHelper.csToken((String)"Angst")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"einem|jedem|keinem"), PatternRuleBuilderHelper.csToken((String)"Angst"), new PatternTokenBuilder().tokenRegex("machen|ein(fl\u00f6\u00dfen|jagen)").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"einem"), PatternRuleBuilderHelper.csToken((String)"geschenkten"), PatternRuleBuilderHelper.csToken((String)"Gaul")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"ein"), PatternRuleBuilderHelper.csToken((String)"einzig"), PatternRuleBuilderHelper.csToken((String)"Volk"), PatternRuleBuilderHelper.csToken((String)"von")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"den"), PatternRuleBuilderHelper.csToken((String)"Spatz"), PatternRuleBuilderHelper.csToken((String)"in")), Arrays.asList(PatternRuleBuilderHelper.token((String)"kein"), PatternRuleBuilderHelper.csToken((String)"sch\u00f6ner"), PatternRuleBuilderHelper.csToken((String)"Land")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"die|der|das"), PatternRuleBuilderHelper.csRegex((String)"Anfang|Mitte|Ende"), PatternRuleBuilderHelper.csRegex((String)"Januar|J\u00e4nner|Februar|M\u00e4rz|April|Mai|Ju[ln]i|August|September|Oktober|November|Dezember|[12][0-9]{3}")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Ist|Sind|Macht|Wird"), PatternRuleBuilderHelper.csToken((String)"das"), new PatternTokenBuilder().posRegex("ADJ:NOM.*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM.*"), PatternRuleBuilderHelper.posRegex((String)"PKT|KON:NEB|PRP.+")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z\u00c4\u00d6\u00dc].+"), PatternRuleBuilderHelper.csRegex((String)"AG|GmbH")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[A-Z\u00c4\u00d6\u00dc].+"), PatternRuleBuilderHelper.csRegex((String)"[A-Z\u00c4\u00d6\u00dc].+"), PatternRuleBuilderHelper.csRegex((String)"AG|GmbH")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Meist(ens)?|Oft(mals)?|H\u00e4ufig|Selten"), PatternRuleBuilderHelper.tokenRegex((String)"sind|waren|ist"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"des"), PatternRuleBuilderHelper.token((String)"Lied"), PatternRuleBuilderHelper.token((String)"ich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"einige"), PatternRuleBuilderHelper.token((String)"Grad")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ein"), PatternRuleBuilderHelper.tokenRegex((String)"dickes|gro\u00dfes|grosses|fettes|pers\u00f6nliches"), PatternRuleBuilderHelper.token((String)"Danke")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.tokenRegex((String)"D(a|ie)s"), PatternRuleBuilderHelper.posRegex((String)"VER:[123]:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)":"), PatternRuleBuilderHelper.tokenRegex((String)"D(a|ie)s"), PatternRuleBuilderHelper.posRegex((String)"VER:[123]:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:.*")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"ART:.+"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.+"), PatternRuleBuilderHelper.tokenRegex((String)"(Kilo|Zenti|Milli)?meter|Jahre|Monate|Wochen|Tage|Stunden|Minuten|Sekunden")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Van"), PatternRuleBuilderHelper.token((String)"der"), PatternRuleBuilderHelper.tokenRegex((String)"Bellens?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"mehrere"), PatternRuleBuilderHelper.pos((String)"SUB:NOM:SIN:FEM:ADJ")), Arrays.asList(PatternRuleBuilderHelper.token((String)"allen"), PatternRuleBuilderHelper.tokenRegex((String)"Besitz|Mut")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"d(ie|e[nr])|[md]eine[nr]?|(eure|unsere)[nr]?|diese[nr]?"), PatternRuleBuilderHelper.token((String)"Top"), PatternRuleBuilderHelper.tokenRegex((String)"\\d+")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:3:SIN:.*"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"ADJ:AKK:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:AKK:.*"), PatternRuleBuilderHelper.pos((String)"ZUS"), PatternRuleBuilderHelper.pos((String)"SENT_END")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"VER:3:SIN:.+"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:AKK:.+"), PatternRuleBuilderHelper.pos((String)"ZUS"), PatternRuleBuilderHelper.pos((String)"SENT_END")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Au\u00dfenring"), PatternRuleBuilderHelper.token((String)"Autobahn")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[dw]em"), PatternRuleBuilderHelper.csToken((String)"Ehre"), PatternRuleBuilderHelper.csToken((String)"geb\u00fchrt")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Eurovision"), PatternRuleBuilderHelper.token((String)"Song"), PatternRuleBuilderHelper.token((String)"Contest")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Account"), PatternRuleBuilderHelper.tokenRegex((String)"Managers?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Display"), PatternRuleBuilderHelper.tokenRegex((String)"Ads?|Advertising")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Private"), PatternRuleBuilderHelper.tokenRegex((String)"Equitys?|Clouds?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Personal"), PatternRuleBuilderHelper.tokenRegex((String)"Agents?|Computers?|Data|Firewalls?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Junge"), PatternRuleBuilderHelper.tokenRegex((String)"Union|Freiheit|Welt|Europ\u00e4ische|Alternative|Volkspartei|Akademie")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"ART:.+"), PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), PatternRuleBuilderHelper.pos((String)"UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)","), PatternRuleBuilderHelper.posRegex((String)"KON:UNT|ADV:INR"), PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), PatternRuleBuilderHelper.posRegex((String)"VER:3:SIN.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"viele|wenige|einige|mehrere"), PatternRuleBuilderHelper.csToken((String)"solcher"), PatternRuleBuilderHelper.posRegex((String)"SUB:GEN:PLU:.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[dD](ie|er)"), PatternRuleBuilderHelper.csToken((String)"First"), PatternRuleBuilderHelper.csToken((String)"Lady")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[dD](ie|er)"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.*"), PatternRuleBuilderHelper.csToken((String)"First"), PatternRuleBuilderHelper.csToken((String)"Lady")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[dD](ie|er)"), PatternRuleBuilderHelper.csToken((String)"Super"), PatternRuleBuilderHelper.csToken((String)"Nintendo")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Pizza"), PatternRuleBuilderHelper.csToken((String)"Hut")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)","), PatternRuleBuilderHelper.csToken((String)"beides"), new PatternTokenBuilder().posRegex("ADJ:NOM:PLU.+").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:PLU.+"), PatternRuleBuilderHelper.pos((String)"PKT")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"[dD]e[rn]"), PatternRuleBuilderHelper.csToken((String)"Gold"), PatternRuleBuilderHelper.csToken((String)"Cup")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.tokenRegex((String)"viele|wenige"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), new PatternTokenBuilder().csToken("dauern").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"allen|(nieman|je(man)?)dem"), PatternRuleBuilderHelper.posRegex((String)"ADJ:AKK:PLU:.*"), PatternRuleBuilderHelper.posRegex((String)"SUB:AKK:PLU:.*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"allen|(nieman|je(man)?)dem"), PatternRuleBuilderHelper.posRegex((String)"SUB:AKK:PLU:.*")), Arrays.asList(new PatternTokenBuilder().posRegex("PRP:.+|ADV:MOD").setSkip(2).build(), new PatternTokenBuilder().token("sein").matchInflectedForms().build(), PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:.*"), PatternRuleBuilderHelper.posRegex((String)"PKT|SENT_END|KON.*")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"KON:UNT"), PatternRuleBuilderHelper.csToken((String)"das"), new PatternTokenBuilder().posRegex("ADJ:.*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), new PatternTokenBuilder().tokenRegex("bedeuten|sein").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.pos((String)"KON:UNT"), PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.pos((String)"ADV:MOD"), PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), new PatternTokenBuilder().tokenRegex("bedeuten|sein").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().token("niemand").matchInflectedForms().build(), PatternRuleBuilderHelper.posRegex((String)"SUB:.+")), Arrays.asList(PatternRuleBuilderHelper.token((String)"alles"), PatternRuleBuilderHelper.csToken((String)"Walzer")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"der"), PatternRuleBuilderHelper.csToken((String)"Daus")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"PRO:...:...:SIN:NEU.*"), PatternRuleBuilderHelper.csToken((String)"Orange")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"PRO:...:...:SIN:NEU.*"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.+"), PatternRuleBuilderHelper.csToken((String)"Orange")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"dem"), new PatternTokenBuilder().csToken("Achtung").setSkip(1).build(), new PatternTokenBuilder().csToken("schenken").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("schenken").matchInflectedForms().build(), PatternRuleBuilderHelper.csToken((String)"dem"), PatternRuleBuilderHelper.csToken((String)"Achtung")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"dem"), new PatternTokenBuilder().csToken("Rechnung").setSkip(1).build(), new PatternTokenBuilder().csToken("tragen").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("tragen").matchInflectedForms().build(), PatternRuleBuilderHelper.csToken((String)"dem"), PatternRuleBuilderHelper.csToken((String)"Rechnung")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"zum"), PatternRuleBuilderHelper.csToken((String)"einen"), PatternRuleBuilderHelper.posRegex((String)"ADJ:.+")), Arrays.asList(PatternRuleBuilderHelper.token((String)"auf"), PatternRuleBuilderHelper.csToken((String)"die"), PatternRuleBuilderHelper.csToken((String)"Lauer")), Arrays.asList(PatternRuleBuilderHelper.token((String)"dieser"), PatternRuleBuilderHelper.csToken((String)"eine"), PatternRuleBuilderHelper.pos((String)"SUB:NOM:SIN:MAS")), Arrays.asList(PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:DAT:.+"), PatternRuleBuilderHelper.token((String)"vorbehalten")), Arrays.asList(new PatternTokenBuilder().token("wenn").setSkip(1).build(), PatternRuleBuilderHelper.csToken((String)"einer"), PatternRuleBuilderHelper.posRegex((String)"SUB:AKK:.+"), PatternRuleBuilderHelper.posRegex((String)"VER:(MOD:)?3:SIN:.+"), PatternRuleBuilderHelper.csToken((String)",")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"eine[rs]"), PatternRuleBuilderHelper.tokenRegex((String)"jed(wed)?en")), Arrays.asList(PatternRuleBuilderHelper.token((String)"die"), PatternRuleBuilderHelper.tokenRegex((String)"[MDS]einen")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"\u00fcber"), PatternRuleBuilderHelper.csToken((String)"die"), PatternRuleBuilderHelper.csToken((String)"Ma\u00dfen")), Arrays.asList(PatternRuleBuilderHelper.token((String)"was"), new PatternTokenBuilder().csToken("n\u00fctzen").matchInflectedForms().build(), PatternRuleBuilderHelper.csToken((String)"einem"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:.+")), Arrays.asList(new PatternTokenBuilder().csToken("haben").matchInflectedForms().build(), PatternRuleBuilderHelper.csToken((String)"sein"), PatternRuleBuilderHelper.csToken((String)"Gutes")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Gutes"), new PatternTokenBuilder().tokenRegex("haben|tun").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"dieser"), PatternRuleBuilderHelper.csToken((String)"einen"), PatternRuleBuilderHelper.pos((String)"SUB:DAT:SIN:FEM")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Rede"), PatternRuleBuilderHelper.csToken((String)"und"), PatternRuleBuilderHelper.csToken((String)"Antwort")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"ABK:.+:SUB")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"(all|je(d|glich))en"), PatternRuleBuilderHelper.csToken((String)"Reiz")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"wieso|ob|warum|w[ae]nn"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.tokenRegex((String)"sinn|mehrwert"), PatternRuleBuilderHelper.tokenRegex((String)"macht|ergibt|stiftet|bringt")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"hat|h\u00e4tte|kann|wird|d\u00fcrfte|muss|soll(te)?|k\u00f6nnte|m\u00fcsste|w\u00fcrde"), PatternRuleBuilderHelper.token((String)"das"), PatternRuleBuilderHelper.token((String)"Konsequenzen")), Arrays.asList(new PatternTokenBuilder().posRegex("VER:.*[1-3]:.+").setSkip(1).build(), PatternRuleBuilderHelper.csToken((String)"vermehrt")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Ruhr"), PatternRuleBuilderHelper.csToken((String)"Nachrichten")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Joint"), PatternRuleBuilderHelper.tokenRegex((String)"Ventures?|Cares?")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Premier"), PatternRuleBuilderHelper.csToken((String)"League")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Software"), PatternRuleBuilderHelper.tokenRegex((String)"Engineers?|Developer[sn]?|(Back|Front)end")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Mark"), PatternRuleBuilderHelper.posRegex((String)"EIG:.*")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Sales"), PatternRuleBuilderHelper.tokenRegex((String)"Agent")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Total"), PatternRuleBuilderHelper.tokenRegex((String)"Tankstellen?")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Real"), PatternRuleBuilderHelper.tokenRegex((String)"Madrid|Valladolid|Mallorca")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Real"), PatternRuleBuilderHelper.pos((String)"UNKNOWN")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Hammer"), PatternRuleBuilderHelper.tokenRegex((String)"Stra(\u00df|ss)e")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Personal"), PatternRuleBuilderHelper.tokenRegex((String)"Trainers?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Hallo"), new PatternTokenBuilder().csToken("sagen").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"die"), PatternRuleBuilderHelper.tokenRegex((String)"Deutsch|Englisch|Spanisch|Franz\u00f6sisch|Russisch|Polnisch|Holl\u00e4ndisch|Niederl\u00e4ndisch|Portugiesisch"), new PatternTokenBuilder().csToken("sprechen").matchInflectedForms().build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"zum"), PatternRuleBuilderHelper.token((String)"einen"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Fake"), PatternRuleBuilderHelper.posRegex((String)"News")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Steinberg|Park"), PatternRuleBuilderHelper.csToken((String)"Apotheke")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"IT"), PatternRuleBuilderHelper.csToken((String)"Finanzmagazin")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Golden"), PatternRuleBuilderHelper.csToken((String)"Gate")), Arrays.asList(PatternRuleBuilderHelper.token((String)"f\u00fcrs"), PatternRuleBuilderHelper.token((String)"Bescheid"), PatternRuleBuilderHelper.tokenRegex((String)"geben|sagen")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Los"), PatternRuleBuilderHelper.tokenRegex((String)"Angeles|Zetas")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Auto"), PatternRuleBuilderHelper.csToken((String)"Zeitung")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Mal"), new PatternTokenBuilder().token("sein").matchInflectedForms().build(), PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:.*")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"FC"), PatternRuleBuilderHelper.csToken((String)"Bayern")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Super"), PatternRuleBuilderHelper.csToken((String)"Mario")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Toyota"), PatternRuleBuilderHelper.csToken((String)"Motor"), PatternRuleBuilderHelper.tokenRegex((String)"Corp(oration)?|Company")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Office|Microsoft"), PatternRuleBuilderHelper.csToken((String)"365")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Prinz"), PatternRuleBuilderHelper.tokenRegex((String)"Charles|William")), Arrays.asList(PatternRuleBuilderHelper.token((String)":"), PatternRuleBuilderHelper.csToken((String)"D")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"ist|war(en)?|sind|wird|werden"), PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.csToken((String)"reine"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:.*")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Android"), PatternRuleBuilderHelper.tokenRegex((String)"Wear|Watch(es)?|Smartwatch(es)?|OS")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"\\w+"), new PatternTokenBuilder().token(".").setIsWhiteSpaceBefore(false).build(), new PatternTokenBuilder().tokenRegex("pdf|zip|jpe?g|gif|png|rar|mp[34]|mpe?g|avi|docx?|xlsx?|pptx?|html?").setIsWhiteSpaceBefore(false).build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("Junior|Senior").setSkip(3).build(), PatternRuleBuilderHelper.tokenRegex((String)"Manager[ns]?|Managerin(nen)?")), Arrays.asList(new PatternTokenBuilder().tokenRegex("Junior|Senior").build(), PatternRuleBuilderHelper.token((String)"Software"), PatternRuleBuilderHelper.tokenRegex((String)"Engineers?|Architects?|Managers?|Directors?")), Arrays.asList(new PatternTokenBuilder().tokenRegex("Junior|Senior").build(), PatternRuleBuilderHelper.token((String)"Engineering"), PatternRuleBuilderHelper.tokenRegex((String)"Manager[ns]?|Directors?")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Business"), PatternRuleBuilderHelper.tokenRegex((String)"Angel[ns]?")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Manager"), PatternRuleBuilderHelper.tokenRegex((String)"Magazins?")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Junior"), PatternRuleBuilderHelper.tokenRegex((String)"Suite[sn]?")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"die|eine|unsere|meine|ihre|eure|diese|seine|deine"), PatternRuleBuilderHelper.csToken((String)"Abt"), PatternRuleBuilderHelper.token((String)"."), PatternRuleBuilderHelper.tokenRegex((String)".+")), Arrays.asList(new PatternTokenBuilder().tokenRegex("Junior|Senior").build(), new PatternTokenBuilder().tokenRegex("Journeys?").build()), Arrays.asList(PatternRuleBuilderHelper.token((String)"k\u00fchles"), PatternRuleBuilderHelper.token((String)"Blondes")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Vitamin|Buchstabe"), PatternRuleBuilderHelper.tokenRegex((String)"D|B|B[1-9]|B12")), Arrays.asList(new PatternTokenBuilder().token("betreffen").matchInflectedForms().build(), PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.posRegex((String)"SUB:AKK:PLU:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"was"), PatternRuleBuilderHelper.csToken((String)"f\u00fcr"), PatternRuleBuilderHelper.csToken((String)"ein"), new PatternTokenBuilder().posRegex("ADJ:NOM:SIN:(MAS|NEU).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:SIN:(MAS|NEU)")), Arrays.asList(PatternRuleBuilderHelper.token((String)"was"), PatternRuleBuilderHelper.csToken((String)"f\u00fcr"), PatternRuleBuilderHelper.csToken((String)"eine"), new PatternTokenBuilder().posRegex("ADJ:NOM:SIN:FEM.*").min(0).build(), PatternRuleBuilderHelper.pos((String)"SUB:NOM:SIN:FEM")), Arrays.asList(PatternRuleBuilderHelper.token((String)"was"), new PatternTokenBuilder().token("sein").matchInflectedForms().setSkip(2).build(), PatternRuleBuilderHelper.csToken((String)"f\u00fcr"), PatternRuleBuilderHelper.csToken((String)"ein"), new PatternTokenBuilder().posRegex("ADJ:NOM:SIN:(MAS|NEU).*").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:SIN:(MAS|NEU)")), Arrays.asList(PatternRuleBuilderHelper.token((String)"was"), new PatternTokenBuilder().token("sein").matchInflectedForms().setSkip(2).build(), PatternRuleBuilderHelper.csToken((String)"f\u00fcr"), PatternRuleBuilderHelper.csToken((String)"eine"), new PatternTokenBuilder().posRegex("ADJ:NOM:SIN:FEM.*").min(0).build(), PatternRuleBuilderHelper.pos((String)"SUB:NOM:SIN:FEM")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"vielen?|wenigen?|einigen?"), PatternRuleBuilderHelper.csToken((String)"Paar"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:PLU:...")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"machte?|ergibt|ergab|stiftete?"), PatternRuleBuilderHelper.csToken((String)"das"), PatternRuleBuilderHelper.csToken((String)"Sinn")));
    private static final Set<String> MODIFIERS = new HashSet<String>(Arrays.asList("besonders", "fast", "ganz", "geradezu", "sehr", "\u00fcberaus", "ziemlich"));
    private static final Set<String> VIELE_WENIGE_LOWERCASE = new HashSet<String>(Arrays.asList("jegliche", "jeglicher", "andere", "anderer", "anderen", "s\u00e4mtlicher", "etliche", "etlicher", "viele", "vieler", "wenige", "weniger", "einige", "einiger", "mehrerer", "mehrere"));
    private static final String[] REL_PRONOUN_LEMMAS = new String[]{"der", "welch"};
    private static final Set<String> PRONOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("ich", "dir", "dich", "du", "er", "sie", "es", "wir", "mir", "uns", "ihnen", "euch", "ihm", "ihr", "ihn", "dessen", "deren", "denen", "sich", "aller", "allen", "man", "beide", "beiden", "beider", "wessen", "a", "alle", "etwas", "irgendetwas", "was", "wer", "jenen", "diejenigen", "jemand", "jemandes", "niemand", "niemandes"));
    private static final Set<String> NOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("Prozent", "Wollen", "Gramm", "Kilogramm", "Piepen", "Badlands", "Visual", "Chief", "Carina", "W\u00fcstenrot", "Meter", "Boots", "Taxameter", "Bild", "Emirates", "Uhr", "cm", "km", "Nr", "RP"));

    public AgreementRule(ResourceBundle messages, German language) {
        this.language = language;
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"<marker>Der Haus</marker> wurde letztes Jahr gebaut."), Example.fixed((String)"<marker>Das Haus</marker> wurde letztes Jahr gebaut."));
        this.antiPatterns = AgreementRule.cacheAntiPatterns((Language)language, ANTI_PATTERNS);
    }

    public String getId() {
        return "DE_AGREEMENT";
    }

    public int estimateContextForSureMatch() {
        return ANTI_PATTERNS.stream().mapToInt(List::size).max().orElse(0);
    }

    public String getDescription() {
        return "Kongruenz von Nominalphrasen (unvollst\u00e4ndig!), z.B. 'mein kleiner(kleines) Haus'";
    }

    private Map<Integer, ReplacementType> replacePrepositionsByArticle(AnalyzedTokenReadings[] tokens) {
        HashMap<Integer, ReplacementType> map = new HashMap<Integer, ReplacementType>();
        for (int i = 0; i < tokens.length; ++i) {
            if (StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"ins", "ans", "aufs", "vors", "durchs", "hinters", "unters", "\u00fcbers", "f\u00fcrs", "ums"})) {
                tokens[i] = new AnalyzedTokenReadings(INS_REPLACEMENT, tokens[i].getStartPos());
                map.put(i, ReplacementType.Ins);
                continue;
            }
            if (!StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"zur"})) continue;
            tokens[i] = new AnalyzedTokenReadings(ZUR_REPLACEMENT, tokens[i].getStartPos());
            map.put(i, ReplacementType.Zur);
        }
        return map;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        Map<Integer, ReplacementType> replMap = this.replacePrepositionsByArticle(tokens);
        for (int i = 0; i < tokens.length; ++i) {
            RuleMatch ruleMatch;
            boolean followingParticiple;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if ("SENT_START".equals(posToken) || tokens[i].isImmunized()) continue;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            boolean relevantPronoun = this.isRelevantPronoun(tokens, i);
            boolean ignore = this.couldBeRelativeOrDependentClause(tokens, i);
            if (i > 0) {
                String prevToken = tokens[i - 1].getToken().toLowerCase();
                if (StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"eine", "einen"}) && StringUtils.equalsAny((CharSequence)prevToken, (CharSequence[])new CharSequence[]{"der", "die", "das", "des", "dieses"})) {
                    ignore = true;
                }
            }
            if (StringUtils.equalsAny((CharSequence)tokenReadings.getToken(), (CharSequence[])new CharSequence[]{"nichts", "Nichts", "alles", "Alles", "dies", "Dies"})) {
                ignore = true;
            }
            boolean detAbbrev = i < tokens.length - 2 && tokens[i + 1].getToken().equals("Art") && tokens[i + 2].getToken().equals(".");
            boolean detAdjAbbrev = i < tokens.length - 3 && tokens[i + 2].getToken().equals("Art") && tokens[i + 3].getToken().equals(".");
            boolean bl = followingParticiple = i < tokens.length - 3 && (tokens[i + 2].hasPartialPosTag("PA1") || tokens[i + 2].getToken().matches("zugeschriebenen?|genannten?"));
            if (detAbbrev || detAdjAbbrev || followingParticiple) {
                ignore = true;
            }
            if (!GermanHelper.hasReadingOfType(tokenReadings, GermanToken.POSType.DETERMINER) && !relevantPronoun || ignore) continue;
            int tokenPosAfterModifier = this.getPosAfterModifier(i + 1, tokens);
            int tokenPos = tokenPosAfterModifier;
            if (tokenPos >= tokens.length) break;
            AnalyzedTokenReadings nextToken = tokens[tokenPos];
            if (this.isNonPredicativeAdjective(nextToken) || this.isParticiple(nextToken)) {
                tokenPos = tokenPosAfterModifier + 1;
                if (tokenPos >= tokens.length) break;
                if (!GermanHelper.hasReadingOfType(tokens[tokenPos], GermanToken.POSType.NOMEN) || i >= 2 && GermanHelper.hasReadingOfType(tokens[i - 2], GermanToken.POSType.ADJEKTIV) && "als".equals(tokens[i - 1].getToken()) && "das".equals(tokens[i].getToken()) || (ruleMatch = this.checkDetAdjNounAgreement(tokens[i], nextToken, tokens[tokenPos], sentence, i)) == null) continue;
                ruleMatches.add(ruleMatch);
                continue;
            }
            if (!GermanHelper.hasReadingOfType(nextToken, GermanToken.POSType.NOMEN) || "Herr".equals(nextToken.getToken()) || (ruleMatch = this.checkDetNounAgreement(tokens[i], nextToken, sentence, i, replMap)) == null) continue;
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private int getPosAfterModifier(int startAt, AnalyzedTokenReadings[] tokens) {
        if (startAt + 1 < tokens.length && MODIFIERS.contains(tokens[startAt].getToken())) {
            ++startAt;
        }
        if (startAt + 1 < tokens.length && (StringUtils.isNumeric((CharSequence)tokens[startAt].getToken()) || tokens[startAt].hasPosTag("ZAL"))) {
            int posAfterModifier = startAt + 1;
            if (startAt + 3 < tokens.length && ",".equals(tokens[startAt + 1].getToken()) && StringUtils.isNumeric((CharSequence)tokens[startAt + 2].getToken())) {
                posAfterModifier = startAt + 3;
            }
            if (StringUtils.endsWithAny((CharSequence)tokens[posAfterModifier].getToken(), (CharSequence[])new CharSequence[]{"gramm", "Gramm", "Meter", "meter"})) {
                return posAfterModifier + 1;
            }
        }
        return startAt;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    private boolean isNonPredicativeAdjective(AnalyzedTokenReadings tokensReadings) {
        for (AnalyzedToken reading : tokensReadings.getReadings()) {
            String posTag = reading.getPOSTag();
            if (posTag == null || !posTag.startsWith("ADJ") || posTag.contains("PRD")) continue;
            return true;
        }
        return false;
    }

    private boolean isParticiple(AnalyzedTokenReadings tokensReadings) {
        return tokensReadings.hasPartialPosTag("PA1") || tokensReadings.hasPartialPosTag("PA2");
    }

    private boolean isRelevantPronoun(AnalyzedTokenReadings[] tokens, int pos) {
        AnalyzedTokenReadings analyzedToken = tokens[pos];
        boolean relevantPronoun = GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.PRONOMEN);
        String token = tokens[pos].getToken();
        if (PRONOUNS_TO_BE_IGNORED.contains(token.toLowerCase()) || pos > 0 && tokens[pos - 1].getToken().equalsIgnoreCase("vor") && token.equalsIgnoreCase("allem")) {
            relevantPronoun = false;
        }
        return relevantPronoun;
    }

    private boolean couldBeRelativeOrDependentClause(AnalyzedTokenReadings[] tokens, int pos) {
        boolean relPronoun;
        boolean comma;
        if (pos >= 1) {
            comma = tokens[pos - 1].getToken().equals(",");
            boolean bl = relPronoun = comma && tokens[pos].hasAnyLemma(REL_PRONOUN_LEMMAS);
            if (relPronoun && pos + 3 < tokens.length) {
                return true;
            }
        }
        if (pos >= 2 && (comma = tokens[pos - 2].getToken().equals(","))) {
            boolean prep = tokens[pos - 1].hasPosTagStartingWith("PRP:");
            relPronoun = tokens[pos].hasAnyLemma(REL_PRONOUN_LEMMAS);
            return prep && relPronoun || tokens[pos - 1].hasPosTag("KON:UNT") && (tokens[pos].hasLemma("jen") || tokens[pos].hasLemma("dies"));
        }
        return false;
    }

    @Nullable
    private RuleMatch checkDetNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedSentence sentence, int tokenPos, Map<Integer, ReplacementType> replMap) {
        if (token2.isImmunized() || NOUNS_TO_BE_IGNORED.contains(token2.getToken()) || "-".equals(token2.getToken())) {
            return null;
        }
        Set<String> set1 = token1.getReadings().size() == 1 && ((AnalyzedToken)token1.getReadings().get(0)).getPOSTag() != null && ((AnalyzedToken)token1.getReadings().get(0)).getPOSTag().endsWith(":STV") ? Collections.emptySet() : this.getAgreementCategories(token1);
        Set<String> set2 = this.getAgreementCategories(token2);
        set1.retainAll(set2);
        RuleMatch ruleMatch = null;
        if (set1.isEmpty() && !this.isException(token1, token2)) {
            RuleMatch compoundMatch = this.getCompoundError(token1, token2, tokenPos, sentence);
            if (compoundMatch != null) {
                return compoundMatch;
            }
            List<String> errorCategories = this.getCategoriesCausingError(token1, token2);
            String errorDetails = errorCategories.isEmpty() ? "Kasus, Genus oder Numerus" : String.join((CharSequence)" und ", errorCategories);
            String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung des " + errorDetails + ".";
            String shortMsg = "Evtl. keine \u00dcbereinstimmung von Kasus, Genus oder Numerus";
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token2.getEndPos(), msg, shortMsg);
            AgreementSuggestor suggestor = new AgreementSuggestor(this.language.getSynthesizer(), token1, token2, replMap.get(tokenPos));
            List<String> suggestions = suggestor.getSuggestions();
            ruleMatch.setSuggestedReplacements(suggestions);
        }
        return ruleMatch;
    }

    @Nullable
    private RuleMatch getCompoundError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, int tokenPos, AnalyzedSentence sentence) {
        AnalyzedTokenReadings nextToken;
        if (tokenPos != -1 && tokenPos + 2 < sentence.getTokensWithoutWhitespace().length && StringTools.startsWithUppercase((String)(nextToken = sentence.getTokensWithoutWhitespace()[tokenPos + 2]).getToken())) {
            String potentialCompound = token2.getToken() + StringTools.lowercaseFirstChar((String)nextToken.getToken());
            String origToken1 = sentence.getTokensWithoutWhitespace()[tokenPos].getToken();
            String testPhrase = origToken1 + " " + potentialCompound;
            String hyphenPotentialCompound = token2.getToken() + "-" + nextToken.getToken();
            String hyphenTestPhrase = origToken1 + " " + hyphenPotentialCompound;
            return this.getRuleMatch(token1, sentence, nextToken, testPhrase, hyphenTestPhrase);
        }
        return null;
    }

    @Nullable
    private RuleMatch getCompoundError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, int tokenPos, AnalyzedSentence sentence) {
        AnalyzedTokenReadings nextToken;
        if (tokenPos != -1 && tokenPos + 3 < sentence.getTokensWithoutWhitespace().length && StringTools.startsWithUppercase((String)(nextToken = sentence.getTokensWithoutWhitespace()[tokenPos + 3]).getToken())) {
            String potentialCompound = token3.getToken() + StringTools.lowercaseFirstChar((String)nextToken.getToken());
            String origToken1 = sentence.getTokensWithoutWhitespace()[tokenPos].getToken();
            String testPhrase = origToken1 + " " + token2.getToken() + " " + potentialCompound;
            String hyphenPotentialCompound = token3.getToken() + "-" + nextToken.getToken();
            String hyphenTestPhrase = origToken1 + " " + token2.getToken() + " " + hyphenPotentialCompound;
            return this.getRuleMatch(token1, sentence, nextToken, testPhrase, hyphenTestPhrase);
        }
        return null;
    }

    @Nullable
    private RuleMatch getCompoundError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, AnalyzedTokenReadings token4, int tokenPos, AnalyzedSentence sentence) {
        if (tokenPos != -1 && tokenPos + 4 < sentence.getTokensWithoutWhitespace().length) {
            AnalyzedTokenReadings nextToken = sentence.getTokensWithoutWhitespace()[tokenPos + 4];
            String potentialCompound = token4.getToken() + StringTools.lowercaseFirstChar((String)nextToken.getToken());
            if (StringTools.startsWithUppercase((String)token4.getToken()) && StringTools.startsWithUppercase((String)nextToken.getToken())) {
                String origToken1 = sentence.getTokensWithoutWhitespace()[tokenPos].getToken();
                String testPhrase = origToken1 + " " + token2.getToken() + " " + token3.getToken() + " " + potentialCompound;
                String hyphenPotentialCompound = token4.getToken() + "-" + nextToken.getToken();
                String hyphenTestPhrase = origToken1 + " " + token2.getToken() + " " + token3.getToken() + " " + hyphenPotentialCompound;
                return this.getRuleMatch(token1, sentence, nextToken, testPhrase, hyphenTestPhrase);
            }
        }
        return null;
    }

    @Nullable
    private RuleMatch getRuleMatch(AnalyzedTokenReadings token1, AnalyzedSentence sentence, AnalyzedTokenReadings nextToken, String testPhrase, String hyphenTestPhrase) {
        try {
            this.initLt();
            if (nextToken.getReadings().stream().allMatch(k -> k.getPOSTag() != null && !k.getPOSTag().startsWith("SUB"))) {
                return null;
            }
            ArrayList<String> replacements = new ArrayList<String>();
            if (this.lt.check(testPhrase).isEmpty() && nextToken.isTagged()) {
                replacements.add(testPhrase);
            }
            if (this.lt.check(hyphenTestPhrase).isEmpty() && nextToken.isTagged()) {
                replacements.add(hyphenTestPhrase);
            }
            if (replacements.size() > 0) {
                String message = "Wenn es sich um ein zusammengesetztes Nomen handelt, wird es zusammengeschrieben.";
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), nextToken.getEndPos(), message);
                ruleMatch.addSuggestedReplacements(replacements);
                ruleMatch.setUrl(Tools.getUrl((String)"https://dict.leo.org/grammatik/deutsch/Rechtschreibung/Regeln/Getrennt-zusammen/Nomen.html#grammarAnchor-Nomen-49575"));
                return ruleMatch;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void initLt() {
        if (this.lt == null) {
            this.lt = new JLanguageTool((Language)this.language);
            for (Rule rule : this.lt.getAllActiveRules()) {
                if (rule.getId().equals("DE_AGREEMENT") || rule.getId().equals("GERMAN_SPELLER_RULE")) continue;
                this.lt.disableRule(rule.getId());
            }
        }
    }

    private boolean isException(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        return "allen".equals(token1.getToken()) && "Grund".equals(token2.getToken());
    }

    private List<String> getCategoriesCausingError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        ArrayList<String> categories = new ArrayList<String>();
        List<GrammarCategory> categoriesToCheck = Arrays.asList(GrammarCategory.KASUS, GrammarCategory.GENUS, GrammarCategory.NUMERUS);
        for (GrammarCategory category : categoriesToCheck) {
            if (!this.agreementWithCategoryRelaxation(token1, token2, category)) continue;
            categories.add(category.displayName);
        }
        return categories;
    }

    private RuleMatch checkDetAdjNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, AnalyzedSentence sentence, int tokenPos) {
        if (token3 == null || token3.getToken().length() < 2) {
            return null;
        }
        Set<String> set = this.retainCommonCategories(token1, token2, token3);
        RuleMatch ruleMatch = null;
        if (set.isEmpty()) {
            RuleMatch compoundMatch;
            AnalyzedTokenReadings token4;
            if (token3.getToken().matches("Herr|Frau") && tokenPos + 3 < sentence.getTokensWithoutWhitespace().length && (!(token4 = sentence.getTokensWithoutWhitespace()[tokenPos + 3]).isTagged() || token4.hasPosTagStartingWith("EIG:"))) {
                return null;
            }
            if (tokenPos + 4 < sentence.getTokensWithoutWhitespace().length && (compoundMatch = this.getCompoundError(sentence.getTokensWithoutWhitespace()[tokenPos], sentence.getTokensWithoutWhitespace()[tokenPos + 1], sentence.getTokensWithoutWhitespace()[tokenPos + 2], sentence.getTokensWithoutWhitespace()[tokenPos + 3], tokenPos, sentence)) != null) {
                return compoundMatch;
            }
            compoundMatch = this.getCompoundError(token1, token2, token3, tokenPos, sentence);
            if (compoundMatch != null) {
                return compoundMatch;
            }
            if (token3.hasPartialPosTag("ABK")) {
                return null;
            }
            String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung von Kasus, Numerus oder Genus. Beispiel: 'mein kleiner Haus' statt 'mein kleines Haus'";
            String shortMsg = "Evtl. keine \u00dcbereinstimmung von Kasus, Numerus oder Genus";
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token3.getEndPos(), msg, shortMsg);
        }
        return ruleMatch;
    }

    private boolean agreementWithCategoryRelaxation(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, GrammarCategory categoryToRelax) {
        Set<GrammarCategory> categoryToRelaxSet = categoryToRelax != null ? Collections.singleton(categoryToRelax) : Collections.emptySet();
        Set<String> set1 = AgreementTools.getAgreementCategories(token1, categoryToRelaxSet, true);
        Set<String> set2 = AgreementTools.getAgreementCategories(token2, categoryToRelaxSet, true);
        set1.retainAll(set2);
        return !set1.isEmpty();
    }

    @NotNull
    private Set<String> retainCommonCategories(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3) {
        Set<GrammarCategory> categoryToRelaxSet = Collections.emptySet();
        Set<String> set1 = AgreementTools.getAgreementCategories(token1, categoryToRelaxSet, true);
        boolean skipSol = !VIELE_WENIGE_LOWERCASE.contains(token1.getToken().toLowerCase());
        Set<String> set2 = AgreementTools.getAgreementCategories(token2, categoryToRelaxSet, skipSol);
        Set<String> set3 = AgreementTools.getAgreementCategories(token3, categoryToRelaxSet, true);
        set1.retainAll(set2);
        set1.retainAll(set3);
        return set1;
    }

    private Set<String> getAgreementCategories(AnalyzedTokenReadings aToken) {
        return AgreementTools.getAgreementCategories(aToken, new HashSet<GrammarCategory>(), false);
    }

    static enum ReplacementType {
        Ins,
        Zur;

    }

    static enum GrammarCategory {
        KASUS("Kasus (Fall: Wer/Was, Wessen, Wem, Wen/Was - Beispiel: 'das Fahrrads' statt 'des Fahrrads')"),
        GENUS("Genus (m\u00e4nnlich, weiblich, s\u00e4chlich - Beispiel: 'der Fahrrad' statt 'das Fahrrad')"),
        NUMERUS("Numerus (Einzahl, Mehrzahl - Beispiel: 'das Fahrr\u00e4der' statt 'die Fahrr\u00e4der')");

        private final String displayName;

        private GrammarCategory(String displayName) {
            this.displayName = displayName;
        }
    }
}

